/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import javax.net.ssl.SSLEngine;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.NettyAtmosphereHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

class AtmosphereChannelPipelineFactory
implements ChannelPipelineFactory {
    private final transient NettyAtmosphereHandler nettyAtmosphereHandler;
    private final transient Config config;

    public AtmosphereChannelPipelineFactory(NettyAtmosphereHandler nettyAtmosphereHandler) {
        this.nettyAtmosphereHandler = nettyAtmosphereHandler;
        this.config = nettyAtmosphereHandler.config();
    }

    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.config.sslContext() != null) {
            SSLEngine e = this.config.sslContext().createSSLEngine();
            this.config.sslContextListener().onPostCreate(e);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(e));
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("nettyAtmosphereHandler", (ChannelHandler)this.nettyAtmosphereHandler);
        return pipeline;
    }
}

