/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketUpgradeHandler
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private WebSocket webSocket;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private final List<FunctionWrapper> functions;
    private final List<Decoder<?, ?>> decoders;
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Socket.STATUS status = Socket.STATUS.INIT;
    private final AtomicBoolean errorHandled = new AtomicBoolean();
    private ListenableFuture underlyingFuture;
    private Future connectdFuture;

    public WebSocketTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(new WebSocketUpgradeHandler.Builder());
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug("", t);
        this.status = Socket.STATUS.ERROR;
        this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.status = Socket.STATUS.CLOSE;
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.close();
        }
        if (this.underlyingFuture != null) {
            this.underlyingFuture.done();
        }
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    @Override
    public void error(Throwable t) {
        this.logger.warn("", t);
        TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
    }

    @Override
    public void future(ListenableFuture f) {
        this.underlyingFuture = f;
    }

    @Override
    public void connectedFuture(Future f) {
        this.connectdFuture = f;
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (this.connectdFuture != null) {
            this.connectdFuture.done();
        }
        TransportsUtil.invokeFunction(Event.STATUS, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.STATE.UPGRADE;
        }
        this.logger.debug("Invalid status code {} for WebSocket Handshake", (Object)responseStatus.getStatusCode());
        this.status = Socket.STATUS.ERROR;
        throw new TransportNotSupported(responseStatus.getStatusCode(), responseStatus.getStatusText());
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(Event.HEADERS, this.decoders, this.functions, Map.class, headers.getHeaders(), Event.HEADERS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public WebSocket onCompleted() throws Exception {
        if (this.webSocket == null) {
            this.logger.error("WebSocket Handshake Failed");
            this.status = Socket.STATUS.ERROR;
            return null;
        }
        TransportsUtil.invokeFunction(Event.TRANSPORT, this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        return this.webSocket;
    }

    public void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        this.ok.set(true);
        WebSocketTextListener l = new WebSocketTextListener(){

            public void onMessage(String message) {
                message = message.trim();
                WebSocketTransport.this.logger.trace("{} received {}", (Object)WebSocketTransport.this.name(), (Object)message);
                if (message.length() > 0) {
                    TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                }
            }

            public void onFragment(String fragment, boolean last) {
            }

            public void onOpen(WebSocket websocket) {
                if (WebSocketTransport.this.status.equals((Object)Socket.STATUS.CLOSE)) {
                    return;
                }
                WebSocketTransport.this.closed.set(false);
                Event newStatus = WebSocketTransport.this.status.equals((Object)Socket.STATUS.INIT) ? Event.OPEN : Event.REOPENED;
                WebSocketTransport.this.status = Socket.STATUS.OPEN;
                TransportsUtil.invokeFunction(newStatus, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, newStatus.name(), newStatus.name(), WebSocketTransport.this.resolver);
            }

            public void onClose(WebSocket websocket) {
                if (WebSocketTransport.this.closed.get()) {
                    return;
                }
                WebSocketTransport.this.close();
                if (WebSocketTransport.this.options.reconnect()) {
                    WebSocketTransport.this.status = Socket.STATUS.REOPENED;
                    if (WebSocketTransport.this.options.reconnectInSeconds() > 0) {
                        ScheduledExecutorService e = WebSocketTransport.this.options.runtime().getConfig().reaper();
                        e.schedule(new Runnable(){

                            @Override
                            public void run() {
                                WebSocketTransport.this.reconnect();
                            }
                        }, (long)WebSocketTransport.this.options.reconnectInSeconds(), TimeUnit.SECONDS);
                    } else {
                        WebSocketTransport.this.reconnect();
                    }
                }
            }

            public void onError(Throwable t) {
                WebSocketTransport.this.status = Socket.STATUS.ERROR;
                WebSocketTransport.this.logger.debug("", t);
                WebSocketTransport.this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, t.getClass(), t, Event.ERROR.name(), WebSocketTransport.this.resolver));
            }
        };
        webSocket.addWebSocketListener((WebSocketListener)l);
        l.onOpen(webSocket);
    }

    void reconnect() {
        try {
            this.options.runtime().executeRequest(this.requestBuilder.build(), (AsyncHandler)this);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.WEBSOCKET;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    public final void onFailure(Throwable t) {
        this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    public WebSocket webSocket() {
        return this.webSocket;
    }
}

