/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseBodyPartsInputStream;
import com.ning.http.client.Part;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.FilePart;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.multipart.StringPart;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.UTF8UrlEncoder;
import com.ning.org.jboss.netty.handler.codec.http.CookieDecoder;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpProviderUtils {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String BODY_NOT_COMPUTED = "Response's body hasn't been computed by your AsyncHandler.";
    protected static final ThreadLocal<SimpleDateFormat[]> simpleDateFormat = new ThreadLocal<SimpleDateFormat[]>(){

        @Override
        protected SimpleDateFormat[] initialValue() {
            return new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss Z", Locale.US)};
        }
    };
    static final byte SP = 32;
    static final byte HT = 9;
    static final byte CR = 13;
    static final byte EQUALS = 61;
    static final byte LF = 10;
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte COLON = 58;
    static final byte SEMICOLON = 59;
    static final byte COMMA = 44;
    static final byte DOUBLE_QUOTE = 34;
    static final String PATH = "Path";
    static final String EXPIRES = "Expires";
    static final String MAX_AGE = "Max-Age";
    static final String DOMAIN = "Domain";
    static final String SECURE = "Secure";
    static final String HTTPONLY = "HTTPOnly";
    static final String COMMENT = "Comment";
    static final String COMMENTURL = "CommentURL";
    static final String DISCARD = "Discard";
    static final String PORT = "Port";
    static final String VERSION = "Version";
    static final byte[] EMPTY_BYTE_ARRAY = "".getBytes();

    public static final SimpleDateFormat[] get() {
        return simpleDateFormat.get();
    }

    public static final void validateSupportedScheme(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }

    public static final URI createUri(String u) {
        URI uri = URI.create(u);
        AsyncHttpProviderUtils.validateSupportedScheme(uri);
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (MiscUtil.isNonEmpty(path) && path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        if (!MiscUtil.isNonEmpty(path)) {
            return URI.create(u + "/");
        }
        return uri;
    }

    public static String getBaseUrl(String url) {
        return AsyncHttpProviderUtils.getBaseUrl(AsyncHttpProviderUtils.createUri(url));
    }

    public static final String getBaseUrl(URI uri) {
        String url = uri.getScheme() + "://" + uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    public static final String getAuthority(URI uri) {
        String url = uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    public static final String contentToString(List<HttpResponseBodyPart> bodyParts, String charset) throws UnsupportedEncodingException {
        return new String(AsyncHttpProviderUtils.contentToByte(bodyParts), charset);
    }

    public static final byte[] contentToByte(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        if (bodyParts.size() == 1) {
            return bodyParts.get(0).getBodyPartBytes();
        }
        int size = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            size += body.getBodyPartBytes().length;
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            byte[] bodyBytes = body.getBodyPartBytes();
            System.arraycopy(bodyBytes, 0, bytes, offset, bodyBytes.length);
            offset += bodyBytes.length;
        }
        return bytes;
    }

    public static final InputStream contentToInputStream(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        return bodyParts.isEmpty() ? new ByteArrayInputStream(EMPTY_BYTE_ARRAY) : new HttpResponseBodyPartsInputStream(bodyParts);
    }

    public static final String getHost(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            host = uri.getAuthority();
        }
        return host;
    }

    public static final URI getRedirectUri(URI uri, String location) {
        if (location == null) {
            throw new IllegalArgumentException("URI " + uri + " was redirected to null location");
        }
        URI locationURI = null;
        try {
            locationURI = new URI(location);
        }
        catch (URISyntaxException e) {
            String[] parts = location.split("\\?");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Don't know how to turn this location into a proper URI:" + location, e);
            }
            StringBuilder properUrl = new StringBuilder(location.length()).append(parts[0]).append("?");
            String[] queryParams = parts[1].split("&");
            for (int i = 0; i < queryParams.length; ++i) {
                String queryParam = queryParams[i];
                if (i != 0) {
                    properUrl.append("&");
                }
                String[] nameValue = queryParam.split("=", 2);
                UTF8UrlEncoder.appendEncoded(properUrl, nameValue[0]);
                if (nameValue.length != 2) continue;
                properUrl.append("=");
                UTF8UrlEncoder.appendEncoded(properUrl, nameValue[1]);
            }
            locationURI = URI.create(properUrl.toString());
        }
        URI redirectUri = uri.resolve(locationURI);
        String scheme = redirectUri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equals("ws") && !scheme.equals("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + redirectUri + ", must be equal (ignoring case) to 'ws, 'wss', 'http', or 'https'");
        }
        return redirectUri.normalize();
    }

    public static final int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") || uri.getScheme().equals("ws") ? 80 : 443;
        }
        return port;
    }

    public static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params, FluentCaseInsensitiveStringsMap requestHeaders) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof com.ning.http.multipart.Part) {
                parts[i] = (com.ning.http.multipart.Part)part;
            } else if (part instanceof com.ning.http.client.StringPart) {
                parts[i] = new StringPart(part.getName(), ((com.ning.http.client.StringPart)part).getValue(), ((com.ning.http.client.StringPart)part).getCharset());
            } else if (part instanceof com.ning.http.client.FilePart) {
                parts[i] = new FilePart(part.getName(), ((com.ning.http.client.FilePart)part).getFile(), ((com.ning.http.client.FilePart)part).getMimeType(), ((com.ning.http.client.FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new FilePart(part.getName(), source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, requestHeaders);
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    public static String encodeCookies(Collection<Cookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= 1) {
                AsyncHttpProviderUtils.add(sb, "$Version", 1);
            }
            AsyncHttpProviderUtils.add(sb, cookie.getName(), cookie.getValue());
            if (cookie.getPath() != null) {
                AsyncHttpProviderUtils.add(sb, "$Path", cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                AsyncHttpProviderUtils.add(sb, "$Domain", cookie.getDomain());
            }
            if (cookie.getVersion() < 1 || cookie.getPorts().isEmpty()) continue;
            sb.append('$');
            sb.append(PORT);
            sb.append('=');
            sb.append('\"');
            for (int port : cookie.getPorts()) {
                sb.append(port);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\"');
            sb.append(';');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, String val) {
        if (val == null) {
            AsyncHttpProviderUtils.addQuoted(sb, name, "");
            return;
        }
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    AsyncHttpProviderUtils.addQuoted(sb, name, val);
                    return;
                }
            }
        }
        AsyncHttpProviderUtils.addUnquoted(sb, name, val);
    }

    private static void addUnquoted(StringBuilder sb, String name, String val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
    }

    private static void addQuoted(StringBuilder sb, String name, String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        sb.append('\"');
        sb.append(val.replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append('\"');
        sb.append(';');
    }

    private static void add(StringBuilder sb, String name, int val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
    }

    public static String constructUserAgent(Class<? extends AsyncHttpProvider> httpProvider) {
        StringBuilder b = new StringBuilder("AsyncHttpClient/1.0").append(" ").append("(").append(httpProvider.getSimpleName()).append(" - ").append(System.getProperty("os.name")).append(" - ").append(System.getProperty("os.version")).append(" - ").append(System.getProperty("java.version")).append(" - ").append(Runtime.getRuntime().availableProcessors()).append(" core(s))");
        return b.toString();
    }

    public static String parseCharset(String contentType) {
        for (String part : contentType.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("=")).length <= 1) continue;
            String charset = val[1].trim();
            return charset.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    @Deprecated
    public static Cookie parseCookie(String value) {
        return CookieDecoder.decode(value).iterator().next();
    }

    public static int convertExpireField(String timestring) {
        SimpleDateFormat sdf;
        String trimmedTimeString = AsyncHttpProviderUtils.removeQuotes(timestring.trim());
        long now = System.currentTimeMillis();
        Date date = null;
        SimpleDateFormat[] arr$ = simpleDateFormat.get();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (date = (sdf = arr$[i$]).parse(trimmedTimeString, new ParsePosition(0))) == null; ++i$) {
        }
        if (date != null) {
            long maxAgeMillis = date.getTime() - now;
            return (int)(maxAgeMillis / 1000L) + (maxAgeMillis % 1000L != 0L ? 1 : 0);
        }
        throw new IllegalArgumentException("Not a valid expire field " + trimmedTimeString);
    }

    public static final String removeQuotes(String s) {
        if (MiscUtil.isNonEmpty(s)) {
            int start = 0;
            int end = s.length();
            boolean changed = false;
            if (s.charAt(0) == '\"') {
                changed = true;
                ++start;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                changed = true;
                --end;
            }
            if (changed) {
                s = s.substring(start, end);
            }
        }
        return s;
    }

    public static void checkBodyParts(int statusCode, Collection<HttpResponseBodyPart> bodyParts) {
        if (bodyParts == null || bodyParts.size() == 0) {
            if (statusCode == 204) {
                return;
            }
            throw new IllegalStateException(BODY_NOT_COMPUTED);
        }
    }

    public static String keepAliveHeaderValue(AsyncHttpClientConfig config) {
        return config.getAllowPoolingConnection() ? "keep-alive" : "close";
    }
}

