/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JettyCometSupport.class);
    private final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public JettyCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse response) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        Action action = null;
        if (!c.isResumed() && !c.isPending() && req.getAttribute("doNotSuspend") == null) {
            action = this.suspended(req, response);
            if (action.type() == Action.TYPE.SUSPEND) {
                if (action.timeout() != -1L) {
                    c.suspend(action.timeout());
                } else {
                    c.suspend(0L);
                }
            } else if (action.type() == Action.TYPE.RESUME && !this.resumed.remove(c)) {
                c.reset();
                if (req.getAttribute("org.atmosphere.cpr.AtmosphereServlet.resumedOnTimeout") == null) {
                    this.timedout(req, response);
                } else {
                    this.resumed(req, response);
                }
            }
        } else if (!this.resumed.remove(c) && req.getAttribute("doNotSuspend") == null) {
            c.reset();
            if (req.getAttribute("org.atmosphere.cpr.AtmosphereServlet.resumedOnTimeout") == null) {
                this.timedout(req, response);
            } else {
                this.resumed(req, response);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)r.getRequest(false), null);
            this.resumed.offer(c);
            this.complete(r);
        } else {
            try {
                r.getResponse().flushBuffer();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)r.getRequest(false), null);
        if (!c.isNew()) {
            c.resume();
        } else {
            r.getRequest().setAttribute("doNotSuspend", true);
        }
        return this;
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Continuation c;
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L && (c = ContinuationSupport.getContinuation((HttpServletRequest)req, null)) != null) {
            c.resume();
        }
        return action;
    }
}

