/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntrospectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(IntrospectionUtils.class);
    static Hashtable<Class<?>, Method[]> objectMethods = new Hashtable();
    static Object[] emptyArray = new Object[0];
    static final int dbg = 0;

    public static void execute(Object proxy, String method) throws Exception {
        Class[] params;
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, method, params = new Class[0]);
        if (executeM == null) {
            throw new RuntimeException("No execute in " + proxy.getClass());
        }
        executeM.invoke(proxy, (Object[])null);
    }

    public static void setAttribute(Object proxy, String name, Object value) throws Exception {
        if (proxy instanceof AttributeHolder) {
            ((AttributeHolder)proxy).setAttribute(name, value);
            return;
        }
        Method executeM = null;
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class, Object.class};
        executeM = IntrospectionUtils.findMethod(c, "setAttribute", params);
        if (executeM == null) {
            logger.debug("No setAttribute in {}", proxy.getClass());
            return;
        }
        logger.debug("Setting {}={} in proxy: {}", new Object[]{name, value, proxy});
        executeM.invoke(proxy, name, value);
    }

    public static Object getAttribute(Object proxy, String name) throws Exception {
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class};
        Method executeM = IntrospectionUtils.findMethod(c, "getAttribute", params);
        if (executeM == null) {
            logger.debug("No getAttribute in {}", proxy.getClass());
            return null;
        }
        return executeM.invoke(proxy, name);
    }

    public static ClassLoader getURLClassLoader(URL[] urls, ClassLoader parent) {
        try {
            Class<?> urlCL = Class.forName("java.net.URLClassLoader");
            Class[] paramT = new Class[]{urls.getClass(), ClassLoader.class};
            Method m = IntrospectionUtils.findMethod(urlCL, "newInstance", paramT);
            if (m == null) {
                return null;
            }
            ClassLoader cl = (ClassLoader)m.invoke(urlCL, urls, parent);
            return cl;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            logger.error("failed getting URLClassLoader", (Throwable)ex);
            return null;
        }
    }

    public static final boolean setProperty(Object o, String name, String value) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        return IntrospectionUtils.invokeProperty(o, setter, name, value);
    }

    public static final boolean addProperty(Object o, String name, String value) {
        String setter = "add" + IntrospectionUtils.capitalize(name);
        return IntrospectionUtils.invokeProperty(o, setter, name, value);
    }

    public static final boolean invokeProperty(Object object, String setter, String name, String value) {
        try {
            int i;
            Method[] methods = IntrospectionUtils.findMethods(object.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                methods[i].invoke(object, value);
                return true;
            }
            for (i = 0; i < methods.length; ++i) {
                boolean ok = true;
                if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = new Long(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = new Boolean(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            IntrospectionUtils.debug("Unable to resolve host name:" + value);
                            ok = false;
                        }
                    } else {
                        IntrospectionUtils.debug("Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        methods[i].invoke(object, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(methods[i].getName())) continue;
                if (methods[i].getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = methods[i];
                    continue;
                }
                setPropertyMethodVoid = methods[i];
            }
            if (setPropertyMethodBool != null || setPropertyMethodVoid != null) {
                Object[] params = new Object[]{name, value};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(object, params);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(object, params);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(object, params);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            logger.info("failed, object: " + object + ", setter: " + setter + ", value: " + value, (Throwable)e);
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public static Object getProperty(Object object, String name) {
        String getter = "get" + IntrospectionUtils.capitalize(name);
        String isGetter = "is" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(object.getClass());
            Method getPropertyMethod = null;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (getter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(object, (Object[])null);
                }
                if (isGetter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(object, (Object[])null);
                }
                if (!"getProperty".equals(methods[i].getName())) continue;
                getPropertyMethod = methods[i];
            }
            if (getPropertyMethod != null) {
                Object[] params = new Object[]{name};
                return getPropertyMethod.invoke(object, params);
            }
        }
        catch (IllegalArgumentException e) {
            logger.info("failed, object: " + object + ", name: " + name, (Throwable)e);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static void setProperty(Object object, String name) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(object.getClass());
            Object setPropertyMethod = null;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 0) continue;
                methods[i].invoke(object, new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String replaceProperties(String value, Hashtable<String, String> staticProp, PropertySource[] dynamicProp) {
        int pos;
        if (value.indexOf("$") < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                sb.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String n = value.substring(pos + 2, endName);
            String v = null;
            if (staticProp != null) {
                v = staticProp.get(n);
            }
            if (v == null && dynamicProp != null) {
                for (int i = 0; i < dynamicProp.length && (v = dynamicProp[i].getProperty(n)) == null; ++i) {
                }
            }
            if (v == null) {
                v = "${" + n + "}";
            }
            sb.append(v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void addToClassPath(Vector<URL> cpV, String dir) {
        try {
            String[] cpComp = IntrospectionUtils.getFilesByExt(dir, ".jar");
            if (cpComp != null) {
                int jarCount = cpComp.length;
                for (int i = 0; i < jarCount; ++i) {
                    URL url = IntrospectionUtils.getURL(dir, cpComp[i]);
                    if (url == null) continue;
                    cpV.addElement(url);
                }
            }
        }
        catch (Exception ex) {
            logger.debug("failed to add urls to classpath", (Throwable)ex);
        }
    }

    public static void addToolsJar(Vector<URL> v) {
        try {
            File f = new File(System.getProperty("java.home") + "/../lib/tools.jar");
            if (!f.exists() && (f = new File(System.getProperty("java.home") + "/lib/tools.jar")).exists()) {
                logger.debug("Detected strange java.home value {}, it should point to jre", (Object)System.getProperty("java.home"));
            }
            URL url = new URL("file", "", f.getAbsolutePath());
            v.addElement(url);
        }
        catch (MalformedURLException ex) {
            logger.debug("failed to add tools jar url to vector", (Throwable)ex);
        }
    }

    public static String[] getFilesByExt(String ld, String ext) {
        File dir = new File(ld);
        String[] names = null;
        final String lext = ext;
        if (dir.isDirectory()) {
            names = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return name.endsWith(lext);
                }
            });
        }
        return names;
    }

    public static URL getURL(String base, String file) {
        try {
            File baseF = new File(base);
            File f = new File(baseF, file);
            String path = f.getCanonicalPath();
            if (f.isDirectory()) {
                path = path + "/";
            }
            if (!f.exists()) {
                return null;
            }
            return new URL("file", "", path);
        }
        catch (Exception ex) {
            logger.debug("failed to get url, base: " + base + ", file: " + file, (Throwable)ex);
            return null;
        }
    }

    public static void addJarsFromClassPath(Vector<URL> jars, String cp) throws IOException, MalformedURLException {
        String sep = System.getProperty("path.separator");
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, sep);
            while (st.hasMoreTokens()) {
                URL url;
                File f = new File(st.nextToken());
                String path = f.getCanonicalPath();
                if (f.isDirectory()) {
                    path = path + "/";
                }
                if (jars.contains(url = new URL("file", "", path))) continue;
                jars.addElement(url);
            }
        }
    }

    public static URL[] getClassPath(Vector<URL> v) {
        URL[] urls = new URL[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            urls[i] = v.elementAt(i);
        }
        return urls;
    }

    public static URL[] getClassPath(String dir, String cpath, String cpathProp, boolean addTools) throws IOException, MalformedURLException {
        Vector<URL> jarsV = new Vector<URL>();
        if (dir != null) {
            URL url = IntrospectionUtils.getURL(dir, "classes");
            if (url != null) {
                jarsV.addElement(url);
            }
            IntrospectionUtils.addToClassPath(jarsV, dir);
        }
        if (cpath != null) {
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath);
        }
        if (cpathProp != null) {
            String cpath1 = System.getProperty(cpathProp);
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath1);
        }
        if (addTools) {
            IntrospectionUtils.addToolsJar(jarsV);
        }
        return IntrospectionUtils.getClassPath(jarsV);
    }

    public static boolean processArgs(Object proxy, String[] args) throws Exception {
        String[] args0 = null;
        if (null != IntrospectionUtils.findMethod(proxy.getClass(), "getOptions1", new Class[0])) {
            args0 = (String[])IntrospectionUtils.callMethod0(proxy, "getOptions1");
        }
        if (args0 == null) {
            args0 = IntrospectionUtils.findBooleanSetters(proxy.getClass());
        }
        Hashtable h = null;
        if (null != IntrospectionUtils.findMethod(proxy.getClass(), "getOptionAliases", new Class[0])) {
            h = (Hashtable)IntrospectionUtils.callMethod0(proxy, "getOptionAliases");
        }
        return IntrospectionUtils.processArgs(proxy, args, args0, null, h);
    }

    public static boolean processArgs(Object proxy, String[] args, String[] args0, String[] args1, Hashtable<String, String> aliases) throws Exception {
        block0: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            if (aliases != null && aliases.get(arg) != null) {
                arg = aliases.get(arg);
            }
            if (args0 != null) {
                boolean set = false;
                for (int j = 0; j < args0.length; ++j) {
                    if (!args0[j].equalsIgnoreCase(arg)) continue;
                    IntrospectionUtils.setProperty(proxy, args0[j], "true");
                    set = true;
                    break;
                }
                if (set) continue;
            }
            if (args1 != null) {
                for (int j = 0; j < args1.length; ++j) {
                    if (!args1[j].equalsIgnoreCase(arg)) continue;
                    if (++i >= args.length) {
                        return false;
                    }
                    IntrospectionUtils.setProperty(proxy, arg, args[i]);
                    continue block0;
                }
                continue;
            }
            if (++i >= args.length) {
                return false;
            }
            IntrospectionUtils.setProperty(proxy, arg, args[i]);
        }
        return true;
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static String[] findVoidSetters(Class<?> c) {
        Method[] m = IntrospectionUtils.findMethods(c);
        if (m == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().startsWith("set") || m[i].getParameterTypes().length != 0) continue;
            String arg = m[i].getName().substring(3);
            v.addElement(IntrospectionUtils.unCapitalize(arg));
        }
        String[] s = new String[v.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)v.elementAt(i);
        }
        return s;
    }

    public static String[] findBooleanSetters(Class<?> c) {
        Method[] m = IntrospectionUtils.findMethods(c);
        if (m == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().startsWith("set") || m[i].getParameterTypes().length != 1 || !"boolean".equalsIgnoreCase(m[i].getParameterTypes()[0].getName())) continue;
            String arg = m[i].getName().substring(3);
            v.addElement(IntrospectionUtils.unCapitalize(arg));
        }
        String[] s = new String[v.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)v.elementAt(i);
        }
        return s;
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods = objectMethods.get(c);
        if (methods != null) {
            return methods;
        }
        methods = c.getMethods();
        objectMethods.put(c, methods);
        return methods;
    }

    public static Method findMethod(Class<?> c, String name, Class<?>[] params) {
        Method[] methods = IntrospectionUtils.findMethods(c);
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            Class<?>[] methodParams = methods[i].getParameterTypes();
            if (methodParams == null && (params == null || params.length == 0)) {
                return methods[i];
            }
            if (params == null && (methodParams == null || methodParams.length == 0)) {
                return methods[i];
            }
            if (params.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    public static boolean hasHook(Object obj, String methodN) {
        try {
            Method[] myMethods = IntrospectionUtils.findMethods(obj.getClass());
            for (int i = 0; i < myMethods.length; ++i) {
                Class<?> declaring;
                Class<?> parentOfDeclaring;
                if (!methodN.equals(myMethods[i].getName()) || "java.lang.Object".equals((parentOfDeclaring = (declaring = myMethods[i].getDeclaringClass()).getSuperclass()).getName())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.debug("hasHook() failed", (Throwable)ex);
        }
        return false;
    }

    public static void callMain(Class<?> c, String[] args) throws Exception {
        Class[] p = new Class[]{args.getClass()};
        Method m = c.getMethod("main", p);
        m.invoke(c, new Object[]{args});
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null || param1 == null) {
            IntrospectionUtils.debug("Assert: Illegal params " + target + " " + param1);
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, param1);
    }

    public static Object callMethod0(Object target, String methodN) throws Exception {
        if (target == null) {
            IntrospectionUtils.debug("Assert: Illegal params " + target);
            return null;
        }
        Class[] params = new Class[]{};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, emptyArray);
    }

    public static Object callMethodN(Object target, String methodN, Object[] params, Class<?>[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target.getClass(), methodN, typeParams);
        if (m == null) {
            IntrospectionUtils.debug("Can't find method " + methodN + " in " + target + " CLASS " + target.getClass());
            return null;
        }
        Object o = m.invoke(target, params);
        return o;
    }

    public static Object convert(String object, Class<?> paramType) {
        Object result = null;
        if ("java.lang.String".equals(paramType.getName())) {
            result = object;
        } else if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
            try {
                result = new Integer(object);
            }
            catch (NumberFormatException ex) {}
        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
            result = new Boolean(object);
        } else if ("java.net.InetAddress".equals(paramType.getName())) {
            try {
                result = InetAddress.getByName(object);
            }
            catch (UnknownHostException exc) {
                IntrospectionUtils.debug("Unable to resolve host name:" + object);
            }
        } else {
            IntrospectionUtils.debug("Unknown type " + paramType.getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Can't convert argument: " + object);
        }
        return result;
    }

    static void debug(String s) {
        logger.debug("IntrospectionUtils: {}", (Object)s);
    }

    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

