/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class TrafficCounter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficCounter.class);
    private final AtomicLong currentWrittenBytes = new AtomicLong();
    private final AtomicLong currentReadBytes = new AtomicLong();
    private long writingTime;
    private long readingTime;
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    private long lastCumulativeTime;
    private long lastWriteThroughput;
    private long lastReadThroughput;
    final AtomicLong lastTime = new AtomicLong();
    private volatile long lastWrittenBytes;
    private volatile long lastReadBytes;
    private volatile long lastWritingTime;
    private volatile long lastReadingTime;
    private final AtomicLong realWrittenBytes = new AtomicLong();
    private long realWriteThroughput;
    final AtomicLong checkInterval = new AtomicLong(1000L);
    final String name;
    final AbstractTrafficShapingHandler trafficShapingHandler;
    final Timer timer;
    TimerTask timerTask;
    volatile Timeout timeout;
    volatile boolean monitorActive;

    public static final long milliSecondFromNano() {
        return System.nanoTime() / 1000000L;
    }

    public void start() {
        if (this.monitorActive) {
            return;
        }
        this.lastTime.set(TrafficCounter.milliSecondFromNano());
        if (this.checkInterval.get() > 0L && this.timer != null) {
            this.monitorActive = true;
            this.timerTask = new TrafficMonitoringTask(this.trafficShapingHandler, this);
            this.timeout = this.timer.newTimeout(this.timerTask, this.checkInterval.get(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (!this.monitorActive) {
            return;
        }
        this.monitorActive = false;
        this.resetAccounting(TrafficCounter.milliSecondFromNano());
        if (this.trafficShapingHandler != null) {
            this.trafficShapingHandler.doAccounting(this);
        }
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    void resetAccounting(long newLastTime) {
        long interval = newLastTime - this.lastTime.getAndSet(newLastTime);
        if (interval == 0L) {
            return;
        }
        this.lastReadBytes = this.currentReadBytes.getAndSet(0L);
        this.lastWrittenBytes = this.currentWrittenBytes.getAndSet(0L);
        this.lastReadThroughput = this.lastReadBytes * 1000L / interval;
        this.lastWriteThroughput = this.lastWrittenBytes * 1000L / interval;
        this.realWriteThroughput = this.realWrittenBytes.getAndSet(0L) * 1000L / interval;
        this.lastWritingTime = Math.max(this.lastWritingTime, this.writingTime);
        this.lastReadingTime = Math.max(this.lastReadingTime, this.readingTime);
    }

    public TrafficCounter(AbstractTrafficShapingHandler trafficShapingHandler, Timer timer, String name, long checkInterval) {
        if (trafficShapingHandler == null) {
            throw new IllegalArgumentException("TrafficShapingHandler must not be null");
        }
        this.trafficShapingHandler = trafficShapingHandler;
        this.timer = timer;
        this.name = name;
        this.lastCumulativeTime = System.currentTimeMillis();
        this.readingTime = this.writingTime = TrafficCounter.milliSecondFromNano();
        this.lastWritingTime = this.writingTime;
        this.lastReadingTime = this.writingTime;
        this.configure(checkInterval);
    }

    public void configure(long newcheckInterval) {
        long newInterval = newcheckInterval / 10L * 10L;
        if (this.checkInterval.getAndSet(newInterval) != newInterval) {
            if (newInterval <= 0L) {
                this.stop();
                this.lastTime.set(TrafficCounter.milliSecondFromNano());
            } else {
                this.start();
            }
        }
    }

    void bytesRecvFlowControl(long recv) {
        this.currentReadBytes.addAndGet(recv);
        this.cumulativeReadBytes.addAndGet(recv);
    }

    void bytesWriteFlowControl(long write) {
        this.currentWrittenBytes.addAndGet(write);
        this.cumulativeWrittenBytes.addAndGet(write);
    }

    void bytesRealWriteFlowControl(long write) {
        this.realWrittenBytes.addAndGet(write);
    }

    public long getCheckInterval() {
        return this.checkInterval.get();
    }

    public long getLastReadThroughput() {
        return this.lastReadThroughput;
    }

    public long getLastWriteThroughput() {
        return this.lastWriteThroughput;
    }

    public long getLastReadBytes() {
        return this.lastReadBytes;
    }

    public long getLastWrittenBytes() {
        return this.lastWrittenBytes;
    }

    public long getCurrentReadBytes() {
        return this.currentReadBytes.get();
    }

    public long getCurrentWrittenBytes() {
        return this.currentWrittenBytes.get();
    }

    public long getLastTime() {
        return this.lastTime.get();
    }

    public long getCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    public long getCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public long getLastCumulativeTime() {
        return this.lastCumulativeTime;
    }

    public AtomicLong getRealWrittenBytes() {
        return this.realWrittenBytes;
    }

    public long getRealWriteThroughput() {
        return this.realWriteThroughput;
    }

    public void resetCumulativeTime() {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.cumulativeReadBytes.set(0L);
        this.cumulativeWrittenBytes.set(0L);
    }

    @Deprecated
    public long readTimeToWait(long size, long limitTraffic, long maxTime) {
        return this.readTimeToWait(size, limitTraffic, maxTime, TrafficCounter.milliSecondFromNano());
    }

    public long readTimeToWait(long size, long limitTraffic, long maxTime, long now) {
        this.bytesRecvFlowControl(size);
        if (size == 0L || limitTraffic == 0L) {
            return 0L;
        }
        long lastTimeCheck = this.lastTime.get();
        long sum = this.currentReadBytes.get();
        long localReadingTime = this.readingTime;
        long lastRB = this.lastReadBytes;
        long interval = now - lastTimeCheck;
        long pastDelay = Math.max(this.lastReadingTime - lastTimeCheck, 0L);
        if (interval > 10L) {
            long time = (sum * 1000L / limitTraffic - interval + pastDelay) / 10L * 10L;
            if (time > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + time + ":" + sum + ":" + interval + ":" + pastDelay);
                }
                if (time > maxTime && now + time - localReadingTime > maxTime) {
                    time = maxTime;
                }
                this.readingTime = Math.max(localReadingTime, now + time);
                return time;
            }
            this.readingTime = Math.max(localReadingTime, now);
            return 0L;
        }
        long lastsum = sum + lastRB;
        long lastinterval = interval + this.checkInterval.get();
        long time = (lastsum * 1000L / limitTraffic - lastinterval + pastDelay) / 10L * 10L;
        if (time > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + time + ":" + lastsum + ":" + lastinterval + ":" + pastDelay);
            }
            if (time > maxTime && now + time - localReadingTime > maxTime) {
                time = maxTime;
            }
            this.readingTime = Math.max(localReadingTime, now + time);
            return time;
        }
        this.readingTime = Math.max(localReadingTime, now);
        return 0L;
    }

    @Deprecated
    public long writeTimeToWait(long size, long limitTraffic, long maxTime) {
        return this.writeTimeToWait(size, limitTraffic, maxTime, TrafficCounter.milliSecondFromNano());
    }

    public long writeTimeToWait(long size, long limitTraffic, long maxTime, long now) {
        this.bytesWriteFlowControl(size);
        if (size == 0L || limitTraffic == 0L) {
            return 0L;
        }
        long lastTimeCheck = this.lastTime.get();
        long sum = this.currentWrittenBytes.get();
        long lastWB = this.lastWrittenBytes;
        long localWritingTime = this.writingTime;
        long pastDelay = Math.max(this.lastWritingTime - lastTimeCheck, 0L);
        long interval = now - lastTimeCheck;
        if (interval > 10L) {
            long time = (sum * 1000L / limitTraffic - interval + pastDelay) / 10L * 10L;
            if (time > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + time + ":" + sum + ":" + interval + ":" + pastDelay);
                }
                if (time > maxTime && now + time - localWritingTime > maxTime) {
                    time = maxTime;
                }
                this.writingTime = Math.max(localWritingTime, now + time);
                return time;
            }
            this.writingTime = Math.max(localWritingTime, now);
            return 0L;
        }
        long lastsum = sum + lastWB;
        long lastinterval = interval + this.checkInterval.get();
        long time = (lastsum * 1000L / limitTraffic - lastinterval + pastDelay) / 10L * 10L;
        if (time > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + time + ":" + lastsum + ":" + lastinterval + ":" + pastDelay);
            }
            if (time > maxTime && now + time - localWritingTime > maxTime) {
                time = maxTime;
            }
            this.writingTime = Math.max(localWritingTime, now + time);
            return time;
        }
        this.writingTime = Math.max(localWritingTime, now);
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return new StringBuilder(165).append("Monitor ").append(this.name).append(" Current Speed Read: ").append(this.lastReadThroughput >> 10).append(" KB/s, ").append("Asked Write: ").append(this.lastWriteThroughput >> 10).append(" KB/s, ").append("Real Write: ").append(this.realWriteThroughput >> 10).append(" KB/s, ").append("Current Read: ").append(this.currentReadBytes.get() >> 10).append(" KB, ").append("Current asked Write: ").append(this.currentWrittenBytes.get() >> 10).append(" KB, ").append("Current real Write: ").append(this.realWrittenBytes.get() >> 10).append(" KB").toString();
    }

    private static final class TrafficMonitoringTask
    implements TimerTask {
        private final AbstractTrafficShapingHandler trafficShapingHandler1;
        private final TrafficCounter counter;

        protected TrafficMonitoringTask(AbstractTrafficShapingHandler trafficShapingHandler, TrafficCounter counter) {
            this.trafficShapingHandler1 = trafficShapingHandler;
            this.counter = counter;
        }

        public void run(Timeout timeout) throws Exception {
            if (!this.counter.monitorActive) {
                return;
            }
            this.counter.resetAccounting(TrafficCounter.milliSecondFromNano());
            if (this.trafficShapingHandler1 != null) {
                this.trafficShapingHandler1.doAccounting(this.counter);
            }
            this.counter.timer.newTimeout(this, this.counter.checkInterval.get(), TimeUnit.MILLISECONDS);
        }
    }
}

