/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.ExecutorsFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ChannelBufferPool {
    private final ConcurrentLinkedQueue<ChannelBuffer> pool = new ConcurrentLinkedQueue();
    private int writeBufferPoolSize = 50;

    public ChannelBufferPool(int minIdle) {
        this.initialize(minIdle);
    }

    public ChannelBufferPool(final int minIdle, final int writeBufferPoolSize, long validationInterval, AtmosphereConfig config) {
        this.writeBufferPoolSize = writeBufferPoolSize;
        this.initialize(minIdle);
        if (writeBufferPoolSize != -1) {
            ExecutorsFactory.getScheduler((AtmosphereConfig)config).scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        int size;
                        block2: {
                            size = ChannelBufferPool.this.pool.size();
                            if (size >= minIdle) break block2;
                            int sizeToBeAdded = minIdle - size;
                            for (int i = 0; i < sizeToBeAdded; ++i) {
                                ChannelBufferPool.this.pool.add(ChannelBufferPool.this.createObject());
                            }
                            break block3;
                        }
                        if (size <= writeBufferPoolSize) break block3;
                        int sizeToBeRemoved = size - writeBufferPoolSize;
                        for (int i = 0; i < sizeToBeRemoved; ++i) {
                            ChannelBufferPool.this.pool.poll();
                        }
                    }
                }
            }, validationInterval, validationInterval, TimeUnit.SECONDS);
            config.shutdownHook(new AtmosphereConfig.ShutdownHook(){

                public void shutdown() {
                    ChannelBufferPool.this.pool.clear();
                }
            });
        }
    }

    public ChannelBuffer poll() {
        ChannelBuffer channelBuffer = this.pool.poll();
        if (channelBuffer == null) {
            channelBuffer = this.createObject();
        }
        return channelBuffer;
    }

    public void offer(ChannelBuffer channelBuffer) {
        if (channelBuffer == null || this.writeBufferPoolSize == -1) {
            return;
        }
        channelBuffer.clear();
        this.pool.offer(channelBuffer);
    }

    protected ChannelBuffer createObject() {
        return ChannelBuffers.dynamicBuffer();
    }

    private void initialize(int minIdle) {
        for (int i = 0; i < minIdle; ++i) {
            this.pool.add(this.createObject());
        }
    }
}

