package org.atnos.eff.syntax

import cats._
import org.atnos.eff._
import MemoEffect._

object memoseq extends memoseq

trait memoseq {

  implicit def toMemoSequenceEffectOps[R, A](e: Eff[R, A]): MemoSequenceEffectOps[R, A] = new MemoSequenceEffectOps[R, A](e)

}

final class MemoSequenceEffectOps[R, A](val e: Eff[R, A]) extends AnyVal {

  def runMemoSequence[U](cache: SequenceCache)(implicit member: Member.Aux[MemoizedSeq, R, U], eval: Eval |= U): Eff[U, A] =
    MemoSequenceEffect.runMemoSequence(cache)(e)(member, eval)

  def runAsyncMemoSequence[U](cache: SequenceCache)(implicit member: Member.Aux[MemoizedSeq, R, U], async: Async |= U): Eff[U, A] =
    MemoSequenceEffect.runAsyncMemoSequence(cache)(e)(member, async)

}

