/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax.generators;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.atpfivt.jsyntrax.generators.elements.Element;
import org.atpfivt.jsyntrax.styles.NodeStyle;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.util.Pair;
import org.atpfivt.jsyntrax.util.StringUtils;

public class SVGCanvas {
    private final StyleConfig style;
    private final HashMap<String, Integer> tagcnt = new HashMap();
    private final ArrayList<Element> elements = new ArrayList();

    public SVGCanvas(StyleConfig style) {
        this.style = style;
    }

    public String newTag(String prefix, String suffix) {
        String f = prefix + "___" + suffix;
        Integer value = this.tagcnt.getOrDefault(f, 0);
        this.tagcnt.put(f, value + 1);
        return prefix + value.toString() + suffix;
    }

    public void addElement(Element e) {
        this.elements.add(e);
    }

    public void addTagByTag(String addTag, String tag) {
        for (Element e : this.elements) {
            if (!e.isTagged(tag)) continue;
            e.addTag(addTag);
        }
    }

    public void dropTag(String tag) {
        for (Element e : this.elements) {
            if (!e.isTagged(tag)) continue;
            e.delTag(tag);
        }
    }

    public void moveByTag(String tag, int dx, int dy) {
        for (Element e : this.elements) {
            if (!e.isTagged(tag)) continue;
            Pair<Integer, Integer> pair = e.getStart();
            Integer.valueOf((Integer)pair.f + dx);
            pair.f = pair.f;
            pair = e.getStart();
            Integer.valueOf((Integer)pair.s + dy);
            pair.s = pair.s;
            pair = e.getEnd();
            Integer.valueOf((Integer)pair.f + dx);
            pair.f = pair.f;
            pair = e.getEnd();
            Integer.valueOf((Integer)pair.s + dy);
            pair.s = pair.s;
        }
    }

    public void scaleByTag(String tag, double scale) {
        for (Element e : this.elements) {
            if (!e.isTagged(tag)) continue;
            e.scale(scale);
        }
    }

    public Optional<String> getCanvasTag() {
        return this.elements.stream().findAny().flatMap(Element::getAnyTag);
    }

    public Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> getBoundingBoxByTag(String tag) {
        Pair<Integer, Integer> start = null;
        Pair<Integer, Integer> end = null;
        for (Element e : this.elements) {
            if (!e.isTagged(tag)) continue;
            if (start == null) {
                start = new Pair<Integer, Integer>(e.getStart());
                end = new Pair<Integer, Integer>(e.getEnd());
            }
            start.f = Math.min((Integer)start.f, (Integer)e.getStart().f);
            start.f = Math.min((Integer)start.f, (Integer)e.getEnd().f);
            start.s = Math.min((Integer)start.s, (Integer)e.getStart().s);
            start.s = Math.min((Integer)start.s, (Integer)e.getEnd().s);
            end.f = Math.max((Integer)end.f, (Integer)e.getStart().f);
            end.f = Math.max((Integer)end.f, (Integer)e.getEnd().f);
            end.s = Math.max((Integer)end.s, (Integer)e.getStart().s);
            end.s = Math.max((Integer)end.s, (Integer)e.getEnd().s);
        }
        return new Pair<Object, Object>(start, end);
    }

    public String generateSVG() {
        StringBuilder sb = new StringBuilder();
        double scale = this.style.getScale();
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> res = this.getBoundingBoxByTag("all");
        this.moveByTag("all", -((Integer)((Pair)res.f).f).intValue(), -((Integer)((Pair)res.f).s).intValue());
        this.scaleByTag("all", scale);
        this.moveByTag("all", this.style.getPadding(), this.style.getPadding());
        res = this.getBoundingBoxByTag("all");
        Pair end = (Pair)res.s;
        int w = (Integer)end.f + this.style.getPadding();
        int h = (Integer)end.s + this.style.getPadding();
        HashMap<Object, Pair<Font, Color>> fonts = new HashMap<Object, Pair<Font, Color>>();
        fonts.put("title_font", new Pair<Font, Color>(this.style.getTitleFont(), this.style.getTextColor()));
        for (NodeStyle nodeStyle : this.style.getNodeStyles()) {
            fonts.put(nodeStyle.getName() + "_font", new Pair<Font, Color>(nodeStyle.getFont(), nodeStyle.getTextColor()));
        }
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n").append("<!-- Created by Jyntrax https://github.com/atp-mipt/jsyntrax -->\n");
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\"\n");
        sb.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        sb.append("xml:space=\"preserve\"\n");
        sb.append("width=\"").append(w).append("\" ").append("height=\"").append(h).append("\" ").append("version=\"1.1\">\n");
        sb.append("<style type=\"text/css\">\n");
        sb.append("<![CDATA[\n");
        for (Map.Entry entry : fonts.entrySet()) {
            String fontName = (String)entry.getKey();
            String fontFamily = ((Font)((Pair)entry.getValue()).f).getName();
            String fontSize = Integer.toString((int)((double)((Font)((Pair)entry.getValue()).f).getSize() * scale));
            String fontWeight = "normal";
            if ((((Font)((Pair)entry.getValue()).f).getStyle() & 1) == 1) {
                fontWeight = "bold";
            }
            String fontStyle = "normal";
            if ((((Font)((Pair)entry.getValue()).f).getStyle() & 2) == 2) {
                fontStyle = "italic";
            }
            String hex = StringUtils.toHex((Color)((Pair)entry.getValue()).s);
            sb.append(".").append(fontName).append(" ");
            sb.append("{fill:").append(hex).append("; text-anchor:middle;\n");
            sb.append("font-family:").append(fontFamily).append("; ");
            sb.append("font-size:").append(fontSize).append("pt; ");
            sb.append("font-weight:").append(fontWeight).append("; ");
            sb.append("font-style:").append(fontStyle).append("; ");
            sb.append("}\n");
        }
        sb.append(".label {fill: #000; text-anchor:middle; font-size:16pt; font-weight:bold; font-family:Sans;}\n");
        sb.append(".link {fill: #0D47A1;}\n");
        sb.append(".link:hover {fill: #0D47A1; text-decoration:underline;}\n");
        sb.append(".link:visited {fill: #4A148C;}\n");
        sb.append("]]>\n</style>\n");
        sb.append("<defs>\n");
        sb.append("<marker id=\"arrow\" markerWidth=\"5\" markerHeight=\"4\" ").append("refX=\"2.5\" refY=\"2\" orient=\"auto\" markerUnits=\"strokeWidth\">\n");
        String hex = StringUtils.toHex(this.style.getLineColor());
        sb.append("<path d=\"M0,0 L0.5,2 L0,4 L4.5,2 z\" fill=\"").append(hex).append("\" />\n");
        sb.append("</marker>\n</defs>\n");
        if (!this.style.isTransparent()) {
            sb.append("<rect width=\"100%\" height=\"100%\" fill=\"white\"/>\n");
        }
        for (Element e : this.elements) {
            if (this.style.isShadow()) {
                e.addShadow(sb, this.style);
            }
            e.toSVG(sb, this.style);
        }
        sb.append("</svg>\n");
        return sb.toString();
    }
}

