/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.batik.transcoder.TranscoderException;
import org.atpfivt.jsyntrax.Configuration;
import org.atpfivt.jsyntrax.InputArguments;
import org.atpfivt.jsyntrax.generators.SVGCanvas;
import org.atpfivt.jsyntrax.generators.SVGCanvasBuilder;
import org.atpfivt.jsyntrax.groovy_parser.Parser;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.util.SVGTranscoder;
import org.codehaus.groovy.control.CompilationFailedException;

public final class Main {
    public static final String JSYNTRAX_INI = "jsyntrax.ini";

    private Main() {
    }

    public static void main(String ... args) throws IOException {
        String scriptText;
        StyleConfig style;
        InputArguments iArgs;
        try {
            iArgs = new InputArguments(args);
        }
        catch (Exception e) {
            System.out.println("Got exception when parsing input arguments:");
            System.out.println("\t" + e.getMessage());
            InputArguments.writeHelp(new PrintWriter(System.out));
            return;
        }
        String version = iArgs.getVersion();
        if (version != null) {
            System.out.println(iArgs.getVersion());
            return;
        }
        if (iArgs.getDefaultStyleProperty()) {
            String config = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("/jsyntrax.ini"))).lines().collect(Collectors.joining("\n")) + "\n";
            Path destPath = Paths.get(System.getProperty("user.dir"), JSYNTRAX_INI);
            if (Files.exists(destPath, new LinkOption[0])) {
                System.out.printf("Ini file \"%s\" exists%n", JSYNTRAX_INI);
            } else {
                System.out.printf("Creating ini with default styles in \"%s\"%n", JSYNTRAX_INI);
                Files.write(destPath, config.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            return;
        }
        if (iArgs.isHelp()) {
            InputArguments.writeHelp(new PrintWriter(System.out));
            return;
        }
        if (!Main.checkPathsFromArgs(iArgs)) {
            return;
        }
        try {
            style = Main.getStyleConfig(iArgs);
        }
        catch (IOException e) {
            System.out.println("Failed parsing style file.");
            System.out.println("Error: " + e.getMessage());
            return;
        }
        try {
            scriptText = new String(Files.readAllBytes(iArgs.getInput()));
        }
        catch (IOException e) {
            System.out.println("Failed to read: " + e.getMessage());
            return;
        }
        String result = Main.generateSVG(iArgs.getTitle(), style, scriptText);
        if (result == null) {
            return;
        }
        try {
            Path output = iArgs.getOutput();
            if (output.toString().toLowerCase().endsWith(".png")) {
                Files.write(output, SVGTranscoder.svg2Png(result), new OpenOption[0]);
            } else {
                Files.write(output, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to write: " + e.getMessage());
            return;
        }
        catch (TranscoderException e) {
            System.out.println("Failed to transcode .svg image: " + e.getMessage());
        }
        System.out.println("Done!");
    }

    public static StyleConfig getStyleConfig(InputArguments args) throws IOException {
        if (args.getStyle() != null) {
            return new StyleConfig(args.getScale(), args.isTransparent(), args.getStyle());
        }
        return new StyleConfig(args.getScale(), args.isTransparent());
    }

    public static String generateSVG(String title, StyleConfig style, String scriptText) throws IOException {
        Configuration root;
        try {
            root = Parser.parse(scriptText);
        }
        catch (CompilationFailedException e) {
            System.out.println("Something is wrong with input script:");
            System.out.println("\t" + e.getMessage());
            return null;
        }
        SVGCanvas c = new SVGCanvasBuilder().withStyle(style).withTitle(title).generateSVG(root);
        return c.generateSVG();
    }

    static boolean checkPathsFromArgs(InputArguments iArgs) {
        Path input = iArgs.getInput();
        Path output = iArgs.getOutput();
        Path style = iArgs.getStyle();
        if (input == null || !Files.isRegularFile(input, new LinkOption[0]) || !Files.isReadable(input)) {
            System.out.printf("Cannot read input file %s%n", input);
            return false;
        }
        if (output == null) {
            System.out.println("No output file set");
            return false;
        }
        if (!Files.exists(output, new LinkOption[0])) {
            try {
                Files.createFile(output, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.printf("Can't create file %s%n", output);
                return false;
            }
            System.out.printf("Output file %s was created%n", output);
        }
        if (!Files.isRegularFile(output, new LinkOption[0]) || !Files.isWritable(output)) {
            System.out.printf("Cannot write to %s%n", output);
            return false;
        }
        if (!(style == null || Files.isRegularFile(style, new LinkOption[0]) && Files.isReadable(style))) {
            System.out.printf("Cannot read style file %s%n", style);
            return false;
        }
        return true;
    }
}

