/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax.generators;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.atpfivt.jsyntrax.Configuration;
import org.atpfivt.jsyntrax.generators.SVGCanvas;
import org.atpfivt.jsyntrax.generators.elements.ArcElement;
import org.atpfivt.jsyntrax.generators.elements.BoxBubbleElement;
import org.atpfivt.jsyntrax.generators.elements.BubbleElement;
import org.atpfivt.jsyntrax.generators.elements.BubbleElementBase;
import org.atpfivt.jsyntrax.generators.elements.HexBubbleElement;
import org.atpfivt.jsyntrax.generators.elements.LineElement;
import org.atpfivt.jsyntrax.generators.elements.OvalElement;
import org.atpfivt.jsyntrax.generators.elements.TitleElement;
import org.atpfivt.jsyntrax.styles.NodeStyle;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.units.Unit;
import org.atpfivt.jsyntrax.units.nodes.Bullet;
import org.atpfivt.jsyntrax.units.nodes.Node;
import org.atpfivt.jsyntrax.units.nodes.NoneNode;
import org.atpfivt.jsyntrax.units.tracks.Choice;
import org.atpfivt.jsyntrax.units.tracks.Line;
import org.atpfivt.jsyntrax.units.tracks.loop.Loop;
import org.atpfivt.jsyntrax.units.tracks.loop.Toploop;
import org.atpfivt.jsyntrax.units.tracks.opt.Opt;
import org.atpfivt.jsyntrax.units.tracks.opt.Optx;
import org.atpfivt.jsyntrax.units.tracks.stack.Indentstack;
import org.atpfivt.jsyntrax.units.tracks.stack.Rightstack;
import org.atpfivt.jsyntrax.units.tracks.stack.Stack;
import org.atpfivt.jsyntrax.util.Pair;
import org.atpfivt.jsyntrax.visitors.Visitor;

public final class SVGCanvasBuilder
implements Visitor {
    private Map<String, String> urlMap;
    private StyleConfig style = new StyleConfig(1.0, false);
    private SVGCanvas canvas;
    private UnitEndPoint unitEndPoint;
    private boolean ltor;
    private Integer indent;
    private String title;

    public SVGCanvasBuilder() throws IOException {
        this.urlMap = Collections.emptyMap();
    }

    public SVGCanvasBuilder withStyle(StyleConfig style) {
        this.style = style;
        return this;
    }

    public SVGCanvasBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public SVGCanvas generateSVG(Unit root) {
        this.canvas = new SVGCanvas(this.style);
        this.parseDiagram(new Line(new ArrayList<Unit>(List.of(new Bullet(), root, new Bullet()))), true);
        if (this.title == null) {
            return this.canvas;
        }
        String tag = this.canvas.getCanvasTag().orElse(null);
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> bbox = this.canvas.getBoundingBoxByTag(tag);
        String titleTag = this.canvas.newTag("x", "-title");
        TitleElement e = new TitleElement(this.title, this.style.getTitleFont(), "title_font", titleTag);
        this.canvas.addElement(e);
        switch (this.style.getTitlePos()) {
            case bl: 
            case tl: {
                this.canvas.moveByTag(titleTag, 2 * this.style.getPadding(), 0);
                break;
            }
            case bm: 
            case tm: {
                this.canvas.moveByTag(titleTag, ((Integer)((Pair)bbox.f).f + (Integer)((Pair)bbox.s).f - (Integer)e.getEnd().f) / 2 - 2 * this.style.getPadding(), 0);
                break;
            }
            case br: 
            case tr: {
                this.canvas.moveByTag(titleTag, (Integer)((Pair)bbox.s).f - (Integer)e.getEnd().f - 2 * this.style.getPadding(), 0);
            }
        }
        switch (this.style.getTitlePos()) {
            case tl: 
            case tm: 
            case tr: {
                this.canvas.moveByTag(tag, 0, (Integer)e.getEnd().s + 2 * this.style.getPadding());
                break;
            }
            case bl: 
            case bm: 
            case br: {
                this.canvas.moveByTag(titleTag, 0, (Integer)((Pair)bbox.s).s + 2 * this.style.getPadding());
            }
        }
        return this.canvas;
    }

    private void parseDiagram(Unit unit, boolean ltor) {
        if (null == unit) {
            this.setUnitEndPoint(null);
            return;
        }
        this.setLtor(ltor);
        unit.accept(this);
    }

    private UnitEndPoint getDiagramParseResult(Unit unit, boolean ltor) {
        this.parseDiagram(unit, ltor);
        return this.getUnitEndPoint();
    }

    @Override
    public void visitNoneNode(NoneNode unit) {
        String tag = this.canvas.newTag("x", "");
        LineElement e = new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(1, 0), null, this.style.getOutlineWidth(), tag);
        e.setStart(new Pair<Integer, Integer>(0, 0));
        e.setEnd(new Pair<Integer, Integer>(1, 0));
        this.canvas.addElement(e);
        this.setUnitEndPoint(new UnitEndPoint(tag, e.getEnd()));
    }

    @Override
    public void visitConfiguration(Configuration unit) {
        this.urlMap = unit.getUrlMap();
        unit.getTrack().accept(this);
    }

    @Override
    public void visitNode(Node unit) {
        BubbleElementBase b;
        Pair<Integer, Integer> end;
        Pair<Integer, Integer> start;
        String txt = unit.toString();
        NodeStyle ns = this.style.getNodeStyle(txt);
        txt = ns.unwrapTextContent(txt);
        Font font = ns.getFont();
        String fontName = ns.getName() + "_font";
        Color fill = ns.getFill();
        Color textColor = ns.getTextColor();
        Pair<Integer, Integer> textSize = SVGCanvasBuilder.getTextSize(txt, font);
        int x0 = -((Integer)textSize.f).intValue() / 2;
        int y0 = -((Integer)textSize.s).intValue() / 2;
        int x1 = x0 + (Integer)textSize.f;
        int y1 = y0 + (Integer)textSize.s;
        int h = y1 - y0 + 1;
        int rad = (h + 1) / 2;
        int lft = x0;
        int rgt = x1;
        int top = y1 - 2 * rad;
        if (ns.getShape().equals("bubble") || ns.getShape().equals("hex")) {
            lft += rad / 2 - 2;
            rgt -= rad / 2 - 2;
        } else {
            lft -= 5;
            rgt += 5;
        }
        if (lft > rgt) {
            rgt = lft = (x0 + x1) / 2;
        }
        String tag = this.canvas.newTag("x", "-box");
        String href = this.urlMap.get(txt);
        switch (ns.getShape()) {
            case "bubble": {
                start = new Pair<Integer, Integer>(lft - rad, top);
                end = new Pair<Integer, Integer>(rgt + rad, y1);
                b = new BubbleElement(start, end, href, txt, new Pair<Integer, Integer>(x0, y0), font, fontName, textColor, this.style.getOutlineWidth(), fill, tag);
                break;
            }
            case "hex": {
                start = new Pair<Integer, Integer>(lft - rad, top);
                end = new Pair<Integer, Integer>(rgt + rad, y1);
                b = new HexBubbleElement(start, end, href, txt, new Pair<Integer, Integer>(x0, y0), font, fontName, textColor, this.style.getOutlineWidth(), fill, tag);
                break;
            }
            default: {
                start = new Pair<Integer, Integer>(lft, top);
                end = new Pair<Integer, Integer>(rgt, y1);
                b = new BoxBubbleElement(start, end, href, txt, new Pair<Integer, Integer>(x0, y0), font, fontName, textColor, this.style.getOutlineWidth(), fill, tag);
            }
        }
        this.canvas.addElement(b);
        x0 = (Integer)start.f;
        x1 = (Integer)end.f;
        int width = x1 - x0;
        this.canvas.moveByTag(tag, -x0, 2);
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(width, 0)));
    }

    @Override
    public void visitBullet(Bullet unit) {
        String tag = this.canvas.newTag("x", "");
        int w = this.style.getOutlineWidth();
        int r = w + 1;
        this.canvas.addElement(new OvalElement(new Pair<Integer, Integer>(0, -r), new Pair<Integer, Integer>(2 * r, r), w, this.style.getBulletFill(), tag));
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(2 * r, 0)));
    }

    @Override
    public void visitLine(Line line) {
        boolean ltor = this.getLtor();
        String tag = this.canvas.newTag("x", "");
        int sep = this.style.getHSep();
        int width = this.style.getLineWidth();
        Pair<Integer, Integer> pos = new Pair<Integer, Integer>(0, 0);
        int unitNum = 0;
        int unitStep = 1;
        int size = line.getUnits().size();
        if (!ltor) {
            unitNum = size - 1;
            unitStep = -1;
        }
        while (0 <= unitNum && unitNum < size) {
            Unit unit = line.getUnits().get(unitNum);
            UnitEndPoint endPoint = this.getDiagramParseResult(unit, ltor);
            if (endPoint != null) {
                if ((Integer)pos.f != 0) {
                    int xn = (Integer)pos.f + sep;
                    this.canvas.moveByTag(endPoint.tag, xn, (Integer)pos.s);
                    LineElement l = new LineElement(new Pair<Integer, Integer>((Integer)pos.f - 1, (Integer)pos.s), new Pair<Integer, Integer>(xn, (Integer)pos.s), ltor ? "last" : "first", width, tag);
                    this.canvas.addElement(l);
                    pos.f = xn + (Integer)endPoint.endpoint.f;
                } else {
                    pos.f = endPoint.endpoint.f;
                }
                pos.s = endPoint.endpoint.s;
                this.canvas.addTagByTag(tag, endPoint.tag);
                this.canvas.dropTag(endPoint.tag);
            }
            unitNum += unitStep;
        }
        if ((Integer)pos.f == 0) {
            pos.f = sep * 2;
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(sep, 0), null, width, tag));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(sep, 0), new Pair<Integer, Integer>((Integer)pos.f, 0), "last", width, tag));
            pos.f = sep;
        }
        this.setUnitEndPoint(new UnitEndPoint(tag, pos));
    }

    @Override
    public void visitToploop(Toploop loop) {
        int mxx;
        boolean ltor = this.getLtor();
        String tag = this.canvas.newTag("x", "");
        int sep = this.style.getVSep();
        int vsep = sep / 2;
        UnitEndPoint fEndPoint = this.getDiagramParseResult(loop.getForwardPart(), ltor);
        String ft = fEndPoint.tag;
        int fexx = (Integer)fEndPoint.endpoint.f;
        int fexy = (Integer)fEndPoint.endpoint.s;
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> fBox = this.canvas.getBoundingBoxByTag(ft);
        int fx0 = (Integer)((Pair)fBox.f).f;
        int fy0 = (Integer)((Pair)fBox.f).s;
        int fx1 = (Integer)((Pair)fBox.s).f;
        UnitEndPoint bEndPoint = this.getDiagramParseResult(loop.getBackwardPart(), !ltor);
        String bt = bEndPoint.tag;
        int bexx = (Integer)bEndPoint.endpoint.f;
        int bexy = (Integer)bEndPoint.endpoint.s;
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> bBox = this.canvas.getBoundingBoxByTag(bt);
        int bx0 = (Integer)((Pair)bBox.f).f;
        int bx1 = (Integer)((Pair)bBox.s).f;
        int by1 = (Integer)((Pair)bBox.s).s;
        int fw = fx1 - fx0;
        int bw = bx1 - bx0;
        int dy = -(by1 - fy0 + vsep);
        this.canvas.moveByTag(bt, 0, dy);
        bexy += dy;
        int dx = Math.abs(fw - bw) / 2;
        if (fw > bw) {
            this.canvas.moveByTag(bt, dx, 0);
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, dy), new Pair<Integer, Integer>(dx, dy), null, this.style.getLineWidth(), bt));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bexx += dx, bexy), new Pair<Integer, Integer>(fx1, bexy), ltor || dx < 2 * vsep ? null : "first", this.style.getLineWidth(), bt));
            mxx = fexx;
        } else if (bw > fw) {
            this.canvas.moveByTag(ft, dx, 0);
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(dx, fexy), null, this.style.getLineWidth(), ft));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(fexx += dx, fexy), new Pair<Integer, Integer>(bx1, fexy), null, this.style.getLineWidth(), ft));
            mxx = bexx;
        } else {
            mxx = fexx;
        }
        this.canvas.addTagByTag(tag, bt);
        this.canvas.addTagByTag(tag, ft);
        this.canvas.dropTag(bt);
        this.canvas.dropTag(ft);
        this.canvas.moveByTag(tag, sep, 0);
        this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(sep, 0), null, this.style.getLineWidth(), tag));
        this.drawLeftTurnBack(tag, sep, 0, dy, ltor ? "up" : "down");
        this.drawRightTurnBack(tag, mxx += sep, fexy, bexy, ltor ? "down" : "up");
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> box = this.canvas.getBoundingBoxByTag(tag);
        int x1 = (Integer)((Pair)box.s).f;
        this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(mxx, fexy), new Pair<Integer, Integer>(x1, fexy), null, this.style.getLineWidth(), tag));
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(x1, fexy)));
    }

    @Override
    public void visitLoop(Loop loop) {
        int mxx;
        int dx;
        boolean ltor = this.getLtor();
        String tag = this.canvas.newTag("x", "");
        int sep = this.style.getVSep();
        int vsep = sep / 2;
        UnitEndPoint fEndPoint = this.getDiagramParseResult(loop.getForwardPart(), ltor);
        String ft = fEndPoint.tag;
        int fexx = (Integer)fEndPoint.endpoint.f;
        int fexy = (Integer)fEndPoint.endpoint.s;
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> fBox = this.canvas.getBoundingBoxByTag(ft);
        int fx0 = (Integer)((Pair)fBox.f).f;
        int fx1 = (Integer)((Pair)fBox.s).f;
        int fy1 = (Integer)((Pair)fBox.s).s;
        UnitEndPoint bEndPoint = this.getDiagramParseResult(loop.getBackwardPart(), !ltor);
        String bt = bEndPoint.tag;
        int bexx = (Integer)bEndPoint.endpoint.f;
        int bexy = (Integer)bEndPoint.endpoint.s;
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> bBox = this.canvas.getBoundingBoxByTag(bt);
        int bx0 = (Integer)((Pair)bBox.f).f;
        int by0 = (Integer)((Pair)bBox.f).s;
        int bx1 = (Integer)((Pair)bBox.s).f;
        int fw = fx1 - fx0;
        int bw = bx1 - bx0;
        int dy = fy1 - by0 + vsep;
        this.canvas.moveByTag(bt, 0, dy);
        bexy += dy;
        if (fw > bw) {
            if (fexx < fw && fexx >= bw) {
                dx = (fexx - bw) / 2;
                this.canvas.moveByTag(bt, dx, 0);
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, dy), new Pair<Integer, Integer>(dx, dy), null, this.style.getLineWidth(), bt));
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bexx += dx, bexy), new Pair<Integer, Integer>(fexx, bexy), "first", this.style.getLineWidth(), bt));
            } else {
                dx = (fw - bw) / 2;
                this.canvas.moveByTag(bt, dx, 0);
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, dy), new Pair<Integer, Integer>(dx, dy), ltor || dx < 2 * vsep ? null : "last", this.style.getLineWidth(), bt));
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bexx += dx, bexy), new Pair<Integer, Integer>(fx1, bexy), !ltor || dx < 2 * vsep ? null : "first", this.style.getLineWidth(), bt));
            }
            mxx = fexx;
        } else if (bw > fw) {
            dx = (bw - fw) / 2;
            this.canvas.moveByTag(ft, dx, 0);
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(dx, fexy), ltor ? "last" : "first", this.style.getLineWidth(), ft));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(fexx += dx, fexy), new Pair<Integer, Integer>(bx1, fexy), null, this.style.getLineWidth(), ft));
            mxx = bexx;
        } else {
            mxx = fexx;
        }
        this.canvas.addTagByTag(tag, bt);
        this.canvas.addTagByTag(tag, ft);
        this.canvas.dropTag(bt);
        this.canvas.dropTag(ft);
        this.canvas.moveByTag(tag, sep, 0);
        this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(sep, 0), null, this.style.getLineWidth(), tag));
        this.drawLeftTurnBack(tag, sep, 0, dy, ltor ? "up" : "down");
        this.drawRightTurnBack(tag, mxx += sep, fexy, bexy, ltor ? "down" : "up");
        int exitX = mxx + this.style.getMaxRadius();
        this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(mxx, fexy), new Pair<Integer, Integer>(exitX, fexy), null, this.style.getLineWidth(), tag));
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(exitX, fexy)));
    }

    @Override
    public void visitChoice(Choice choice) {
        boolean ltor = this.getLtor();
        String tag = this.canvas.newTag("x", "");
        int sep = this.style.getVSep();
        int vsep = sep / 2;
        int n = choice.getUnits().size();
        if (n == 0) {
            this.setUnitEndPoint(null);
            return;
        }
        ArrayList<UnitEndPoint> res = new ArrayList<UnitEndPoint>();
        int mxw = 0;
        for (int i = 0; i < n; ++i) {
            res.add(this.getDiagramParseResult(choice.getUnits().get(i), ltor));
            Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> box = this.canvas.getBoundingBoxByTag(((UnitEndPoint)res.get((int)i)).tag);
            int w = (Integer)((Pair)box.s).f - (Integer)((Pair)box.f).f;
            if (i != 0) {
                w += 20;
            }
            mxw = Math.max(mxw, w);
        }
        int x2 = sep * 2;
        int x3 = mxw + x2;
        int x4 = x3 + sep;
        int x5 = x4 + sep;
        int exy = 0;
        int btm = 0;
        for (int i = 0; i < n; ++i) {
            String t = ((UnitEndPoint)res.get((int)i)).tag;
            int texx = (Integer)((UnitEndPoint)res.get((int)i)).endpoint.f;
            int texy = (Integer)((UnitEndPoint)res.get((int)i)).endpoint.s;
            Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> box = this.canvas.getBoundingBoxByTag(t);
            int w = (Integer)((Pair)box.s).f - (Integer)((Pair)box.f).f;
            int dx = (mxw - w) / 2 + x2;
            if (w > 10 && dx > x2 + 10) {
                dx = x2 + 10;
            }
            this.canvas.moveByTag(t, dx, 0);
            texx += dx;
            box = this.canvas.getBoundingBoxByTag(t);
            int ty0 = (Integer)((Pair)box.f).s;
            int ty1 = (Integer)((Pair)box.s).s;
            if (i == 0) {
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(dx, 0), ltor && dx > x2 ? "last" : null, this.style.getLineWidth(), tag));
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(texx, texy), new Pair<Integer, Integer>(x5 + 1, texy), ltor ? null : "first", this.style.getLineWidth(), tag));
                exy = texy;
                this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(-sep, 0), new Pair<Integer, Integer>(sep, sep * 2), this.style.getLineWidth(), 90, -90, tag));
                btm = ty1;
            } else {
                int dy = Math.max(btm - ty0 + vsep, 2 * sep);
                this.canvas.moveByTag(t, 0, dy);
                texy += dy;
                if (dx > x2) {
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(x2, dy), new Pair<Integer, Integer>(dx, dy), ltor ? "last" : null, this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(texx, texy), new Pair<Integer, Integer>(x3, texy), ltor ? null : "first", this.style.getLineWidth(), tag));
                }
                int y1 = dy - 2 * sep;
                this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(sep, y1), new Pair<Integer, Integer>(sep + 2 * sep, dy), this.style.getLineWidth(), 180, 90, tag));
                int y2 = texy - 2 * sep;
                this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(x3 - sep, y2), new Pair<Integer, Integer>(x4, texy), this.style.getLineWidth(), 270, 90, tag));
                if (i + 1 == n) {
                    this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(x4, exy), new Pair<Integer, Integer>(x4 + 2 * sep, exy + 2 * sep), this.style.getLineWidth(), 180, -90, tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(sep, dy - sep), new Pair<Integer, Integer>(sep, sep), null, this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(x4, texy - sep), new Pair<Integer, Integer>(x4, exy + sep), null, this.style.getLineWidth(), tag));
                }
                btm = ty1 + dy;
            }
            this.canvas.addTagByTag(tag, t);
            this.canvas.dropTag(t);
        }
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(x5, exy)));
    }

    @Override
    public void visitOptx(final Optx opt) {
        boolean ltor = this.getLtor();
        Choice c = new Choice((List<Unit>)new ArrayList<Unit>(){
            {
                this.add(new Line(opt.getUnits()));
                this.add(new NoneNode());
            }
        });
        this.parseDiagram(c, ltor);
    }

    @Override
    public void visitOpt(final Opt opt) {
        boolean ltor = this.getLtor();
        Choice c = new Choice((List<Unit>)new ArrayList<Unit>(){
            {
                this.add(new NoneNode());
                this.add(new Line(opt.getUnits()));
            }
        });
        this.parseDiagram(c, ltor);
    }

    private void parseStack(Stack stack) {
        int midY;
        boolean ltor = this.getLtor();
        String tag = this.canvas.newTag("x", "");
        int sep = this.style.getVSep() * 2;
        int btm = 0;
        int n = stack.getUnits().size();
        if (n == 0) {
            this.setUnitEndPoint(null);
            return;
        }
        int nextBypassY = 0;
        int bypassX = 0;
        int exitX = 0;
        int exitY = 0;
        boolean bypass = false;
        for (int i = 0; i < n; ++i) {
            Unit term;
            Unit unit = stack.getUnits().get(i);
            int bypassY = nextBypassY;
            if (i != 0 && this.indent >= 0 && unit.getUnits().size() != 0 && unit instanceof Opt) {
                bypass = true;
                term = new Line(unit.getUnits());
            } else {
                bypass = false;
                term = unit;
                nextBypassY = 0;
            }
            UnitEndPoint ep = this.getDiagramParseResult(term, ltor);
            String t = ep.tag;
            int exx = (Integer)ep.endpoint.f;
            int exy = (Integer)ep.endpoint.s;
            Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> box = this.canvas.getBoundingBoxByTag(t);
            int tx0 = (Integer)((Pair)box.f).f;
            int ty0 = (Integer)((Pair)box.f).s;
            int tx1 = (Integer)((Pair)box.s).f;
            if (i == 0) {
                exitX = exx;
                exitY = exy;
            } else {
                int enterX;
                int enterY = btm - ty0 + sep * 2 + 2;
                if (bypass) {
                    nextBypassY = enterY - this.style.getMaxRadius();
                }
                if (this.indent < 0) {
                    int w = tx1 - tx0;
                    enterX = exitX - w + sep * this.indent;
                    int ex2 = sep * 2 - this.indent;
                    if (ex2 > enterX) {
                        enterX = ex2;
                    }
                } else {
                    enterX = sep * 2 + this.indent;
                }
                int backY = btm + sep + 1;
                if (bypassY > 0) {
                    midY = (bypassY + this.style.getMaxRadius() + backY) / 2;
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bypassX, bypassY), new Pair<Integer, Integer>(bypassX, midY), "last", this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bypassX, midY), new Pair<Integer, Integer>(bypassX, backY + this.style.getMaxRadius()), null, this.style.getLineWidth(), tag));
                }
                this.canvas.moveByTag(t, enterX, enterY);
                int e2 = exitX + sep;
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(exitX, exitY), new Pair<Integer, Integer>(e2, exitY), null, this.style.getLineWidth(), tag));
                this.drawRightTurnBack(tag, e2, exitY, backY, "down");
                int e3 = enterX - sep;
                bypassX = e3 - this.style.getMaxRadius();
                int emid = (e2 + e3) / 2;
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(e2, backY), new Pair<Integer, Integer>(emid, backY), "last", this.style.getLineWidth(), tag));
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(emid, backY), new Pair<Integer, Integer>(e3, backY), null, this.style.getLineWidth(), tag));
                this.drawLeftTurnBack(tag, e3, backY, enterY, "down");
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(e3, enterY), new Pair<Integer, Integer>(enterX, enterY), "last", this.style.getLineWidth(), tag));
                exitX = enterX + exx;
                exitY = enterY + exy;
            }
            this.canvas.addTagByTag(tag, t);
            this.canvas.dropTag(t);
            btm = (Integer)((Pair)this.canvas.getBoundingBoxByTag((String)tag).s).s;
        }
        if (bypass) {
            int fwdY = btm + sep + 1;
            midY = (nextBypassY + this.style.getMaxRadius() + fwdY) / 2;
            int descenderX = exitX + this.style.getMaxRadius();
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bypassX, nextBypassY), new Pair<Integer, Integer>(bypassX, midY), "last", this.style.getLineWidth(), tag));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bypassX, midY), new Pair<Integer, Integer>(bypassX, fwdY - this.style.getMaxRadius()), null, this.style.getLineWidth(), tag));
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(bypassX, fwdY - 2 * this.style.getMaxRadius()), new Pair<Integer, Integer>(bypassX + 2 * this.style.getMaxRadius(), fwdY), this.style.getLineWidth(), 180, 90, tag));
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(exitX - this.style.getMaxRadius(), exitY), new Pair<Integer, Integer>(descenderX, exitY + 2 * this.style.getMaxRadius()), this.style.getLineWidth(), 90, -90, tag));
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(descenderX, fwdY - 2 * this.style.getMaxRadius()), new Pair<Integer, Integer>(descenderX + 2 * this.style.getMaxRadius(), fwdY), this.style.getLineWidth(), 180, 90, tag));
            int halfX = ((exitX += 2 * this.style.getMaxRadius()) + this.indent) / 2;
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(bypassX + this.style.getMaxRadius(), fwdY), new Pair<Integer, Integer>(halfX, fwdY), "last", this.style.getLineWidth(), tag));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(halfX, fwdY), new Pair<Integer, Integer>(exitX, fwdY), null, this.style.getLineWidth(), tag));
            this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(descenderX, exitY + this.style.getMaxRadius()), new Pair<Integer, Integer>(descenderX, fwdY - this.style.getMaxRadius()), "last", this.style.getLineWidth(), tag));
            exitY = fwdY;
        }
        this.setUnitEndPoint(new UnitEndPoint(tag, new Pair<Integer, Integer>(exitX, exitY)));
    }

    @Override
    public void visitStack(Stack stack) {
        this.setIndent(0);
        this.parseStack(stack);
    }

    @Override
    public void visitRightstack(Rightstack unit) {
        this.setIndent(-1);
        this.parseStack(unit);
    }

    @Override
    public void visitIndentstack(Indentstack unit) {
        int sep = this.style.getHSep() * unit.getIndent();
        this.setIndent(sep);
        this.parseStack(unit);
    }

    private void drawLeftTurnBack(String tag, int x, int yy0, int yy1, String flow) {
        int y0 = Math.min(yy0, yy1);
        int y1 = Math.max(yy0, yy1);
        if (y1 - y0 > 3 * this.style.getMaxRadius()) {
            int xr0 = x - this.style.getMaxRadius();
            int xr1 = x + this.style.getMaxRadius();
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(xr0, y0), new Pair<Integer, Integer>(xr1, y0 + 2 * this.style.getMaxRadius()), this.style.getLineWidth(), 90, 90, tag));
            int yr0 = y0 + this.style.getMaxRadius();
            int yr1 = y1 - this.style.getMaxRadius();
            if (Math.abs(yr1 - yr0) > 2 * this.style.getMaxRadius()) {
                int halfY = (yr0 + yr1) / 2;
                if ("down".equals(flow)) {
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr0, yr0), new Pair<Integer, Integer>(xr0, halfY), "last", this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr0, halfY), new Pair<Integer, Integer>(xr0, yr1), null, this.style.getLineWidth(), tag));
                } else {
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr0, yr1), new Pair<Integer, Integer>(xr0, halfY), "last", this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr0, halfY), new Pair<Integer, Integer>(xr0, yr0), null, this.style.getLineWidth(), tag));
                }
            } else {
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr0, yr0), new Pair<Integer, Integer>(xr0, yr1), null, this.style.getLineWidth(), tag));
            }
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(xr0, y1 - 2 * this.style.getMaxRadius()), new Pair<Integer, Integer>(xr1, y1), this.style.getLineWidth(), 180, 90, tag));
        } else {
            int r = (y1 - y0) / 2;
            int x0 = x - r;
            int x1 = x + r;
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(x0, y0), new Pair<Integer, Integer>(x1, y1), this.style.getLineWidth(), 90, 180, tag));
        }
    }

    private void drawRightTurnBack(String tag, int x, int yy0, int yy1, String flow) {
        int y0 = Math.min(yy0, yy1);
        int y1 = Math.max(yy0, yy1);
        if (y1 - y0 > 3 * this.style.getMaxRadius()) {
            int xr0 = x - this.style.getMaxRadius();
            int xr1 = x + this.style.getMaxRadius();
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(xr0, y0), new Pair<Integer, Integer>(xr1, y0 + 2 * this.style.getMaxRadius()), this.style.getLineWidth(), 90, -90, tag));
            int yr0 = y0 + this.style.getMaxRadius();
            int yr1 = y1 - this.style.getMaxRadius();
            if (Math.abs(yr1 - yr0) > 2 * this.style.getMaxRadius()) {
                int halfY = (yr1 + yr0) / 2;
                if ("down".equals(flow)) {
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr1, yr0), new Pair<Integer, Integer>(xr1, halfY), "last", this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr1, halfY), new Pair<Integer, Integer>(xr1, yr1), null, this.style.getLineWidth(), tag));
                } else {
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr1, yr1), new Pair<Integer, Integer>(xr1, halfY), "last", this.style.getLineWidth(), tag));
                    this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr1, halfY), new Pair<Integer, Integer>(xr1, yr0), null, this.style.getLineWidth(), tag));
                }
            } else {
                this.canvas.addElement(new LineElement(new Pair<Integer, Integer>(xr1, yr0), new Pair<Integer, Integer>(xr1, yr1), null, this.style.getLineWidth(), tag));
            }
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(xr0, y1 - 2 * this.style.getMaxRadius()), new Pair<Integer, Integer>(xr1, y1), this.style.getLineWidth(), 0, -90, tag));
        } else {
            int r = (y1 - y0) / 2;
            int x0 = x - r;
            int x1 = x + r;
            this.canvas.addElement(new ArcElement(new Pair<Integer, Integer>(x0, y0), new Pair<Integer, Integer>(x1, y1), this.style.getLineWidth(), 90, -180, tag));
        }
    }

    public static Pair<Integer, Integer> getTextSize(String text, Font font) {
        Rectangle2D r = font.getStringBounds(text, new FontRenderContext(null, true, true));
        return new Pair<Integer, Integer>((int)(r.getMaxX() - r.getMinX() + (double)text.length() + 10.0), (int)(r.getMaxY() - r.getMinY() + 10.0));
    }

    public UnitEndPoint getUnitEndPoint() {
        return this.unitEndPoint;
    }

    public void setUnitEndPoint(UnitEndPoint unitEndPoint) {
        this.unitEndPoint = unitEndPoint;
    }

    public boolean getLtor() {
        return this.ltor;
    }

    public void setLtor(boolean ltor) {
        this.ltor = ltor;
    }

    public Integer getIndent() {
        return this.indent;
    }

    public void setIndent(Integer indent) {
        this.indent = indent;
    }

    public static class UnitEndPoint {
        public String tag;
        public Pair<Integer, Integer> endpoint;

        UnitEndPoint(String tag, Pair<Integer, Integer> endpoint) {
            this.tag = tag;
            this.endpoint = endpoint;
        }
    }
}

