/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.attribyte.api.InitializationException;
import org.attribyte.sql.pool.ConnectionPool;

public class ConnectionPoolDataSource
implements DataSource {
    private volatile boolean isShutdown;
    private final ConnectionPool pool;
    private PrintWriter sourceLogWriter = null;
    private int sourceTimeoutSeconds;

    public ConnectionPoolDataSource(ConnectionPool.Initializer initializer) throws InitializationException, SQLException {
        this(initializer.createPool());
    }

    public ConnectionPoolDataSource(ConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.pool.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.pool.getConnection();
    }

    @Override
    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.sourceLogWriter;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        this.pool.setDataSourceLogWriter(out);
        this.sourceLogWriter = out;
    }

    @Override
    public synchronized void setLoginTimeout(int sourceTimeoutSeconds) throws SQLException {
        this.pool.setDataSourceLoginTimeout(sourceTimeoutSeconds);
        this.sourceTimeoutSeconds = sourceTimeoutSeconds;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.sourceTimeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Parent logger ");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

