/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.google.common.base.Strings;
import javax.sql.DataSource;
import org.attribyte.api.InitializationException;

public class JDBConnection {
    static final String SQLSTATE_CONNECTION_FAILURE = "08006";
    static final String SQLSTATE_CONNECTION_EXCEPTION = "08000";
    static final String SQLSTATE_INVALID_TRANSACTION_STATE = "25000";
    final String name;
    final String user;
    final String password;
    final String connectionString;
    final String testSQL;
    final long testIntervalMillis;
    final long createTimeoutMillis;
    final DataSource datasource;
    final boolean debug;

    public JDBConnection(String name, String user, String password, String connectionString, long createTimeoutMillis, String testSQL, long testIntervalMillis, boolean debug) {
        this.name = name;
        this.user = user;
        this.password = password;
        this.connectionString = connectionString;
        this.createTimeoutMillis = createTimeoutMillis;
        this.testSQL = testSQL;
        this.testIntervalMillis = testIntervalMillis;
        this.datasource = null;
        this.debug = debug;
    }

    public JDBConnection(String name, String user, String password, DataSource datasource, long createTimeoutMillis, String testSQL, long testIntervalMillis, boolean debug) {
        this.name = name;
        this.user = user;
        this.password = password;
        this.connectionString = null;
        this.createTimeoutMillis = createTimeoutMillis;
        this.testSQL = testSQL;
        this.datasource = datasource;
        this.testIntervalMillis = testIntervalMillis;
        this.debug = debug;
    }

    public void validate() throws InitializationException {
        if (Strings.isNullOrEmpty((String)this.connectionString) && this.datasource == null) {
            throw new InitializationException("Either a 'connectionString' or DataSource must be specified");
        }
    }

    final String getConnectionDescription() {
        if (this.datasource != null) {
            return this.name;
        }
        String description = this.connectionString;
        int index = this.connectionString.indexOf(63);
        if (index > 0) {
            description = this.connectionString.substring(0, index);
        }
        if (!Strings.isNullOrEmpty((String)this.user)) {
            return this.user + "@" + description;
        }
        return description;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.connectionString != null) {
            buf.append(this.user).append("@").append(this.connectionString);
        } else if (this.datasource != null) {
            buf.append("DataSource: ").append(this.datasource.toString());
        }
        if (this.testSQL != null) {
            buf.append(", ").append(this.testSQL);
        }
        if (this.testIntervalMillis > 0L) {
            buf.append(", test interval = ").append(this.testIntervalMillis);
        }
        return buf.toString();
    }

    public static class Initializer {
        String name;
        String user;
        String password;
        String connectionString;
        String testSQL;
        long testIntervalMillis = 60000L;
        long createTimeoutMillis = 60000L;
        DataSource datasource;
        boolean debug = false;

        public Initializer setName(String name) {
            this.name = name;
            return this;
        }

        public Initializer setUser(String user) {
            this.user = user;
            return this;
        }

        public Initializer setPassword(String password) {
            this.password = password;
            return this;
        }

        public Initializer setConnectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public Initializer setTestSQL(String testSQL) {
            this.testSQL = testSQL;
            return this;
        }

        public Initializer setTestIntervalMillis(long testIntervalMillis) {
            this.testIntervalMillis = testIntervalMillis;
            return this;
        }

        public Initializer setCreateTimeoutMillis(long createTimeoutMillis) {
            this.createTimeoutMillis = createTimeoutMillis;
            return this;
        }

        public Initializer setDatasource(DataSource datasource) {
            this.datasource = datasource;
            return this;
        }

        public Initializer setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public JDBConnection createConnection() {
            if (this.datasource == null) {
                return new JDBConnection(this.name, this.user, this.password, this.connectionString, this.createTimeoutMillis, this.testSQL, this.testIntervalMillis, this.debug);
            }
            return new JDBConnection(this.name, this.user, this.password, this.datasource, this.createTimeoutMillis, this.testSQL, this.testIntervalMillis, this.debug);
        }
    }
}

