/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.concurrent.ThreadFactory;

final class Util {
    static final String NEW_LINE = System.getProperty("line.separator");

    Util() {
    }

    static final void throwException(Throwable t) throws SQLException {
        Util.throwException(t, null);
    }

    static final void throwException(Throwable t, String message) throws SQLException {
        if (t != null) {
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (message != null) {
                throw new SQLException(message, t);
            }
            throw new SQLException(t);
        }
    }

    static final boolean isRuntimeError(Throwable t) {
        return t != null && (t instanceof Error || t instanceof RuntimeException);
    }

    static final String getStack() {
        return Util.getStack(false);
    }

    static final String getFilteredStack() {
        return Util.getStack(true);
    }

    static final String getStack(boolean filter) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stack.length; ++i) {
            if (!filter) {
                buf.append(stack[i].toString());
                buf.append(NEW_LINE);
                continue;
            }
            String s = stack[i].toString();
            if (s.startsWith("org.attribyte.sql.pool")) continue;
            buf.append(s);
            buf.append(NEW_LINE);
        }
        return buf.toString();
    }

    static ThreadFactory createThreadFactoryBuilder(String baseName, String componentName) {
        StringBuilder buf = new StringBuilder("ACP:");
        if (!Strings.isNullOrEmpty((String)baseName)) {
            buf.append(baseName).append(":").append(componentName);
        } else {
            buf.append(componentName);
        }
        buf.append("-Thread-%d");
        return new ThreadFactoryBuilder().setNameFormat(buf.toString()).build();
    }
}

