/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MemoryInfo
implements MetricSet,
Runnable {
    private final ImmutableMap<String, Metric> metrics;
    private volatile CurrentMemValues currValues = new CurrentMemValues();

    public MemoryInfo(Collection<String> registerKeys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (final String key : registerKeys) {
            builder.put((Object)this.filterKey(key), (Object)new Gauge<Long>(){

                public Long getValue() {
                    Long val = (Long)((MemoryInfo)MemoryInfo.this).currValues.fields.get((Object)key);
                    return val != null ? val : 0L;
                }
            });
        }
        this.metrics = builder.build();
    }

    private String filterKey(String key) {
        return key.toLowerCase();
    }

    @Override
    public void run() {
        this.currValues = new CurrentMemValues();
    }

    public CurrentMemValues values() {
        return new CurrentMemValues();
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public static class CurrentMemValues {
        public final ImmutableMap<String, Long> fields;
        private static final String PATH = "/proc/meminfo";
        private static final Splitter tokenSplitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": \t")).trimResults().omitEmptyStrings();

        private CurrentMemValues() {
            File pathFile = new File(PATH);
            if (pathFile.exists()) {
                ImmutableMap _fields;
                try {
                    ImmutableList lines = Files.asCharSource((File)new File(PATH), (Charset)Charsets.US_ASCII).readLines();
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (String line : lines) {
                        Iterator tok = tokenSplitter.split((CharSequence)line).iterator();
                        if (!tok.hasNext()) continue;
                        String key = (String)tok.next();
                        if (!tok.hasNext()) continue;
                        long val = Long.parseLong((String)tok.next());
                        builder.put((Object)key, (Object)val);
                    }
                    _fields = builder.build();
                }
                catch (IOException | NumberFormatException e) {
                    _fields = ImmutableMap.of();
                }
                this.fields = _fields;
            } else {
                this.fields = ImmutableMap.of();
            }
        }
    }
}

