/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Map;

public class Storage {
    public final ImmutableList<Filesystem> filesystems;

    public Storage() throws IOException {
        FileSystem fileSystem = FileSystems.getDefault();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileStore store : fileSystem.getFileStores()) {
            Filesystem system = new Filesystem(store);
            builder.add((Object)system);
        }
        this.filesystems = builder.build();
    }

    public static class Filesystem
    implements MetricSet {
        public final String name;
        public final String type;
        private final ImmutableMap<String, Metric> metrics;

        private Filesystem(final FileStore store) {
            this.name = this.cleanName(store.name());
            this.type = store.type();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"total", (Object)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getTotalSpace();
                    }
                    catch (IOException ioe) {
                        return 0L;
                    }
                }
            });
            builder.put((Object)"usable", (Object)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getUsableSpace();
                    }
                    catch (IOException ioe) {
                        return 0L;
                    }
                }
            });
            builder.put((Object)"unallocated", (Object)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getUnallocatedSpace();
                    }
                    catch (IOException ioe) {
                        return 0L;
                    }
                }
            });
            this.metrics = builder.build();
        }

        public Map<String, Metric> getMetrics() {
            return this.metrics;
        }

        private String cleanName(String name) {
            return name.startsWith("/") ? name.substring(1) : name;
        }
    }
}

