/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.attribyte.essem.sysmon.linux.KeyFilter;
import org.attribyte.essem.sysmon.linux.LoadAverage;
import org.attribyte.essem.sysmon.linux.MemoryInfo;
import org.attribyte.essem.sysmon.linux.NetworkDevices;
import org.attribyte.essem.sysmon.linux.Storage;
import org.slf4j.Logger;

public class SystemMonitor
implements MetricSet {
    private final ImmutableMap<String, Metric> metrics;
    private final ScheduledExecutorService scheduler;
    public static final ImmutableList<String> DEFAULT_MEMINFO_KEYS = ImmutableList.of((Object)"MemTotal", (Object)"MemFree", (Object)"Buffers", (Object)"Cached", (Object)"SwapCached", (Object)"Active", (Object)"Inactive", (Object)"SwapTotal", (Object)"SwapFree");
    public static final KeyFilter DEFAULT_STORAGE_TYPES = new KeyFilter.AcceptSet((Set<String>)ImmutableSet.of((Object)"minix", (Object)"ext", (Object)"ext2", (Object)"ext3", (Object)"ext4", (Object)"Reiserfs", (Object[])new String[]{"XFS", "JFS", "xia", "msdos", "umsdos", "vfat", "ntfs", "nfs", "iso9660", "hpfs", "sysv", "smb", "ncpfs"}));
    static final KeyFilter defaultInterfaceFilter = new KeyFilter(){

        @Override
        public boolean accept(String str) {
            if (str.equals("lo")) {
                return true;
            }
            return str.startsWith("eth") || str.startsWith("bond") || str.startsWith("wlan");
        }
    };

    public SystemMonitor(int pollFrequencySeconds) {
        this(pollFrequencySeconds, (Collection<String>)DEFAULT_MEMINFO_KEYS, DEFAULT_STORAGE_TYPES, defaultInterfaceFilter, null);
    }

    public SystemMonitor(int pollFrequencySeconds, Logger logger) {
        this(pollFrequencySeconds, (Collection<String>)DEFAULT_MEMINFO_KEYS, DEFAULT_STORAGE_TYPES, defaultInterfaceFilter, logger);
    }

    public SystemMonitor(int pollFrequencySeconds, Collection<String> meminfoKeys, KeyFilter storageTypeFilter, KeyFilter networkDeviceFilter, Logger logger) {
        ImmutableMap.Builder builder;
        block9: {
            HashSet names;
            block8: {
                this.scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("essem-system-monitor-%d").build()));
                builder = ImmutableMap.builder();
                LoadAverage loadAverage = new LoadAverage();
                builder.putAll(loadAverage.getMetrics());
                this.scheduler.scheduleAtFixedRate(loadAverage, 0L, pollFrequencySeconds, TimeUnit.SECONDS);
                MemoryInfo meminfo = new MemoryInfo(meminfoKeys);
                builder.put((Object)"memory", (Object)meminfo);
                this.scheduler.scheduleAtFixedRate(meminfo, 0L, pollFrequencySeconds, TimeUnit.SECONDS);
                try {
                    NetworkDevices networkDevices = new NetworkDevices();
                    names = Sets.newHashSet();
                    for (NetworkDevices.Interface iface : networkDevices.interfaces.values()) {
                        if (!networkDeviceFilter.accept(iface.name)) continue;
                        if (!names.contains(iface.name)) {
                            builder.put((Object)iface.name, (Object)iface);
                            names.add(iface.name);
                            continue;
                        }
                        if (logger == null) continue;
                        logger.warn("Duplicate interface name: '" + iface.name + "'");
                    }
                    this.scheduler.scheduleAtFixedRate(networkDevices, 0L, pollFrequencySeconds, TimeUnit.SECONDS);
                }
                catch (IOException ioe) {
                    if (logger == null) break block8;
                    logger.error("Unable to instrument network devices", (Throwable)ioe);
                }
            }
            try {
                Storage storage = new Storage();
                names = Sets.newHashSet();
                for (Storage.Filesystem filesystem : storage.filesystems) {
                    if (!storageTypeFilter.accept(filesystem.type)) continue;
                    if (!names.contains(filesystem.name)) {
                        builder.put((Object)filesystem.name, (Object)filesystem);
                        names.add(filesystem.name);
                        continue;
                    }
                    if (logger == null) continue;
                    logger.warn("Duplicate filesystem name: '" + filesystem.name + "'");
                }
            }
            catch (IOException ioe) {
                if (logger == null) break block9;
                logger.error("Unable to instrument storage devices", (Throwable)ioe);
            }
        }
        this.metrics = builder.build();
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

