/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class LoadAverage
implements MetricSet,
Runnable {
    private final Gauge<Double> oneMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.oneMinuteAverage;
        }
    };
    private final Gauge<Double> fiveMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.fiveMinuteAverage;
        }
    };
    private final Gauge<Double> fifteenMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.fifteenMinuteAverage;
        }
    };
    private final ImmutableMap<String, Metric> metrics = ImmutableMap.of((Object)"load-avg-1m", this.oneMinuteAverage, (Object)"load-avg-5m", this.fiveMinuteAverage, (Object)"load-avg-15m", this.fifteenMinuteAverage);
    private static volatile CurrentLoadValues currValues = new CurrentLoadValues();

    public LoadAverage() throws IOException {
        File pathFile = new File("/proc/loadavg");
        if (!pathFile.exists()) {
            throw new IOException("The '/proc/loadavg' does not exist");
        }
    }

    @Override
    public void run() {
        currValues = new CurrentLoadValues();
    }

    public CurrentLoadValues values() {
        return new CurrentLoadValues();
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public static class CurrentLoadValues {
        public final double oneMinuteAverage;
        public final double fiveMinuteAverage;
        public final double fifteenMinuteAverage;
        private static final String PATH = "/proc/loadavg";
        private static final Splitter tokenSplitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();

        private CurrentLoadValues() {
            File pathFile = new File(PATH);
            if (pathFile.exists()) {
                double _fifteenMinuteAverage;
                double _fiveMinuteAverage;
                double _oneMinuteAverage;
                try {
                    Iterator strValues = tokenSplitter.split((CharSequence)Files.toString((File)pathFile, (Charset)Charsets.US_ASCII)).iterator();
                    _oneMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                    _fiveMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                    _fifteenMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                }
                catch (IOException | NumberFormatException e) {
                    _oneMinuteAverage = 0.0;
                    _fiveMinuteAverage = 0.0;
                    _fifteenMinuteAverage = 0.0;
                }
                this.oneMinuteAverage = _oneMinuteAverage;
                this.fiveMinuteAverage = _fiveMinuteAverage;
                this.fifteenMinuteAverage = _fifteenMinuteAverage;
            } else {
                this.oneMinuteAverage = 0.0;
                this.fiveMinuteAverage = 0.0;
                this.fifteenMinuteAverage = 0.0;
            }
        }

        public String toString() {
            return this.oneMinuteAverage + ", " + this.fiveMinuteAverage + ", " + this.fifteenMinuteAverage;
        }
    }
}

