/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.attribyte.essem.ReportProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EssemReporter
extends ScheduledReporter
implements MetricSet {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String DEFLATE_ENCODING = "deflate";
    private static final Logger LOGGER = LoggerFactory.getLogger(EssemReporter.class);
    private final String application;
    private final String host;
    private final String instance;
    private final Clock clock;
    private final URI uri;
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final String authValue;
    private final boolean deflate;
    private final Timer sendTimer = new Timer();
    private final Meter sendErrors = new Meter();
    private final Histogram reportSize = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
    private final Counter skippedUnchanged = new Counter();
    private final ImmutableMap<String, Metric> metrics = ImmutableMap.of((Object)"reports", (Object)this.sendTimer, (Object)"failed-reports", (Object)this.sendErrors, (Object)"report-size-bytes", (Object)this.reportSize, (Object)"skipped-unchanged", (Object)this.skippedUnchanged, (Object)"report-count", (Object)new Gauge<Integer>(){

        public Integer getValue() {
            return EssemReporter.this.lastMetricCount.get();
        }
    });
    private final Map<String, Long> lastReportedCount;
    private final AtomicInteger lastMetricCount = new AtomicInteger();

    public static Builder newBuilder(URI uri, MetricRegistry registry) {
        return new Builder(uri, registry);
    }

    protected EssemReporter(URI uri, String authValue, boolean deflate, MetricRegistry registry, Clock clock, String application, String host, String instance, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, boolean skipUnchangedMetrics) {
        super(registry, "essem-reporter", filter, rateUnit, durationUnit);
        this.uri = uri;
        this.authValue = authValue;
        this.deflate = deflate;
        this.clock = clock;
        this.application = application;
        this.host = host;
        this.instance = instance;
        this.rateUnit = rateUnit;
        this.durationUnit = durationUnit;
        this.lastReportedCount = skipUnchangedMetrics ? Maps.newConcurrentMap() : null;
    }

    public ReportProtos.EssemReport buildReport(MetricRegistry registry) {
        return this.buildReport(registry.getGauges(), registry.getCounters(), registry.getHistograms(), registry.getMeters(), registry.getTimers());
    }

    public ReportProtos.EssemReport buildReport(MetricRegistry registry, MetricFilter filter) {
        return this.buildReport(registry.getGauges(filter), registry.getCounters(filter), registry.getHistograms(filter), registry.getMeters(filter), registry.getTimers(filter));
    }

    private ReportProtos.EssemReport buildReport(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Snapshot snapshot;
        String name;
        ReportProtos.EssemReport.Builder builder = ReportProtos.EssemReport.newBuilder();
        builder.setTimestamp(this.clock.getTime());
        builder.setDurationUnit(this.toProto(this.durationUnit));
        builder.setRateUnit(this.toProto(this.rateUnit));
        if (this.application != null) {
            builder.setApplication(this.application);
        }
        if (this.host != null) {
            builder.setHost(this.host);
        }
        if (this.instance != null) {
            builder.setInstance(this.instance);
        }
        this.lastMetricCount.set(gauges.size() + counters.size() + histograms.size() + meters.size() + timers.size());
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Object val = entry.getValue().getValue();
            ReportProtos.EssemReport.Gauge.Builder gaugeBuilder = builder.addGaugeBuilder();
            gaugeBuilder.setName(entry.getKey());
            if (val instanceof Number) {
                gaugeBuilder.setValue(((Number)val).doubleValue());
                continue;
            }
            gaugeBuilder.setComment(val.toString());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            long value;
            name = entry.getKey();
            if (this.skipCountedReport(name, value = ((Counter)entry.getValue()).getCount())) continue;
            builder.addCounterBuilder().setName(name).setCount(value);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            Meter meter;
            name = entry.getKey();
            if (this.skipCountedReport(name, (meter = (Meter)entry.getValue()).getCount())) continue;
            builder.addMeterBuilder().setName(name).setCount(meter.getCount()).setOneMinuteRate(this.convertRate(meter.getOneMinuteRate())).setFiveMinuteRate(this.convertRate(meter.getFiveMinuteRate())).setFifteenMinuteRate(this.convertRate(meter.getFifteenMinuteRate())).setMeanRate(this.convertRate(meter.getMeanRate()));
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            Histogram histogram;
            name = entry.getKey();
            if (this.skipCountedReport(name, (histogram = (Histogram)entry.getValue()).getCount())) continue;
            snapshot = histogram.getSnapshot();
            builder.addHistogramBuilder().setName(name).setCount(histogram.getCount()).setMax(snapshot.getMax()).setMin(snapshot.getMin()).setMedian(snapshot.getMedian()).setMean(snapshot.getMean()).setStd(snapshot.getStdDev()).setPercentile75(snapshot.get75thPercentile()).setPercentile95(snapshot.get95thPercentile()).setPercentile98(snapshot.get98thPercentile()).setPercentile99(snapshot.get99thPercentile()).setPercentile999(snapshot.get999thPercentile());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            Timer timer;
            name = entry.getKey();
            if (this.skipCountedReport(name, (timer = (Timer)entry.getValue()).getCount())) continue;
            snapshot = timer.getSnapshot();
            builder.addTimerBuilder().setName(entry.getKey()).setOneMinuteRate(this.convertRate(timer.getOneMinuteRate())).setFiveMinuteRate(this.convertRate(timer.getFiveMinuteRate())).setFifteenMinuteRate(this.convertRate(timer.getFifteenMinuteRate())).setMeanRate(this.convertRate(timer.getMeanRate())).setCount(timer.getCount()).setMax(this.convertDuration(snapshot.getMax())).setMin(this.convertDuration(snapshot.getMin())).setMedian(this.convertDuration(snapshot.getMedian())).setMean(this.convertDuration(snapshot.getMean())).setStd(this.convertDuration(snapshot.getStdDev())).setPercentile75(this.convertDuration(snapshot.get75thPercentile())).setPercentile95(this.convertDuration(snapshot.get95thPercentile())).setPercentile98(this.convertDuration(snapshot.get98thPercentile())).setPercentile99(this.convertDuration(snapshot.get99thPercentile())).setPercentile999(this.convertDuration(snapshot.get999thPercentile()));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Timer.Context ctx = this.sendTimer.time();
        try {
            int responseCode = this.send(this.uri, this.buildReport(gauges, counters, histograms, meters, timers));
            if (responseCode / 100 != 2) {
                LOGGER.warn("EssemReporter: Unable to report (" + responseCode + ")");
            } else {
                LOGGER.debug("EssemReporter: Reported (" + responseCode + ")");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            LOGGER.warn("Unable to report to Essem", (Throwable)ioe);
            this.sendErrors.mark();
        }
        finally {
            ctx.stop();
        }
    }

    private int send(URI uri, ReportProtos.EssemReport report) throws IOException {
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            URL url = uri.toURL();
            conn = (HttpURLConnection)url.openConnection();
            if (conn != null) {
                conn.setRequestMethod("PUT");
                conn.setRequestProperty(CONTENT_TYPE_HEADER, PROTOBUF_CONTENT_TYPE);
                if (!Strings.isNullOrEmpty((String)this.authValue)) {
                    conn.setRequestProperty(AUTHORIZATION_HEADER, this.authValue);
                }
                conn.setDoOutput(true);
                conn.setInstanceFollowRedirects(false);
                byte[] reportBytes = report.toByteArray();
                if (this.deflate) {
                    conn.setRequestProperty(CONTENT_ENCODING_HEADER, DEFLATE_ENCODING);
                    reportBytes = EssemReporter.deflate(reportBytes);
                }
                conn.setFixedLengthStreamingMode(reportBytes.length);
                this.reportSize.update(reportBytes.length);
                conn.connect();
                OutputStream os = conn.getOutputStream();
                os.write(reportBytes);
                os.flush();
                os.close();
                int code = conn.getResponseCode();
                is = code / 100 == 2 ? conn.getInputStream() : conn.getErrorStream();
                this.discardInputAndClose(is);
                is = null;
                int n = code;
                return n;
            }
            try {
                throw new IOException("Unable to 'PUT' to " + uri.toString());
            }
            catch (IOException ioe) {
                if (conn != null && is == null) {
                    this.discardInputAndClose(conn.getErrorStream());
                }
                throw ioe;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected ReportProtos.EssemReport.TimeUnit toProto(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ReportProtos.EssemReport.TimeUnit.NANOS;
            }
            case MICROSECONDS: {
                return ReportProtos.EssemReport.TimeUnit.MICROS;
            }
            case MILLISECONDS: {
                return ReportProtos.EssemReport.TimeUnit.MILLIS;
            }
            case SECONDS: {
                return ReportProtos.EssemReport.TimeUnit.SECONDS;
            }
            case MINUTES: {
                return ReportProtos.EssemReport.TimeUnit.MINUTES;
            }
            case HOURS: {
                return ReportProtos.EssemReport.TimeUnit.HOURS;
            }
            case DAYS: {
                return ReportProtos.EssemReport.TimeUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    private void discardInputAndClose(InputStream is) throws IOException {
        if (is != null) {
            ByteStreams.toByteArray((InputStream)is);
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static byte[] deflate(byte[] b) {
        try {
            Deflater deflater = new Deflater(9, false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater);
            dos.write(b);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"I/O exception on in-memory stream");
        }
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    private boolean skipCountedReport(String name, long currentValue) {
        if (this.lastReportedCount == null) {
            return false;
        }
        if (this.lastReportedCount.getOrDefault(name, Long.MIN_VALUE) == currentValue) {
            this.skippedUnchanged.inc();
            return true;
        }
        this.lastReportedCount.put(name, currentValue);
        return false;
    }

    public static class Builder {
        private final URI uri;
        private final MetricRegistry registry;
        private String authValue;
        private Clock clock = Clock.defaultClock();
        private String application;
        private String host;
        private String instance;
        private boolean deflate;
        private TimeUnit rateUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private boolean skipUnchangedMetrics = false;
        private MetricFilter filter;

        private Builder(URI uri, MetricRegistry registry) {
            this.uri = uri;
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.application = null;
            this.host = null;
            this.instance = null;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder forApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder forHost(String host) {
            this.host = host;
            return this;
        }

        public Builder forInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withAuthorization(String authValue) {
            this.authValue = authValue;
            return this;
        }

        public Builder withBasicAuthorization(String username, String password) {
            if (username != null && password != null) {
                byte[] up = (username + ":" + password).getBytes(Charsets.UTF_8);
                return this.withAuthorization("Basic " + BaseEncoding.base64().encode(up));
            }
            return this;
        }

        public Builder withDeflate(boolean deflate) {
            this.deflate = deflate;
            return this;
        }

        public Builder skipUnchangedMetrics(boolean skipUnchangedMetrics) {
            this.skipUnchangedMetrics = skipUnchangedMetrics;
            return this;
        }

        public EssemReporter build() {
            return new EssemReporter(this.uri, this.authValue, this.deflate, this.registry, this.clock, this.application, this.host, this.instance, this.filter, this.rateUnit, this.durationUnit, this.skipUnchangedMetrics);
        }
    }
}

