/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockDevices
implements Runnable {
    private static final String PATH = "/proc/diskstats";
    private static final Splitter lineSplitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().trimResults();
    public final ImmutableList<BlockDevice> devices;

    public BlockDevices() throws IOException {
        ImmutableList lines = Files.asCharSource((File)new File(PATH), (Charset)Charsets.US_ASCII).readLines();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String line : lines) {
            ArrayList tokens = Lists.newArrayList((Iterable)lineSplitter.split((CharSequence)line));
            if (tokens.size() < 10) continue;
            String name = (String)tokens.get(2);
            builder.add((Object)new BlockDevice(tokens, BlockDevices.getBlockSize(name)));
        }
        this.devices = builder.build();
    }

    @Override
    public void run() {
        try {
            List tokens;
            ImmutableList lines = Files.asCharSource((File)new File(PATH), (Charset)Charsets.US_ASCII).readLines();
            HashMap tokenMap = Maps.newHashMapWithExpectedSize((int)lines.size());
            for (String line : lines) {
                tokens = Lists.newArrayList((Iterable)lineSplitter.split((CharSequence)line));
                String name = (String)tokens.get(2);
                tokenMap.put(name, tokens);
            }
            for (BlockDevice device : this.devices) {
                tokens = (List)tokenMap.get(device.name);
                if (tokens == null) continue;
                device.mark(tokens);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static int getBlockSize(String name) {
        File file = new File("/sys/block/" + name + "/queue/physical_block_size");
        if (!file.exists()) {
            int end;
            for (end = name.length() - 1; end > 0 && Character.isDigit(name.charAt(end)); --end) {
            }
            file = new File("/sys/block/" + name.substring(0, end + 1) + "/queue/physical_block_size");
        }
        if (!file.exists()) {
            return 0;
        }
        try {
            return Integer.parseInt(Files.toString((File)file, (Charset)Charsets.US_ASCII).trim());
        }
        catch (IOException ioe) {
            return 0;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return 0;
        }
    }

    public static class BlockDevice
    implements MetricSet {
        private static final int NAME_INDEX = 2;
        private static final int PHYSICAL_READS_INDEX = 3;
        private static final int READ_BYTES_INDEX = 5;
        private static final int PHYSICAL_WRITES_INDEX = 7;
        private static final int WRITE_BYTES_INDEX = 9;
        private static final int MIN_EXPECTED_TOKENS = 10;
        public final String name;
        public final long blockSize;
        private final Meter physicalReadsMeter = new Meter();
        private final Meter readBytesMeter = new Meter();
        private final Meter physicalWritesMeter = new Meter();
        private final Meter writeBytesMeter = new Meter();
        private final ImmutableMap<String, Metric> meters = ImmutableMap.of((Object)"read-ops", (Object)this.physicalReadsMeter, (Object)"bytes-read", (Object)this.readBytesMeter, (Object)"write-ops", (Object)this.physicalWritesMeter, (Object)"bytes-written", (Object)this.writeBytesMeter);
        private long lastPhysicalReads;
        private long lastReadBytes;
        private long lastPhysicalWrites;
        private long lastWriteBytes;

        private BlockDevice(List<String> tokens, int blockSize) {
            this.name = tokens.get(2).trim();
            this.blockSize = blockSize;
            this.lastPhysicalReads = this.getValue(tokens, 3);
            this.lastReadBytes = this.getValue(tokens, 5) * (long)blockSize;
            this.lastPhysicalWrites = this.getValue(tokens, 7);
            this.lastWriteBytes = this.getValue(tokens, 9) * (long)blockSize;
        }

        private void mark(List<String> tokens) {
            long physicalReads = this.getValue(tokens, 3);
            long readBytes = this.getValue(tokens, 5) * this.blockSize;
            long physicalWrites = this.getValue(tokens, 7);
            long writeBytes = this.getValue(tokens, 9) * this.blockSize;
            this.physicalReadsMeter.mark(physicalReads - this.lastPhysicalReads);
            this.readBytesMeter.mark(readBytes - this.lastReadBytes);
            this.physicalWritesMeter.mark(physicalWrites - this.lastPhysicalWrites);
            this.writeBytesMeter.mark(writeBytes - this.lastWriteBytes);
            this.lastPhysicalReads = physicalReads;
            this.lastReadBytes = readBytes;
            this.lastPhysicalWrites = physicalWrites;
            this.lastWriteBytes = writeBytes;
        }

        private long getValue(List<String> tokens, int index) {
            try {
                return Long.parseLong(tokens.get(index));
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }

        public Map<String, Metric> getMetrics() {
            return this.meters;
        }
    }
}

