/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NetworkDevices
implements Runnable {
    public final ImmutableMap<String, Interface> interfaces;
    private static final Splitter sectionSplitter = Splitter.on((char)'|').trimResults();
    private static final Splitter tokenSplitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();
    private static final String PATH = "/proc/net/dev";

    public NetworkDevices() throws IOException {
        ImmutableList lines = Files.asCharSource((File)new File(PATH), (Charset)Charsets.US_ASCII).readLines();
        if (lines.size() < 2) {
            throw new IOException("Unknown format for '/proc/net/dev'");
        }
        Iterator linesIter = lines.iterator();
        linesIter.next();
        Iterator sections = sectionSplitter.split((CharSequence)linesIter.next()).iterator();
        if (!sections.hasNext()) {
            throw new IOException("Unknown format for '/proc/net/dev'");
        }
        sections.next();
        if (!sections.hasNext()) {
            throw new IOException("Unknown format for '/proc/net/dev'");
        }
        ArrayList receiveKeys = Lists.newArrayList((Iterable)tokenSplitter.split((CharSequence)sections.next()));
        if (!sections.hasNext()) {
            throw new IOException("Unknown format for '/proc/net/dev'");
        }
        ArrayList transmitKeys = Lists.newArrayList((Iterable)tokenSplitter.split((CharSequence)sections.next()));
        ArrayList keys = Lists.newArrayListWithCapacity((int)(receiveKeys.size() + transmitKeys.size()));
        for (String key : receiveKeys) {
            keys.add("receive." + key);
        }
        for (String key : transmitKeys) {
            keys.add("transmit." + key);
        }
        ImmutableMap.Builder interfacesBuilder = ImmutableMap.builder();
        while (linesIter.hasNext()) {
            Iterator values = tokenSplitter.split((CharSequence)linesIter.next()).iterator();
            String name = this.cleanName((String)values.next());
            interfacesBuilder.put((Object)name, (Object)new Interface(name, keys, values));
        }
        this.interfaces = interfacesBuilder.build();
    }

    @Override
    public void run() {
        try {
            File pathFile = new File(PATH);
            if (!pathFile.exists()) {
                return;
            }
            UnmodifiableIterator linesIter = Files.asCharSource((File)new File(PATH), (Charset)Charsets.US_ASCII).readLines().iterator();
            linesIter.next();
            linesIter.next();
            while (linesIter.hasNext()) {
                Iterator values = tokenSplitter.split((CharSequence)linesIter.next()).iterator();
                String name = this.cleanName((String)values.next());
                Interface iface = (Interface)this.interfaces.get((Object)name);
                if (iface == null) continue;
                iface.mark(values);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String cleanName(String name) {
        if (name.endsWith(":")) {
            return name.substring(0, name.length() - 1).replace(':', '.');
        }
        return name.replace(':', '.');
    }

    public static class Interface
    implements MetricSet {
        public final String name;
        private final ImmutableMap<String, Metric> metricMap;
        private final ImmutableList<Meter> meters;
        private List<BigInteger> lastRecordedValues;

        private Interface(String name, Iterable<String> keys, Iterator<String> lastRecordedValues) {
            this.name = name;
            ImmutableList.Builder metersBuilder = ImmutableList.builder();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (String key : keys) {
                Meter meter = new Meter();
                metersBuilder.add((Object)meter);
                mapBuilder.put((Object)key, (Object)meter);
            }
            this.meters = metersBuilder.build();
            this.metricMap = mapBuilder.build();
            this.lastRecordedValues = Lists.newArrayListWithCapacity((int)this.meters.size());
            while (lastRecordedValues.hasNext()) {
                this.lastRecordedValues.add(new BigInteger(lastRecordedValues.next()));
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Interface && this.name.equals(other);
        }

        public Map<String, Metric> getMetrics() {
            return this.metricMap;
        }

        private void mark(Iterator<String> newValues) {
            ArrayList nextRecordedValues = Lists.newArrayListWithCapacity((int)this.lastRecordedValues.size());
            Iterator<BigInteger> oldValIter = this.lastRecordedValues.iterator();
            UnmodifiableIterator meterIter = this.meters.iterator();
            while (newValues.hasNext()) {
                BigInteger oldVal = oldValIter.next();
                BigInteger newVal = new BigInteger(newValues.next());
                nextRecordedValues.add(newVal);
                ((Meter)meterIter.next()).mark(newVal.subtract(oldVal).longValue());
            }
            this.lastRecordedValues = nextRecordedValues;
        }
    }
}

