/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.HdrHistogram.Recorder;

public class HDRReservoir
implements Reservoir {
    private final Recorder recorder;
    private Histogram lastSnapshotHistogram = null;
    private final Histogram totalHistogram;
    private final long highestTrackableValue;
    private final boolean reportTotalHistogram;
    public static final boolean REPORT_TOTAL_HISTOGRAM = true;
    public static final boolean REPORT_SNAPSHOT_HISTOGRAM = false;

    public HDRReservoir(int numberOfSignificantValueDigits, boolean reportTotalHistogram) {
        this.highestTrackableValue = Long.MAX_VALUE;
        this.recorder = new Recorder(numberOfSignificantValueDigits);
        this.totalHistogram = new Histogram(numberOfSignificantValueDigits);
        this.reportTotalHistogram = reportTotalHistogram;
    }

    public HDRReservoir(long highestTrackableValue, int numberOfSignificantValueDigits, boolean reportTotalHistogram) {
        this.highestTrackableValue = highestTrackableValue;
        this.recorder = new Recorder(highestTrackableValue, numberOfSignificantValueDigits);
        this.totalHistogram = new Histogram(highestTrackableValue, numberOfSignificantValueDigits);
        this.reportTotalHistogram = reportTotalHistogram;
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.recorder.recordValue(value < this.highestTrackableValue ? value : this.highestTrackableValue);
    }

    public synchronized Snapshot getSnapshot() {
        this.lastSnapshotHistogram = this.recorder.getIntervalHistogram(this.lastSnapshotHistogram);
        this.totalHistogram.add((AbstractHistogram)this.lastSnapshotHistogram);
        HDRSnapshot snapshot = new HDRSnapshot(this.totalHistogram.copy(), this.lastSnapshotHistogram.copy());
        return this.reportTotalHistogram ? snapshot.totalSnapshot() : snapshot.sinceLastSnapshot();
    }

    public static final class HDRSnapshot
    extends Snapshot {
        private final Histogram histogram;
        private final Histogram totalHistogram;
        private final Histogram lastSnapshotHistogram;

        HDRSnapshot(Histogram totalHistogram, Histogram lastSnapshotHistogram) {
            this.totalHistogram = totalHistogram;
            this.lastSnapshotHistogram = lastSnapshotHistogram;
            this.histogram = totalHistogram;
        }

        private HDRSnapshot(Histogram histogram, Histogram totalHistogram, Histogram lastSnapshotHistogram) {
            this.histogram = histogram;
            this.totalHistogram = totalHistogram;
            this.lastSnapshotHistogram = lastSnapshotHistogram;
        }

        public HDRSnapshot fromHistogram(Histogram histogram) {
            return new HDRSnapshot(histogram, histogram, histogram);
        }

        public HDRSnapshot totalSnapshot() {
            return this.histogram == this.totalHistogram ? this : new HDRSnapshot(this.totalHistogram, this.lastSnapshotHistogram, this.totalHistogram);
        }

        public HDRSnapshot sinceLastSnapshot() {
            return this.histogram == this.lastSnapshotHistogram ? this : new HDRSnapshot(this.totalHistogram, this.lastSnapshotHistogram, this.lastSnapshotHistogram);
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public double getValue(double quantile) {
            return this.histogram.getValueAtPercentile(quantile * 100.0);
        }

        public long[] getValues() {
            int size = Math.toIntExact(this.histogram.getTotalCount());
            long[] values = new long[size];
            int pos = 0;
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                long recordedValue = value.getValueIteratedTo();
                long count = value.getCountAddedInThisIterationStep();
                int i = 0;
                while ((long)i < count) {
                    values[pos++] = recordedValue;
                    ++i;
                }
            }
            return values;
        }

        public int size() {
            return Math.toIntExact(this.histogram.getTotalCount());
        }

        public long getMax() {
            return this.histogram.getMaxValue();
        }

        public double getMean() {
            return this.histogram.getMean();
        }

        public long getMin() {
            return this.histogram.getMinValue();
        }

        public double getStdDev() {
            return this.histogram.getStdDeviation();
        }

        public void dump(OutputStream output) {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, Charsets.UTF_8));){
                for (long value : this.getValues()) {
                    out.printf("%d%n", value);
                }
            }
        }
    }
}

