/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.db;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.attribyte.sql.ConnectionSupplier;
import org.attribyte.util.SQLUtil;
import org.attribyte.wp.Util;
import org.attribyte.wp.db.MetricSource;
import org.attribyte.wp.db.Metrics;
import org.attribyte.wp.model.Blog;
import org.attribyte.wp.model.Meta;
import org.attribyte.wp.model.Paging;
import org.attribyte.wp.model.Post;
import org.attribyte.wp.model.Site;
import org.attribyte.wp.model.TaxonomyTerm;
import org.attribyte.wp.model.Term;
import org.attribyte.wp.model.User;

public class DB
implements MetricSet {
    private static final String createUserSQL = "INSERT INTO wp_users (user_login, user_pass, user_nicename, display_name, user_email, user_registered) VALUES (?, ?, ?, ?, ?, NOW())";
    private static final String selectUserSQL = "SELECT ID, user_login, user_nicename, display_name, user_email, user_registered FROM wp_users";
    private static final String selectUserByUsernameSQL = "SELECT ID, user_login, user_nicename, display_name, user_email, user_registered FROM wp_users WHERE user_login=?";
    private static final String selectUserByIdSQL = "SELECT ID, user_login, user_nicename, display_name, user_email, user_registered FROM wp_users WHERE ID=?";
    private static final String selectUserMetaSQL = "SELECT umeta_id, meta_key, meta_value FROM wp_usermeta WHERE user_id=?";
    private final String deletePostIdSQL;
    private static final String selectPostSQL = "SELECT ID, post_author, post_date, post_content, post_title, post_excerpt, post_status, post_name, post_modified,post_parent, guid, post_type, post_mime_type FROM ";
    private final String selectModPostsSQL;
    private final String selectModPostsWithTypeSQL;
    private final String deleteChildrenSQL;
    private final String selectChildrenSQL;
    private final String selectPostsBySlugSQL;
    private final String updatePostSQL;
    private final String insertPostWithIdSQL;
    private final String insertPostSQL;
    private final String deletePostMetaSQL;
    private final String selectPostMetaSQL;
    final String insertPostMetaSQL;
    private final String selectTermIdsSQL;
    private final String insertTermSQL;
    private final String selectTermIdSQL;
    private final String selectTaxonomyTermSQL;
    final String insertTaxonomyTermSQL;
    private final String selectTaxonomyTermIdSQL;
    private final String clearPostTermSQL;
    private final String clearPostTermsSQL;
    private final String insertPostTermSQL;
    public final String selectPostTermsSQL;
    private final String selectOptionSQL;
    private static final String selectBlogSQL = "SELECT blog_id, site_id, domain, path, registered, last_updated FROM wp_blogs";
    private static final String selectPublicBlogsSQL = "SELECT blog_id, site_id, domain, path, registered, last_updated FROM wp_blogs WHERE deleted=0 AND public=1";
    public final long siteId;
    private final ConnectionSupplier connectionSupplier;
    private final String postsTableName;
    private final String termRelationshipsTableName;
    private final Cache<Long, User> userCache;
    private final Cache<String, User> usernameCache;
    private final ImmutableMap<String, Cache<String, TaxonomyTerm>> taxonomyTermCaches;
    private final Cache<Long, TaxonomyTerm> taxonomyTermCache;
    private final Metrics metrics;

    public DB(ConnectionSupplier connectionSupplier, long siteId, Set<String> cachedTaxonomies, Duration taxonomyCacheTimeout, Duration userCacheTimeout) {
        this(connectionSupplier, siteId, cachedTaxonomies, taxonomyCacheTimeout, userCacheTimeout, MetricSource.DEFAULT);
    }

    public DB(ConnectionSupplier connectionSupplier, long siteId, Set<String> cachedTaxonomies, Duration taxonomyCacheTimeout, Duration userCacheTimeout, MetricSource metricSource) {
        String termTaxonomyTableName;
        String termsTableName;
        String optionsTableName;
        String postMetaTableName;
        this.connectionSupplier = connectionSupplier;
        this.siteId = siteId;
        if (siteId < 2L) {
            this.postsTableName = "wp_posts";
            postMetaTableName = "wp_postmeta";
            optionsTableName = "wp_options";
            termsTableName = "wp_terms";
            this.termRelationshipsTableName = "wp_term_relationships";
            termTaxonomyTableName = "wp_term_taxonomy";
        } else {
            this.postsTableName = "wp_" + siteId + "_posts";
            postMetaTableName = "wp_" + siteId + "_postmeta";
            optionsTableName = "wp_" + siteId + "_options";
            termsTableName = "wp_" + siteId + "_terms";
            this.termRelationshipsTableName = "wp_" + siteId + "_term_relationships";
            termTaxonomyTableName = "wp_" + siteId + "_term_taxonomy";
        }
        this.userCache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(userCacheTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
        this.usernameCache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(userCacheTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
        ImmutableMap.Builder taxonomyTermCachesBuilder = ImmutableMap.builder();
        for (String taxonomy : cachedTaxonomies) {
            taxonomyTermCachesBuilder.put((Object)taxonomy, (Object)CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(taxonomyCacheTimeout.toMillis(), TimeUnit.MILLISECONDS).build());
        }
        this.taxonomyTermCaches = taxonomyTermCachesBuilder.build();
        this.taxonomyTermCache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(taxonomyCacheTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
        this.deletePostIdSQL = "DELETE FROM " + this.postsTableName + " WHERE ID=?";
        this.insertTermSQL = "INSERT INTO " + termsTableName + "(name, slug) VALUES (?, ?)";
        this.selectTermIdSQL = "SELECT name, slug FROM " + termsTableName + " WHERE term_id=?";
        this.selectTermIdsSQL = "SELECT term_id FROM " + termsTableName + " WHERE name=?";
        this.selectTaxonomyTermSQL = "SELECT term_taxonomy_id," + termTaxonomyTableName + ".term_id, description " + "FROM " + termsTableName + "," + termTaxonomyTableName + " WHERE " + termsTableName + ".name=? " + "AND taxonomy=? AND " + termsTableName + ".term_id=" + termTaxonomyTableName + ".term_id";
        this.selectTaxonomyTermIdSQL = "SELECT taxonomy, term_id, description FROM " + termTaxonomyTableName + " WHERE term_taxonomy_id=?";
        this.insertTaxonomyTermSQL = "INSERT INTO " + termTaxonomyTableName + "(term_id, taxonomy, description) VALUES (?,?, ?)";
        this.clearPostTermsSQL = "DELETE FROM " + this.termRelationshipsTableName + " WHERE object_id=?";
        this.clearPostTermSQL = "DELETE FROM " + this.termRelationshipsTableName + " WHERE object_id=? AND term_taxonomy_id=?";
        this.insertPostTermSQL = "INSERT IGNORE INTO " + this.termRelationshipsTableName + " (object_id, term_taxonomy_id, term_order) VALUES (?,?,?)";
        this.selectPostTermsSQL = "SELECT term_taxonomy_id FROM " + this.termRelationshipsTableName + " WHERE object_id=? ORDER BY term_order ASC";
        this.selectPostMetaSQL = "SELECT meta_id, meta_key, meta_value FROM " + postMetaTableName + " WHERE post_id=?";
        this.insertPostMetaSQL = "INSERT INTO " + postMetaTableName + "(post_id, meta_key, meta_value) VALUES (?,?,?)";
        this.deletePostMetaSQL = "DELETE FROM " + postMetaTableName + " WHERE post_id=?";
        this.selectOptionSQL = "SELECT option_value FROM " + optionsTableName + " WHERE option_name=?";
        this.selectPostsBySlugSQL = selectPostSQL + this.postsTableName + " WHERE post_name=? ORDER BY ID DESC";
        this.selectChildrenSQL = selectPostSQL + this.postsTableName + " WHERE post_parent=? ORDER BY ID ASC";
        this.deleteChildrenSQL = "DELETE FROM " + this.postsTableName + " WHERE post_parent=?";
        this.insertPostWithIdSQL = "INSERT INTO " + this.postsTableName + " (ID, post_author, post_date, post_date_gmt, post_content, post_title, " + "post_excerpt, post_status, post_name, post_modified, post_modified_gmt," + "post_parent, guid, post_type, to_ping, pinged, post_content_filtered, post_mime_type) VALUES " + "(?,?,?,?,?,?,?,?,?,?,?,?,?,?, '','', '',?)";
        this.insertPostSQL = "INSERT INTO " + this.postsTableName + " (post_author, post_date, post_date_gmt, post_content, post_title, " + "post_excerpt, post_status, post_name, post_modified, post_modified_gmt," + "post_parent, guid, post_type, to_ping, pinged, post_content_filtered, post_mime_type) VALUES " + "(?,?,?,?,?,?,?,?,?,?,?,?,?, '','', '',?)";
        this.updatePostSQL = "UPDATE " + this.postsTableName + " SET post_author=?, post_date=?, post_date_gmt=?, post_content=?, post_title=?, " + "post_excerpt=?, post_status=?, post_name=?, post_modified=?, post_modified_gmt=?, post_parent=?, " + "guid=?, post_type=?, post_mime_type=? WHERE ID=?";
        this.selectModPostsSQL = selectPostSQL + this.postsTableName + " WHERE post_modified > ? OR (post_modified=? AND ID > ?) ORDER BY post_modified ASC, ID ASC LIMIT ?";
        this.selectModPostsWithTypeSQL = selectPostSQL + this.postsTableName + " WHERE post_type=? AND (post_modified > ? OR (post_modified=? AND ID > ?)) ORDER BY post_modified ASC, ID ASC LIMIT ?";
        this.metrics = new Metrics(metricSource);
    }

    public User createUser(User user, String userPass) throws SQLException {
        block4: {
            User user2;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String nicename = user.displayName();
            if (nicename.length() > 49) {
                nicename = nicename.substring(0, 49);
            }
            String username = user.username.length() < 60 ? user.username : user.username.substring(0, 60);
            Timer.Context ctx = this.metrics.createUserTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(createUserSQL, 1);
                stmt.setString(1, username);
                stmt.setString(2, Strings.nullToEmpty((String)userPass));
                stmt.setString(3, nicename);
                stmt.setString(4, user.displayName());
                stmt.setString(5, Strings.nullToEmpty((String)user.email));
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) break block4;
                user2 = user.withId(rs.getLong(1));
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return user2;
        }
        throw new SQLException("Problem creating user (no generated id)");
    }

    private User userFromResultSet(ResultSet rs) throws SQLException {
        String niceName = Strings.nullToEmpty((String)rs.getString(3)).trim();
        String displayName = Strings.nullToEmpty((String)rs.getString(4)).trim();
        String useDisplayName = displayName.isEmpty() ? niceName : displayName;
        return new User(rs.getLong(1), rs.getString(2), useDisplayName, rs.getString(5), rs.getTimestamp(6).getTime(), (Collection<Meta>)ImmutableList.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User selectUser(String username) throws SQLException {
        User user;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectUserTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(selectUserByUsernameSQL);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            user = rs.next() ? this.userFromResultSet(rs) : null;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User selectUser(long userId) throws SQLException {
        User user;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectUserTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(selectUserByIdSQL);
            stmt.setLong(1, userId);
            rs = stmt.executeQuery();
            user = rs.next() ? this.userFromResultSet(rs) : null;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return user;
    }

    public User resolveUser(long userId) throws SQLException {
        this.metrics.userCacheTries.mark();
        User user = (User)this.userCache.getIfPresent((Object)userId);
        if (user != null) {
            this.metrics.userCacheHits.mark();
            return user;
        }
        user = this.selectUser(userId);
        if (user != null) {
            this.userCache.put((Object)userId, (Object)user);
        }
        return user;
    }

    public User resolveUser(String username) throws SQLException {
        this.metrics.usernameCacheTries.mark();
        User user = (User)this.usernameCache.getIfPresent((Object)username);
        if (user != null) {
            this.metrics.usernameCacheHits.mark();
            return user;
        }
        user = this.selectUser(username);
        if (user != null) {
            this.usernameCache.put((Object)username, (Object)user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Meta> userMetadata(long userId) throws SQLException {
        ArrayList arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList meta = Lists.newArrayListWithExpectedSize((int)16);
        Timer.Context ctx = this.metrics.userMetadataTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(selectUserMetaSQL);
            stmt.setLong(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                meta.add(new Meta(rs.getLong(1), rs.getString(2), rs.getString(3)));
            }
            arrayList = meta;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePost(long postId) throws SQLException {
        this.clearPostMeta(postId);
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.deletePostTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.deletePostIdSQL);
            stmt.setLong(1, postId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    private Post.Builder postFromResultSet(ResultSet rs) throws SQLException {
        Post.Builder post = Post.newBuilder();
        post.setId(rs.getLong(1));
        post.setAuthorId(rs.getLong(2));
        Timestamp ts = rs.getTimestamp(3);
        post.setPublishTimestamp(ts != null ? ts.getTime() : 0L);
        post.setContent(Strings.emptyToNull((String)rs.getString(4)));
        post.setTitle(Strings.emptyToNull((String)rs.getString(5)));
        post.setExcerpt(Strings.emptyToNull((String)rs.getString(6)));
        post.setStatus(Post.Status.fromString(rs.getString(7)));
        post.setSlug(Strings.emptyToNull((String)rs.getString(8)));
        ts = rs.getTimestamp(9);
        post.setModifiedTimestamp(ts != null ? ts.getTime() : 0L);
        post.setParentId(rs.getLong(10));
        post.setGUID(Strings.emptyToNull((String)rs.getString(11)));
        post.setType(Post.Type.fromString(rs.getString(12)));
        post.setMimeType(rs.getString(13));
        return post;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Post> selectAuthorPosts(long userId, Post.Sort sort, Paging paging, boolean withResolve) throws SQLException {
        if (paging.limit < 1 || paging.start < 0) {
            return ImmutableList.of();
        }
        ArrayList builders = Lists.newArrayListWithExpectedSize((int)(paging.limit < 1024 ? paging.limit : 1024));
        StringBuilder sql = new StringBuilder(selectPostSQL);
        sql.append(this.postsTableName);
        sql.append(" WHERE post_author=?");
        this.appendPagingSortSQL(sql, sort, paging);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectAuthorPostsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setLong(1, userId);
            if (paging.interval != null) {
                stmt.setTimestamp(2, new Timestamp(paging.interval.getStartMillis()));
                stmt.setTimestamp(3, new Timestamp(paging.interval.getStartMillis()));
                stmt.setInt(4, paging.start);
                stmt.setInt(5, paging.limit);
            } else {
                stmt.setInt(2, paging.start);
                stmt.setInt(3, paging.limit);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                builders.add(this.postFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        ArrayList posts = Lists.newArrayListWithExpectedSize((int)builders.size());
        for (Post.Builder builder : builders) {
            if (withResolve) {
                posts.add(this.resolve(builder).build());
                continue;
            }
            posts.add(builder.build());
        }
        return posts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Post> selectModifiedPosts(Post.Type type, long startTimestamp, long startId, int limit, boolean withResolve) throws SQLException {
        ArrayList builders = Lists.newArrayListWithExpectedSize((int)(limit < 1024 ? limit : 1024));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectModPostsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            Timestamp ts = new Timestamp(startTimestamp);
            if (type == null) {
                stmt = conn.prepareStatement(this.selectModPostsSQL);
                stmt.setTimestamp(1, ts);
                stmt.setTimestamp(2, ts);
                stmt.setLong(3, startId);
                stmt.setInt(4, limit);
            } else {
                stmt = conn.prepareStatement(this.selectModPostsWithTypeSQL);
                stmt.setString(1, type.toString().toLowerCase());
                stmt.setTimestamp(2, ts);
                stmt.setTimestamp(3, ts);
                stmt.setLong(4, startId);
                stmt.setInt(5, limit);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                builders.add(this.postFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        ArrayList posts = Lists.newArrayListWithExpectedSize((int)builders.size());
        for (Post.Builder builder : builders) {
            if (withResolve) {
                posts.add(this.resolve(builder).build());
                continue;
            }
            posts.add(builder.build());
        }
        return posts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Post> selectPosts(Post.Type type, Post.Status status, Post.Sort sort, Paging paging, boolean withResolve) throws SQLException {
        if (paging.limit < 1 || paging.start < 0) {
            return ImmutableList.of();
        }
        ArrayList builders = Lists.newArrayListWithExpectedSize((int)(paging.limit < 1024 ? paging.limit : 1024));
        StringBuilder sql = new StringBuilder(selectPostSQL);
        sql.append(this.postsTableName);
        sql.append(" WHERE post_type=? AND post_status=?");
        this.appendPagingSortSQL(sql, sort, paging);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectPostsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, type.toString().toLowerCase());
            stmt.setString(2, status.toString().toLowerCase());
            if (paging.interval != null) {
                stmt.setTimestamp(3, new Timestamp(paging.interval.getStartMillis()));
                stmt.setTimestamp(4, new Timestamp(paging.interval.getEndMillis()));
                stmt.setInt(5, paging.start);
                stmt.setInt(6, paging.limit);
            } else {
                stmt.setInt(3, paging.start);
                stmt.setInt(4, paging.limit);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                builders.add(this.postFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        ArrayList posts = Lists.newArrayListWithExpectedSize((int)builders.size());
        for (Post.Builder builder : builders) {
            if (withResolve) {
                posts.add(this.resolve(builder).build());
                continue;
            }
            posts.add(builder.build());
        }
        return posts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> selectPostIds(Post.Type type, Post.Status status, Collection<TaxonomyTerm> terms, Post.Sort sort, Paging paging) throws SQLException {
        if (paging.limit < 1 || paging.start < 0) {
            return ImmutableList.of();
        }
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)(paging.limit < 1024 ? paging.limit : 1024));
        StringBuilder sql = new StringBuilder("SELECT ID FROM ");
        sql.append(this.postsTableName);
        if (terms != null && terms.size() > 0) {
            sql.append(",").append(this.termRelationshipsTableName);
            sql.append(" WHERE post_type=? AND post_status=? AND object_id=ID AND ");
            if (terms.size() == 1) {
                sql.append("term_taxonomy_id=").append(terms.iterator().next().id);
            } else {
                sql.append("term_taxonomy_id IN (");
                Iterator<TaxonomyTerm> iter = terms.iterator();
                sql.append(iter.next().id);
                while (iter.hasNext()) {
                    sql.append(",").append(iter.next().id);
                }
                sql.append(")");
            }
        } else {
            sql.append(" WHERE post_type=? AND post_status=?");
        }
        this.appendPagingSortSQL(sql, sort, paging);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectPostIdsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, type.toString().toLowerCase());
            stmt.setString(2, status.toString().toLowerCase());
            if (paging.interval != null) {
                stmt.setTimestamp(3, new Timestamp(paging.interval.getStartMillis()));
                stmt.setTimestamp(4, new Timestamp(paging.interval.getEndMillis()));
                stmt.setInt(5, paging.start);
                stmt.setInt(6, paging.limit);
            } else {
                stmt.setInt(3, paging.start);
                stmt.setInt(4, paging.limit);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChildren(long parentId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.deleteChildrenTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.deleteChildrenSQL);
            stmt.setLong(1, parentId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Post> selectChildren(long parentId, boolean withResolve) throws SQLException {
        ArrayList builders = Lists.newArrayListWithExpectedSize((int)4);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectChildrenTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectChildrenSQL);
            stmt.setLong(1, parentId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                builders.add(this.postFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        ArrayList posts = Lists.newArrayListWithExpectedSize((int)builders.size());
        for (Post.Builder builder : builders) {
            if (withResolve) {
                posts.add(this.resolve(builder).build());
                continue;
            }
            posts.add(builder.build());
        }
        return posts;
    }

    private void appendPagingSortSQL(StringBuilder sql, Post.Sort sort, Paging paging) {
        if (paging.interval != null) {
            sql.append(" AND post_date");
            sql.append(paging.startIsOpen ? " >" : " >=");
            sql.append("?");
            sql.append(" AND post_date");
            sql.append(paging.endIsOpen ? " <" : " <=");
            sql.append("?");
        }
        switch (sort) {
            case ASC: {
                sql.append(" ORDER BY post_date ASC");
                break;
            }
            case DESC: {
                sql.append(" ORDER BY post_date DESC");
                break;
            }
            case ASC_MOD: {
                sql.append(" ORDER BY post_modified ASC");
                break;
            }
            case DESC_MOD: {
                sql.append(" ORDER BY post_modified DESC");
                break;
            }
            case ID_ASC: {
                sql.append(" ORDER BY ID ASC");
                break;
            }
            case ID_DESC: {
                sql.append(" ORDER BY ID DESC");
                break;
            }
            default: {
                sql.append(" ORDER BY post_date DESC");
            }
        }
        sql.append(" LIMIT ?,?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Post> selectPosts(String slug, boolean withResolve) throws SQLException {
        ArrayList builders = Lists.newArrayListWithExpectedSize((int)2);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectSlugPostsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectPostsBySlugSQL);
            stmt.setString(1, slug);
            rs = stmt.executeQuery();
            while (rs.next()) {
                builders.add(this.postFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        ArrayList posts = Lists.newArrayListWithExpectedSize((int)builders.size());
        for (Post.Builder builder : builders) {
            if (withResolve) {
                posts.add(this.resolve(builder).build());
                continue;
            }
            posts.add(builder.build());
        }
        return posts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Post.Builder resolve(Post.Builder post) throws SQLException {
        Timer.Context ctx = this.metrics.resolvePostTimer.time();
        try {
            List<Post> children;
            List<TaxonomyTerm> terms;
            List<Meta> meta;
            User author = this.resolveUser(post.getAuthorId());
            if (author != null) {
                meta = this.userMetadata(post.getAuthorId());
                if (meta.size() > 0) {
                    author = author.withMetadata(meta);
                }
                post.setAuthor(author);
            }
            if ((meta = this.selectPostMeta(post.getId())).size() > 0) {
                post.setMetadata(meta);
            }
            if ((terms = this.selectPostTerms(post.getId())).size() > 0) {
                post.setTaxonomyTerms(terms);
            }
            if ((children = this.selectChildren(post.getId(), false)).size() > 0) {
                post.setChildren(children);
            }
            Post.Builder builder = post;
            return builder;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Post.Builder selectPost(long postId) throws SQLException {
        Post.Builder builder;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectPostTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(selectPostSQL + this.postsTableName + " WHERE ID=?");
            stmt.setLong(1, postId);
            rs = stmt.executeQuery();
            builder = rs.next() ? this.postFromResultSet(rs) : null;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Post updatePost(Post post, TimeZone tz) throws SQLException {
        Post post2;
        if (post.id < 1L) {
            throw new SQLException("The post id must be specified for update");
        }
        post = post.modifiedNow();
        int offset = tz.getOffset(post.publishTimestamp);
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.updatePostTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.updatePostSQL);
            stmt.setLong(1, post.authorId);
            stmt.setTimestamp(2, new Timestamp(post.publishTimestamp));
            stmt.setTimestamp(3, new Timestamp(post.publishTimestamp - (long)offset));
            stmt.setString(4, Strings.nullToEmpty((String)post.content));
            stmt.setString(5, Strings.nullToEmpty((String)post.title));
            stmt.setString(6, Strings.nullToEmpty((String)post.excerpt));
            stmt.setString(7, post.status.toString().toLowerCase());
            stmt.setString(8, Strings.nullToEmpty((String)post.slug));
            stmt.setTimestamp(9, new Timestamp(post.modifiedTimestamp));
            stmt.setTimestamp(10, new Timestamp(post.modifiedTimestamp - (long)offset));
            stmt.setLong(11, post.parentId);
            stmt.setString(12, Strings.nullToEmpty((String)post.guid));
            stmt.setString(13, post.type.toString().toLowerCase());
            stmt.setString(14, post.mimeType != null ? post.mimeType : "");
            stmt.setLong(15, post.id);
            stmt.executeUpdate();
            post2 = post;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
        return post2;
    }

    public Post insertPost(Post post, TimeZone tz) throws SQLException {
        block4: {
            Post post2;
            if (post.id > 0L) {
                return this.insertPostWithId(post, tz);
            }
            int offset = tz.getOffset(post.publishTimestamp);
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Timer.Context ctx = this.metrics.insertPostTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(this.insertPostSQL, 1);
                stmt.setLong(1, post.authorId);
                stmt.setTimestamp(2, new Timestamp(post.publishTimestamp));
                stmt.setTimestamp(3, new Timestamp(post.publishTimestamp - (long)offset));
                stmt.setString(4, Strings.nullToEmpty((String)post.content));
                stmt.setString(5, Strings.nullToEmpty((String)post.title));
                stmt.setString(6, Strings.nullToEmpty((String)post.excerpt));
                stmt.setString(7, post.status.toString().toLowerCase());
                stmt.setString(8, Strings.nullToEmpty((String)post.slug));
                stmt.setTimestamp(9, new Timestamp(post.modifiedTimestamp));
                stmt.setTimestamp(10, new Timestamp(post.modifiedTimestamp - (long)offset));
                stmt.setLong(11, post.parentId);
                stmt.setString(12, Strings.nullToEmpty((String)post.guid));
                stmt.setString(13, post.type.toString().toLowerCase());
                stmt.setString(14, post.mimeType != null ? post.mimeType : "");
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) break block4;
                post2 = post.withId(rs.getLong(1));
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return post2;
        }
        throw new SQLException("Problem creating post (no generated id)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Post insertPostWithId(Post post, TimeZone tz) throws SQLException {
        Post post2;
        int offset = tz.getOffset(post.publishTimestamp);
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.insertPostTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.insertPostWithIdSQL);
            stmt.setLong(1, post.id);
            stmt.setLong(2, post.authorId);
            stmt.setTimestamp(3, new Timestamp(post.publishTimestamp));
            stmt.setTimestamp(4, new Timestamp(post.publishTimestamp - (long)offset));
            stmt.setString(5, Strings.nullToEmpty((String)post.content));
            stmt.setString(6, Strings.nullToEmpty((String)post.title));
            stmt.setString(7, Strings.nullToEmpty((String)post.excerpt));
            stmt.setString(8, post.status.toString().toLowerCase());
            stmt.setString(9, Strings.nullToEmpty((String)post.slug));
            stmt.setTimestamp(10, new Timestamp(post.modifiedTimestamp));
            stmt.setTimestamp(11, new Timestamp(post.modifiedTimestamp - (long)offset));
            stmt.setLong(12, post.parentId);
            stmt.setString(13, Strings.nullToEmpty((String)post.guid));
            stmt.setString(14, post.type.toString().toLowerCase());
            stmt.setString(15, post.mimeType != null ? post.mimeType : "");
            stmt.executeUpdate();
            post2 = post;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
        return post2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPostMeta(long postId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.clearPostMetaTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.deletePostMetaSQL);
            stmt.setLong(1, postId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Meta> selectPostMeta(long postId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList meta = Lists.newArrayListWithExpectedSize((int)8);
        Timer.Context ctx = this.metrics.selectPostMetaTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectPostMetaSQL);
            stmt.setLong(1, postId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                meta.add(new Meta(rs.getLong(1), rs.getString(2), rs.getString(3)));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostMeta(long postId, List<Meta> postMeta) throws SQLException {
        this.clearPostMeta(postId);
        if (postMeta == null || postMeta.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.setPostMetaTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.insertPostMetaSQL);
            for (Meta meta : postMeta) {
                stmt.setLong(1, postId);
                stmt.setString(2, meta.key);
                stmt.setString(3, meta.value);
                stmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> selectTermIds(String name) throws SQLException {
        HashSet hashSet;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashSet ids = Sets.newHashSetWithExpectedSize((int)4);
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectTermIdsSQL);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
            hashSet = ids;
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly((Connection)conn, stmt, rs);
            throw throwable;
        }
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return hashSet;
    }

    public Term createTerm(String name, String slug) throws SQLException {
        block3: {
            Term term;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Timer.Context ctx = this.metrics.createTermTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(this.insertTermSQL, 1);
                stmt.setString(1, name);
                stmt.setString(2, slug);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) break block3;
                term = new Term(rs.getLong(1), name, slug);
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return term;
        }
        throw new SQLException("Problem creating term (no generated id)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Term selectTerm(long id) throws SQLException {
        Term term;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Timer.Context ctx = this.metrics.selectTermTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectTermIdSQL);
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            term = rs.next() ? new Term(id, rs.getString(1), rs.getString(2)) : null;
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyTerm selectTaxonomyTerm(String taxonomy, String name) throws SQLException {
        Timer.Context ctx;
        String description;
        long termId;
        long taxonomyTermId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            TaxonomyTerm taxonomyTerm;
            conn = null;
            stmt = null;
            rs = null;
            taxonomyTermId = 0L;
            termId = 0L;
            description = "";
            ctx = this.metrics.selectTaxonomyTermTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(this.selectTaxonomyTermSQL);
                stmt.setString(1, name);
                stmt.setString(2, taxonomy);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    taxonomyTermId = rs.getLong(1);
                    termId = rs.getLong(2);
                    description = rs.getString(3);
                    break block3;
                }
                taxonomyTerm = null;
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return taxonomyTerm;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return new TaxonomyTerm(taxonomyTermId, taxonomy, this.selectTerm(termId), description);
    }

    public TaxonomyTerm createTaxonomyTerm(String taxonomy, String name, String slug, String description) throws SQLException {
        block3: {
            TaxonomyTerm taxonomyTerm;
            Term term = this.createTerm(name, slug);
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Timer.Context ctx = this.metrics.createTaxonomyTermTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(this.insertTaxonomyTermSQL, 1);
                stmt.setLong(1, term.id);
                stmt.setString(2, taxonomy);
                stmt.setString(3, Strings.nullToEmpty((String)description));
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) break block3;
                taxonomyTerm = new TaxonomyTerm(rs.getLong(1), taxonomy, term, description);
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return taxonomyTerm;
        }
        throw new SQLException("Problem creating taxonomy term (no generated id)");
    }

    public TaxonomyTerm resolveTaxonomyTerm(String taxonomy, String name) throws SQLException {
        TaxonomyTerm term;
        Cache taxonomyTermCache = (Cache)this.taxonomyTermCaches.get((Object)taxonomy);
        if (taxonomyTermCache != null) {
            this.metrics.taxonomyTermCacheTries.mark();
            term = (TaxonomyTerm)taxonomyTermCache.getIfPresent((Object)name);
            if (term != null) {
                this.metrics.taxonomyTermCacheHits.mark();
                return term;
            }
        }
        if ((term = this.selectTaxonomyTerm(taxonomy, name)) == null) {
            term = this.createTaxonomyTerm(taxonomy, name, Util.slugify(name), "");
        }
        if (taxonomyTermCache != null) {
            taxonomyTermCache.put((Object)name, (Object)term);
        }
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyTerm resolveTaxonomyTerm(long id) throws SQLException {
        this.metrics.taxonomyTermCacheTries.mark();
        TaxonomyTerm term = (TaxonomyTerm)this.taxonomyTermCache.getIfPresent((Object)id);
        if (term != null) {
            this.metrics.taxonomyTermCacheHits.mark();
            return term;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long termId = 0L;
        String taxonomy = "";
        String description = "";
        Timer.Context ctx = this.metrics.taxonomyTermResolveTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectTaxonomyTermIdSQL);
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                taxonomy = rs.getString(1);
                termId = rs.getLong(2);
                description = rs.getString(3);
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        if (termId > 0L) {
            term = new TaxonomyTerm(id, taxonomy, this.selectTerm(termId), description);
            this.taxonomyTermCache.put((Object)id, (Object)term);
            return term;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPostTerm(long postId, long taxonomyTermId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.postTermsClearTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.clearPostTermSQL);
            stmt.setLong(1, postId);
            stmt.setLong(2, taxonomyTermId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPostTerms(long postId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.postTermsClearTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.clearPostTermsSQL);
            stmt.setLong(1, postId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
    }

    public void clearPostTerms(long postId, String taxonomy) throws SQLException {
        List<TaxonomyTerm> terms = this.selectPostTerms(postId, taxonomy);
        for (TaxonomyTerm term : terms) {
            this.clearPostTerm(postId, term.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyTerm> setPostTerms(long postId, String taxonomy, List<String> terms) throws SQLException {
        this.clearPostTerms(postId, taxonomy);
        if (terms == null || terms.size() == 0) {
            return ImmutableList.of();
        }
        ArrayList taxonomyTerms = Lists.newArrayListWithExpectedSize((int)terms.size());
        for (String term : terms) {
            taxonomyTerms.add(this.resolveTaxonomyTerm(taxonomy, term));
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        Timer.Context ctx = this.metrics.postTermsSetTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.insertPostTermSQL);
            int pos = 0;
            for (TaxonomyTerm taxonomyTerm : taxonomyTerms) {
                stmt.setLong(1, postId);
                stmt.setLong(2, taxonomyTerm.id);
                stmt.setInt(3, pos++);
                stmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, stmt);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt);
        return taxonomyTerms;
    }

    public List<TaxonomyTerm> selectPostTerms(long postId) throws SQLException {
        return this.selectPostTerms(postId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyTerm> selectPostTerms(long postId, String taxonomy) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList termIds = Lists.newArrayListWithExpectedSize((int)8);
        Timer.Context ctx = this.metrics.postTermsSelectTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(this.selectPostTermsSQL);
            stmt.setLong(1, postId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                termIds.add(rs.getLong(1));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        if (termIds.size() == 0) {
            return ImmutableList.of();
        }
        ArrayList terms = Lists.newArrayListWithExpectedSize((int)termIds.size());
        Iterator iterator = termIds.iterator();
        while (iterator.hasNext()) {
            long termId = (Long)iterator.next();
            TaxonomyTerm term = this.resolveTaxonomyTerm(termId);
            if (term == null || taxonomy != null && !term.taxonomy.equals(taxonomy)) continue;
            terms.add(term);
        }
        return terms;
    }

    public String selectOption(String optionName) throws SQLException {
        return this.selectOption(optionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectOption(String optionName, String defaultValue) throws SQLException {
        Timer.Context ctx;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            String string;
            conn = null;
            stmt = null;
            rs = null;
            ctx = this.metrics.optionSelectTimer.time();
            try {
                conn = this.connectionSupplier.getConnection();
                stmt = conn.prepareStatement(this.selectOptionSQL);
                stmt.setString(1, optionName);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                String val = rs.getString(1);
                string = val != null ? val.trim() : defaultValue;
            }
            catch (Throwable throwable) {
                ctx.stop();
                SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
                throw throwable;
            }
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return string;
        }
        String string = defaultValue;
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return string;
    }

    public Site selectSite() throws SQLException {
        String baseURL = this.selectOption("home");
        String title = this.selectOption("blogname");
        String description = this.selectOption("blogdescription");
        String permalinkStructure = this.selectOption("permalink_structure", "/?p=%postid%");
        long defaultCategoryId = Long.parseLong(this.selectOption("default_category", "0"));
        TaxonomyTerm defaultCategoryTerm = this.resolveTaxonomyTerm(defaultCategoryId);
        if (defaultCategoryTerm == null) {
            defaultCategoryTerm = new TaxonomyTerm(0L, "category", new Term(0L, "Uncategorized", "uncategorized"), "");
        }
        return new Site(this.siteId, baseURL, title, description, permalinkStructure, defaultCategoryTerm.term);
    }

    private Blog blogFromResultSet(ResultSet rs) throws SQLException {
        long registeredTimestamp = 0L;
        long lastUpdatedTimestamp = 0L;
        try {
            registeredTimestamp = rs.getTimestamp(5).getTime();
        }
        catch (SQLException se) {
            registeredTimestamp = 0L;
        }
        try {
            lastUpdatedTimestamp = rs.getTimestamp(6).getTime();
        }
        catch (SQLException se) {
            lastUpdatedTimestamp = 0L;
        }
        return new Blog(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), registeredTimestamp, lastUpdatedTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Blog> selectPublicBlogs() throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList blogs = Lists.newArrayListWithExpectedSize((int)4);
        Timer.Context ctx = this.metrics.selectBlogsTimer.time();
        try {
            conn = this.connectionSupplier.getConnection();
            stmt = conn.prepareStatement(selectPublicBlogsSQL);
            rs = stmt.executeQuery();
            while (rs.next()) {
                blogs.add(this.blogFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            ctx.stop();
            SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, rs);
            throw throwable;
        }
        ctx.stop();
        SQLUtil.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return blogs;
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics.getMetrics();
    }
}

