/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.attribyte.api.InitializationException;
import org.attribyte.sql.ConnectionSupplier;

public class SimpleConnectionSource
implements ConnectionSupplier {
    private final String connectionString;
    private final String user;
    private final String password;

    public SimpleConnectionSource(Properties props) throws InitializationException {
        this.user = props.getProperty("user", "");
        this.password = props.getProperty("password", "");
        String driver = props.getProperty("driver", "com.mysql.jdbc.Driver");
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Unable to initialize JDBC driver '%s'", driver), (Throwable)e);
        }
        if (props.getProperty("connectionString") == null) {
            String host = props.getProperty("host", null);
            String port = props.getProperty("port", "3306");
            String db = props.getProperty("db", null);
            if (host == null) {
                throw new InitializationException("A 'host' property must be specified");
            }
            if (db == null) {
                throw new InitializationException("A 'db' property must be specified");
            }
            this.connectionString = "jdbc:mysql://" + host + ":" + port + "/" + db;
        } else {
            this.connectionString = props.getProperty("connectionString");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.user != null && this.password != null ? DriverManager.getConnection(this.connectionString, this.user, this.password) : DriverManager.getConnection(this.connectionString);
    }
}

