/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.attribyte.wp.model.Meta;
import org.attribyte.wp.model.TaxonomyTerm;
import org.attribyte.wp.model.User;

public class Post {
    public final long id;
    public final String slug;
    public final String title;
    public final String excerpt;
    public final String content;
    public final long authorId;
    public final User author;
    public final long publishTimestamp;
    public final long modifiedTimestamp;
    public final Status status;
    public final long parentId;
    public final String guid;
    public final int commentCount;
    public final ImmutableList<Meta> metadata;
    public final Type type;
    public final String mimeType;
    public final ImmutableMap<String, ImmutableList<TaxonomyTerm>> taxonomyTerms;
    public final ImmutableList<Post> children;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Post post) {
        return new Builder(post);
    }

    protected Post(Post other) {
        this(other.id, other.slug, other.title, other.excerpt, other.content, other.authorId, other.author, other.publishTimestamp, other.modifiedTimestamp, other.status, other.parentId, other.guid, other.commentCount, (Collection<Meta>)other.metadata, other.type, other.mimeType, other.taxonomyTerms, other.children);
    }

    Post(long id, String slug, String title, String excerpt, String content, long authorId, User author, long publishTimestamp, long modifiedTimestamp, Status status, long parentId, String guid, int commentCount, Collection<Meta> metadata, Type type, String mimeType, ImmutableMap<String, ImmutableList<TaxonomyTerm>> taxonomyTerms, ImmutableList<Post> children) {
        this.id = id;
        this.slug = slug;
        this.title = title;
        this.excerpt = excerpt;
        this.content = content;
        this.authorId = authorId;
        this.author = author;
        this.publishTimestamp = publishTimestamp;
        this.modifiedTimestamp = modifiedTimestamp;
        this.status = status;
        this.parentId = parentId;
        this.guid = guid;
        this.commentCount = commentCount;
        this.metadata = metadata != null ? ImmutableList.copyOf(metadata) : ImmutableList.of();
        this.type = type;
        this.mimeType = mimeType;
        this.taxonomyTerms = taxonomyTerms;
        this.children = children;
    }

    public final Post modifiedNow() {
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, System.currentTimeMillis(), this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withContent(String content) {
        return new Post(this.id, this.slug, this.title, this.excerpt, content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withId(long id) {
        return new Post(id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withParent(long parentId) {
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withAuthor(User user) {
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, user, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withTaxonomyTerms(Map<String, List<TaxonomyTerm>> taxonomyTerms) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (taxonomyTerms != null && taxonomyTerms.size() > 0) {
            taxonomyTerms.entrySet().forEach(kv -> builder.put(kv.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)kv.getValue()))));
        }
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, (ImmutableMap<String, ImmutableList<TaxonomyTerm>>)builder.build(), this.children);
    }

    public final Post withMetadata(List<Meta> metadata) {
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, metadata, this.type, this.mimeType, this.taxonomyTerms, this.children);
    }

    public final Post withChildren(List<Post> children) {
        return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, (Collection<Meta>)this.metadata, this.type, this.mimeType, this.taxonomyTerms, (ImmutableList<Post>)(children != null ? ImmutableList.copyOf(children) : ImmutableList.of()));
    }

    public final ImmutableList<TaxonomyTerm> terms(String taxonomy) {
        ImmutableList terms = (ImmutableList)this.taxonomyTerms.get((Object)taxonomy);
        return terms != null ? terms : ImmutableList.of();
    }

    public final ImmutableList<TaxonomyTerm> tags() {
        ImmutableList tags = (ImmutableList)this.taxonomyTerms.get((Object)"post_tag");
        return tags != null ? tags : ImmutableList.of();
    }

    public final ImmutableList<TaxonomyTerm> categories() {
        ImmutableList categories = (ImmutableList)this.taxonomyTerms.get((Object)"category");
        return categories != null ? categories : ImmutableList.of();
    }

    public static class Builder {
        private long id;
        private String slug;
        private String title;
        private String excerpt;
        private String content;
        private long authorId;
        private User author;
        private long publishTimestamp;
        private long modifiedTimestamp;
        private Status status = Status.PUBLISH;
        private long parentId;
        private String guid;
        private int commentCount;
        private List<Meta> metadata;
        private Type type = Type.POST;
        private String mimeType;
        private Map<String, List<TaxonomyTerm>> taxonomyTerms;
        private List<Post> children;

        public long getId() {
            return this.id;
        }

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public String getSlug() {
            return this.slug;
        }

        public Builder setSlug(String slug) {
            this.slug = slug;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getExcerpt() {
            return this.excerpt;
        }

        public Builder setExcerpt(String excerpt) {
            this.excerpt = excerpt;
            return this;
        }

        public String getContent() {
            return this.content;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public long getAuthorId() {
            return this.authorId;
        }

        public Builder setAuthorId(long authorId) {
            this.authorId = authorId;
            return this;
        }

        public User getAuthor() {
            return this.author;
        }

        public Builder setAuthor(User author) {
            this.author = author;
            return this;
        }

        public long getPublishTimestamp() {
            return this.publishTimestamp;
        }

        public Builder setPublishTimestamp(long publishTimestamp) {
            this.publishTimestamp = publishTimestamp;
            return this;
        }

        public long getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        public Builder setModifiedTimestamp(long modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public Status getStatus() {
            return this.status;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public long getParentId() {
            return this.parentId;
        }

        public Builder setParentId(long parentId) {
            this.parentId = parentId;
            return this;
        }

        public String getGUID() {
            return this.guid;
        }

        public Builder setGUID(String guid) {
            this.guid = guid;
            return this;
        }

        public int getCommentCount() {
            return this.commentCount;
        }

        public Builder setCommentCount(int commentCount) {
            this.commentCount = commentCount;
            return this;
        }

        public List<Meta> getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(List<Meta> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setTaxonomyTerms(List<TaxonomyTerm> terms) {
            if (this.taxonomyTerms == null) {
                this.taxonomyTerms = Maps.newHashMapWithExpectedSize((int)4);
            } else {
                this.taxonomyTerms.clear();
            }
            if (terms != null) {
                for (TaxonomyTerm term : terms) {
                    this.addTaxonomyTerm(term);
                }
            }
            return this;
        }

        public Builder addTaxonomyTerm(TaxonomyTerm term) {
            ArrayList terms;
            if (this.taxonomyTerms == null) {
                this.taxonomyTerms = Maps.newLinkedHashMapWithExpectedSize((int)4);
            }
            if ((terms = this.taxonomyTerms.get(term.taxonomy)) == null) {
                terms = Lists.newArrayListWithExpectedSize((int)8);
                this.taxonomyTerms.put(term.taxonomy, terms);
            }
            terms.add(term);
            return this;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public List<Post> getChildren() {
            return this.children;
        }

        public void setChildren(List<Post> children) {
            this.children = children;
        }

        Builder() {
        }

        Builder(Post post) {
            this.id = post.id;
            this.slug = post.slug;
            this.title = post.title;
            this.excerpt = post.excerpt;
            this.content = post.content;
            this.authorId = post.authorId;
            this.author = post.author;
            this.publishTimestamp = post.publishTimestamp;
            this.modifiedTimestamp = post.modifiedTimestamp;
            this.status = post.status;
            this.parentId = post.parentId;
            this.guid = post.guid;
            this.commentCount = post.commentCount;
            this.metadata = post.metadata != null ? Lists.newArrayList(post.metadata) : Lists.newArrayList();
            this.type = post.type;
            this.mimeType = post.mimeType;
            this.taxonomyTerms = post.taxonomyTerms != null ? Maps.newHashMap(post.taxonomyTerms) : null;
            this.children = post.children != null ? Lists.newArrayList(post.children) : null;
        }

        public Post build() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (this.taxonomyTerms != null && this.taxonomyTerms.size() > 0) {
                this.taxonomyTerms.entrySet().forEach(kv -> builder.put(kv.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)kv.getValue()))));
            }
            return new Post(this.id, this.slug, this.title, this.excerpt, this.content, this.authorId, this.author, this.publishTimestamp, this.modifiedTimestamp, this.status, this.parentId, this.guid, this.commentCount, this.metadata, this.type, this.mimeType, (ImmutableMap<String, ImmutableList<TaxonomyTerm>>)builder.build(), (ImmutableList<Post>)(this.children != null ? ImmutableList.copyOf(this.children) : ImmutableList.of()));
        }
    }

    public static enum Sort {
        ASC,
        DESC,
        ASC_MOD,
        DESC_MOD,
        ID_ASC,
        ID_DESC;

    }

    public static enum CommentStatus {
        OPEN,
        CLOSED,
        UNKNOWN;


        public static CommentStatus fromString(String str) {
            switch (Strings.nullToEmpty((String)str).trim().toLowerCase()) {
                case "open": {
                    return OPEN;
                }
                case "closed": {
                    return CLOSED;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Type {
        POST,
        PAGE,
        ATTACHMENT,
        REVISION,
        UNKNOWN;


        public static Type fromString(String str) {
            switch (Strings.nullToEmpty((String)str).trim().toLowerCase()) {
                case "post": {
                    return POST;
                }
                case "page": {
                    return PAGE;
                }
                case "attachment": {
                    return ATTACHMENT;
                }
                case "revision": {
                    return REVISION;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Status {
        DRAFT,
        AUTO_DRAFT,
        PENDING,
        PRIVATE,
        PUBLISH,
        INHERIT,
        UNKNOWN;


        public static Status fromString(String str) {
            switch (Strings.nullToEmpty((String)str).trim().toLowerCase()) {
                case "draft": {
                    return DRAFT;
                }
                case "auto-draft": {
                    return AUTO_DRAFT;
                }
                case "pending": {
                    return PENDING;
                }
                case "private": {
                    return PRIVATE;
                }
                case "publish": {
                    return PUBLISH;
                }
                case "inherit": {
                    return INHERIT;
                }
            }
            return UNKNOWN;
        }
    }
}

