/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Shortcode {
    public final String name;
    public final ImmutableMap<String, String> attributes;
    public final String content;

    public Shortcode(String name, Map<String, String> attributes) {
        this(name, attributes, null);
    }

    public Shortcode(String name, Map<String, String> attributes, String content) {
        this.name = name;
        this.attributes = attributes != null ? ImmutableMap.copyOf(attributes) : ImmutableMap.of();
        this.content = Strings.emptyToNull((String)content);
    }

    public Shortcode withContent(String content) {
        return new Shortcode(this.name, (Map<String, String>)this.attributes, content);
    }

    public final String positionalValue(int pos) {
        return (String)this.attributes.get((Object)String.format("$%d", pos));
    }

    public final List<String> positionalValues() {
        return this.attributes.entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith("$")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder("[");
        buf.append(this.name);
        this.attributes.entrySet().forEach(kv -> {
            if (((String)kv.getKey()).startsWith("$")) {
                buf.append(" ");
                if (((String)kv.getValue()).contains(" ")) {
                    buf.append("\"").append(Shortcode.escapeAttribute((String)kv.getValue())).append("\"");
                } else {
                    buf.append((String)kv.getValue());
                }
            } else {
                buf.append(" ").append((String)kv.getKey()).append("=\"").append(Shortcode.escapeAttribute((String)kv.getValue())).append("\"");
            }
        });
        buf.append("]");
        if (this.content != null) {
            buf.append(this.content);
            buf.append("[/").append(this.name).append("]");
        }
        return buf.toString();
    }

    public static Shortcode parse(String shortcode) throws ParseException {
        String exp = shortcode.trim();
        if (exp.length() < 3) {
            throw new ParseException(String.format("Invalid shortcode ('%s')", exp), 0);
        }
        if (exp.charAt(0) != '[') {
            throw new ParseException("Expecting '['", 0);
        }
        int end = exp.indexOf(93);
        if (end == -1) {
            throw new ParseException("Expecting ']", 0);
        }
        Shortcode startTag = Parser.parseStart(exp.substring(0, end + 1));
        end = exp.lastIndexOf("[/");
        if (end > 0) {
            if (exp.endsWith("[/" + startTag.name + "]")) {
                int start = shortcode.indexOf("]");
                return startTag.withContent(exp.substring(start + 1, end));
            }
            throw new ParseException("Invalid shortcode end", 0);
        }
        return startTag;
    }

    public static String escapeAttribute(String val) {
        return Strings.nullToEmpty((String)val);
    }

    private static class Parser {
        private Parser() {
        }

        private static boolean isNameCharacter(char ch) {
            return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-';
        }

        private static String validateName(String str) throws ParseException {
            for (char ch : str.toCharArray()) {
                if (Parser.isNameCharacter(ch)) continue;
                throw new ParseException(String.format("Invalid name ('%s')", str), 0);
            }
            return str;
        }

        private static Shortcode parseStart(String str) throws ParseException {
            String exp = str.trim();
            if (exp.length() < 3) {
                throw new ParseException(String.format("Invalid shortcode ('%s')", str), 0);
            }
            if (exp.charAt(0) != '[') {
                throw new ParseException("Expecting '['", 0);
            }
            if (exp.charAt(exp.length() - 1) != ']') {
                throw new ParseException("Expecting ']'", exp.length() - 1);
            }
            if ((exp = exp.substring(1, exp.length() - 1).trim()).length() == 0) {
                throw new ParseException(String.format("Invalid shortcode ('%s')", str), 0);
            }
            int attrStart = exp.indexOf(32);
            if (attrStart < 0) {
                return new Shortcode(Parser.validateName(exp), (Map<String, String>)ImmutableMap.of());
            }
            return new Shortcode(Parser.validateName(exp.substring(0, attrStart)), Parser.parseAttributes(exp.substring(attrStart).trim()));
        }

        private static Map<String, String> parseAttributes(String attrString) throws ParseException {
            AttributeString str = new AttributeString(attrString);
            ImmutableMap.Builder attributes = ImmutableMap.builder();
            AttrState state = AttrState.NAME;
            String currName = "";
            String currString = "";
            int currPos = 0;
            while ((currString = str.nextString()) != null) {
                switch (state) {
                    case NAME: {
                        if (str.ch == '=') {
                            currName = currString;
                            state = AttrState.VALUE;
                            break;
                        }
                        attributes.put((Object)String.format("$%d", currPos++), (Object)currString);
                        break;
                    }
                    case VALUE: {
                        attributes.put((Object)currName.toLowerCase(), (Object)currString);
                        state = AttrState.NAME;
                    }
                }
            }
            return attributes.build();
        }

        private static enum AttrState {
            NAME,
            VALUE;

        }

        private static class AttributeString {
            char ch;
            int pos = 0;
            String last;
            final char[] chars;
            final StringBuilder buf;

            AttributeString(String str) {
                this.chars = str.toCharArray();
                this.buf = new StringBuilder();
            }

            private String value() {
                String val = this.buf.toString();
                this.buf.setLength(0);
                if (this.ch == ' ') {
                    for (int currPos = this.pos; currPos < this.chars.length; ++currPos) {
                        char currChar = this.chars[currPos];
                        if (currChar == ' ') continue;
                        this.pos = currPos;
                        this.ch = this.chars[this.pos];
                        break;
                    }
                }
                return val;
            }

            String nextString() throws ParseException {
                StringState state = StringState.BEFORE_START;
                block27: while (this.pos < this.chars.length) {
                    this.ch = this.chars[this.pos++];
                    switch (this.ch) {
                        case '=': {
                            switch (state) {
                                case BEFORE_START: {
                                    state = StringState.VALUE;
                                    break;
                                }
                                case QUOTED_VALUE: {
                                    this.buf.append(this.ch);
                                    break;
                                }
                                case VALUE: {
                                    return this.value();
                                }
                            }
                            continue block27;
                        }
                        case ' ': {
                            switch (state) {
                                case BEFORE_START: {
                                    break;
                                }
                                case QUOTED_VALUE: {
                                    this.buf.append(this.ch);
                                    break;
                                }
                                case VALUE: {
                                    return this.value();
                                }
                            }
                            continue block27;
                        }
                        case '\"': 
                        case '\'': {
                            switch (state) {
                                case BEFORE_START: {
                                    state = StringState.QUOTED_VALUE;
                                    break;
                                }
                                case QUOTED_VALUE: {
                                    return this.value();
                                }
                                case VALUE: {
                                    throw new ParseException("Unexpected '\"'", this.pos);
                                }
                            }
                            continue block27;
                        }
                    }
                    switch (state) {
                        case BEFORE_START: {
                            state = StringState.VALUE;
                        }
                    }
                    this.buf.append(this.ch);
                }
                switch (state) {
                    case VALUE: {
                        return this.buf.toString();
                    }
                    case QUOTED_VALUE: {
                        throw new ParseException("Expected '\"' or '''", this.pos);
                    }
                }
                return null;
            }

            static enum StringState {
                BEFORE_START,
                QUOTED_VALUE,
                VALUE;

            }
        }
    }
}

