/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Properties;
import org.attribyte.wp.model.Post;
import org.attribyte.wp.model.TaxonomyTerm;
import org.attribyte.wp.model.Term;
import org.joda.time.DateTime;

public class Site {
    public final long id;
    public final String baseURL;
    public final String title;
    public final String description;
    public final String permalinkStructure;
    public final Term defaultCategory;

    public Site(Properties props) {
        this.id = Long.parseLong(props.getProperty("id", "0"));
        this.baseURL = props.getProperty("baseURL");
        this.title = props.getProperty("title");
        this.description = props.getProperty("description");
        this.permalinkStructure = props.getProperty("permalinkStructure");
        long defaultCategoryId = Long.parseLong(props.getProperty("defaultCategoryId", "0"));
        String defaultCategoryName = props.getProperty("defaultCategoryName");
        String defaultCategorySlug = props.getProperty("defaultCategorySlug");
        this.defaultCategory = defaultCategoryId > 0L ? new Term(defaultCategoryId, defaultCategoryName, defaultCategorySlug) : null;
    }

    public Site(long id, String baseURL, String title, String description, String permalinkStructure, Term defaultCategory) {
        this.id = id;
        this.baseURL = baseURL;
        this.title = title;
        this.description = description;
        this.permalinkStructure = permalinkStructure;
        this.defaultCategory = defaultCategory;
    }

    public Site overrideWith(Site other) {
        return new Site(other.id > 0L ? other.id : this.id, other.baseURL != null ? other.baseURL : this.baseURL, other.title != null ? other.title : this.title, other.description != null ? other.description : this.description, other.permalinkStructure != null ? other.permalinkStructure : this.permalinkStructure, other.defaultCategory != null ? other.defaultCategory : this.defaultCategory);
    }

    public String buildPermalink(Post post) {
        String authorSlug = post.author != null ? Strings.nullToEmpty((String)post.author.slug) : "";
        ImmutableList<TaxonomyTerm> categories = post.categories();
        Term categoryTerm = categories.size() > 0 ? ((TaxonomyTerm)categories.get((int)0)).term : this.defaultCategory;
        String category = categoryTerm != null ? categoryTerm.slug : "";
        String post_id = Long.toString(post.id);
        DateTime publishTime = new DateTime(post.publishTimestamp);
        String year = Integer.toString(publishTime.getYear());
        String monthnum = String.format("%02d", publishTime.getMonthOfYear());
        String day = String.format("%02d", publishTime.getDayOfMonth());
        String hour = String.format("%02d", publishTime.getHourOfDay());
        String minute = String.format("%02d", publishTime.getMinuteOfHour());
        String second = String.format("%02d", publishTime.getSecondOfMinute());
        String path = this.permalinkStructure.replace("%year%", year).replace("%monthnum%", monthnum).replace("%day%", day).replace("%hour%", hour).replace("%minute%", minute).replace("%second%", second).replace("%post_id%", post_id).replace("%postname%", post.slug).replace("%category%", category).replace("%author%", authorSlug);
        return this.baseURL + path;
    }
}

