/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.wp.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.attribyte.wp.Util;
import org.attribyte.wp.model.Meta;

public class User {
    public final long id;
    public final String username;
    public final String displayName;
    public final String email;
    public final long createTimestamp;
    public final ImmutableList<Meta> metadata;
    public final String slug;

    public User(long id, String username, String displayName, String email, long createTimestamp, Collection<Meta> metadata) {
        this.id = id;
        this.username = username;
        this.displayName = displayName;
        this.email = email;
        this.createTimestamp = createTimestamp;
        this.metadata = metadata != null ? ImmutableList.copyOf(metadata) : ImmutableList.of();
        this.slug = Util.slugify(displayName);
    }

    public User withId(long id) {
        return new User(id, this.username, this.displayName, this.email, this.createTimestamp, (Collection<Meta>)this.metadata);
    }

    public User withMetadata(List<Meta> meta) {
        return new User(this.id, this.username, this.displayName, this.email, this.createTimestamp, (Collection<Meta>)this.metadata);
    }

    public final String displayName() {
        return Strings.nullToEmpty((String)this.displayName).trim().isEmpty() ? this.username : this.displayName;
    }
}

