/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.http.endpoint;

import automorph.log.LogProperties$;
import automorph.log.Logger;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.EffectSystem;
import automorph.spi.EndpointTransport;
import automorph.spi.RequestHandler;
import automorph.transport.http.HttpContext;
import automorph.transport.http.HttpContext$;
import automorph.transport.http.HttpMethod$;
import automorph.transport.http.Protocol;
import automorph.transport.http.endpoint.FinagleHttpEndpoint$;
import automorph.util.Extensions$;
import automorph.util.Network$;
import automorph.util.Random$;
import com.twitter.finagle.Service;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.io.Buf;
import com.twitter.io.Reader$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class FinagleHttpEndpoint<Effect>
extends Service<Request, Response>
implements Logging,
EndpointTransport<Effect, HttpContext<Request>, Service<Request, Response>>,
Product,
Serializable {
    private Logger logger;
    private final EffectSystem effectSystem;
    private final Function1 mapException;
    private final RequestHandler handler;
    private final MessageLog log;
    private final EffectSystem<Effect> system;

    public static FinagleHttpEndpoint<?> fromProduct(Product product) {
        return FinagleHttpEndpoint$.MODULE$.fromProduct(product);
    }

    public static <Effect> FinagleHttpEndpoint<Effect> unapply(FinagleHttpEndpoint<Effect> finagleHttpEndpoint) {
        return FinagleHttpEndpoint$.MODULE$.unapply(finagleHttpEndpoint);
    }

    public static <Effect> Function1<Throwable, Object> $lessinit$greater$default$2() {
        return FinagleHttpEndpoint$.MODULE$.$lessinit$greater$default$2();
    }

    public static <Effect> RequestHandler<Effect, HttpContext<Request>> $lessinit$greater$default$3() {
        return FinagleHttpEndpoint$.MODULE$.$lessinit$greater$default$3();
    }

    public FinagleHttpEndpoint(EffectSystem<Effect> effectSystem, Function1<Throwable, Object> mapException, RequestHandler<Effect, HttpContext<Request>> handler) {
        this.effectSystem = effectSystem;
        this.mapException = mapException;
        this.handler = handler;
        Logging.$init$((Logging)this);
        this.log = MessageLog$.MODULE$.apply(this.logger(), Protocol.Http$.MODULE$.name());
        this.system = effectSystem;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FinagleHttpEndpoint)) return false;
        FinagleHttpEndpoint finagleHttpEndpoint = (FinagleHttpEndpoint)object;
        EffectSystem<Effect> effectSystem = this.effectSystem();
        EffectSystem<Effect> effectSystem2 = finagleHttpEndpoint.effectSystem();
        if (effectSystem == null) {
            if (effectSystem2 != null) {
                return false;
            }
        } else if (!effectSystem.equals(effectSystem2)) return false;
        Function1<Throwable, Object> function1 = this.mapException();
        Function1<Throwable, Object> function12 = finagleHttpEndpoint.mapException();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        RequestHandler<Effect, HttpContext<Request>> requestHandler = this.handler();
        RequestHandler<Effect, HttpContext<Request>> requestHandler2 = finagleHttpEndpoint.handler();
        if (requestHandler == null) {
            if (requestHandler2 == null) return true;
            return false;
        } else {
            if (!requestHandler.equals(requestHandler2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof FinagleHttpEndpoint;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "FinagleHttpEndpoint";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "effectSystem";
            }
            case 1: {
                return "mapException";
            }
            case 2: {
                return "handler";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public EffectSystem<Effect> effectSystem() {
        return this.effectSystem;
    }

    public Function1<Throwable, Object> mapException() {
        return this.mapException;
    }

    public RequestHandler<Effect, HttpContext<Request>> handler() {
        return this.handler;
    }

    public Service<Request, Response> adapter() {
        return this;
    }

    public FinagleHttpEndpoint<Effect> withHandler(RequestHandler<Effect, HttpContext<Request>> handler) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), handler);
    }

    public Future<Response> apply(Request request) {
        LazyRef lazyRef = new LazyRef();
        String requestId = Random$.MODULE$.id();
        this.log.receivedRequest(() -> this.apply$$anonfun$1(request, requestId, lazyRef), this.log.receivedRequest$default$2());
        return (Future)Extensions$.MODULE$.TryOps(Try$.MODULE$.apply(() -> this.apply$$anonfun$2(request, requestId, lazyRef))).foldError((Function1 & Serializable)error -> Future$.MODULE$.apply(() -> this.apply$$anonfun$3$$anonfun$1(request, requestId, error, lazyRef)));
    }

    private Response createErrorResponse(Throwable error, Request request, String requestId, Function0<Map<String, String>> requestProperties) {
        this.log.failedProcessRequest(error, requestProperties, this.log.failedProcessRequest$default$3());
        byte[] responseBody = Extensions$.MODULE$.StringOps(Extensions$.MODULE$.ThrowableOps(error).trace().mkString("\n")).toByteArray();
        return this.createResponse(responseBody, Status$.MODULE$.InternalServerError(), (Option<HttpContext<Request>>)None$.MODULE$, request, requestId);
    }

    private Response createResponse(byte[] responseBody, Status status, Option<HttpContext<Request>> responseContext, Request request, String requestId) {
        LazyRef lazyRef = new LazyRef();
        Status responseStatus = (Status)responseContext.flatMap((Function1 & Serializable)_$6 -> _$6.statusCode().map((Function1 & Serializable)code -> Status$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)code)))).getOrElse(() -> FinagleHttpEndpoint.$anonfun$7(status));
        Response response = Response$.MODULE$.apply(request.version(), responseStatus, Reader$.MODULE$.fromBuf(Buf.ByteArray$.Owned$.MODULE$.apply(responseBody)));
        this.setResponseContext(response, responseContext);
        response.contentType_$eq(this.handler().mediaType());
        this.log.sendingResponse(() -> this.createResponse$$anonfun$1(request, requestId, responseStatus, lazyRef), this.log.sendingResponse$default$2());
        return response;
    }

    private HttpContext<Request> getRequestContext(Request request) {
        Some some = Some$.MODULE$.apply((Object)request);
        Some some2 = Some$.MODULE$.apply((Object)HttpMethod$.MODULE$.valueOf(request.method().name()));
        Seq seq = request.headerMap().iterator().toSeq();
        Option option = HttpContext$.MODULE$.$lessinit$greater$default$1();
        Option option2 = HttpContext$.MODULE$.$lessinit$greater$default$2();
        Option option3 = HttpContext$.MODULE$.$lessinit$greater$default$3();
        Option option4 = HttpContext$.MODULE$.$lessinit$greater$default$4();
        Option option5 = HttpContext$.MODULE$.$lessinit$greater$default$5();
        Seq seq2 = HttpContext$.MODULE$.$lessinit$greater$default$6();
        Option option6 = HttpContext$.MODULE$.$lessinit$greater$default$7();
        Option option7 = HttpContext$.MODULE$.$lessinit$greater$default$10();
        Option option8 = HttpContext$.MODULE$.$lessinit$greater$default$11();
        Option option9 = HttpContext$.MODULE$.$lessinit$greater$default$12();
        return HttpContext$.MODULE$.apply(option, option2, option3, option4, option5, seq2, option6, seq, (Option)some2, option7, option8, option9, (Option)some).url(request.uri());
    }

    private void setResponseContext(Response response, Option<HttpContext<Request>> responseContext) {
        ((IterableOnceOps)Option$.MODULE$.option2Iterable(responseContext).toSeq().flatMap((Function1 & Serializable)_$7 -> _$7.headers())).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return response.headerMap().add(name, value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Map<String, String> getRequestProperties(Request request, String requestId) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.client());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.clientAddress(request));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)request.uri());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Method");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)request.method().toString());
        return (Map)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private String clientAddress(Request request) {
        Option forwardedFor = request.xForwardedFor();
        String address = request.remoteAddress().toString();
        return Network$.MODULE$.address(forwardedFor, address);
    }

    private <T> Future<T> runAsFuture(Function0<Effect> value) {
        Promise promise = Promise$.MODULE$.apply();
        Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(value.apply()).either(this.system)).map((Function1)(JProcedure1 & Serializable)_$8 -> _$8.fold((Function1)(JProcedure1 & Serializable)error -> promise.setException(error), (Function1)(JProcedure1 & Serializable)result -> promise.setValue(result)), this.system)).runAsync(this.system);
        return promise;
    }

    public <Effect> FinagleHttpEndpoint<Effect> copy(EffectSystem<Effect> effectSystem, Function1<Throwable, Object> mapException, RequestHandler<Effect, HttpContext<Request>> handler) {
        return new FinagleHttpEndpoint<Effect>(effectSystem, mapException, handler);
    }

    public <Effect> EffectSystem<Effect> copy$default$1() {
        return this.effectSystem();
    }

    public <Effect> Function1<Throwable, Object> copy$default$2() {
        return this.mapException();
    }

    public <Effect> RequestHandler<Effect, HttpContext<Request>> copy$default$3() {
        return this.handler();
    }

    public EffectSystem<Effect> _1() {
        return this.effectSystem();
    }

    public Function1<Throwable, Object> _2() {
        return this.mapException();
    }

    public RequestHandler<Effect, HttpContext<Request>> _3() {
        return this.handler();
    }

    private final Map requestProperties$lzyINIT1$1(Request request$1, String requestId$1, LazyRef requestProperties$lzy1$1) {
        Map map;
        LazyRef lazyRef = requestProperties$lzy1$1;
        synchronized (lazyRef) {
            map = (Map)(requestProperties$lzy1$1.initialized() ? requestProperties$lzy1$1.value() : requestProperties$lzy1$1.initialize(this.getRequestProperties(request$1, requestId$1)));
        }
        return map;
    }

    private final Map requestProperties$1(Request request$2, String requestId$2, LazyRef requestProperties$lzy1$2) {
        return (Map)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : this.requestProperties$lzyINIT1$1(request$2, requestId$2, requestProperties$lzy1$2));
    }

    private final Map apply$$anonfun$1(Request request$12, String requestId$12, LazyRef requestProperties$lzy1$9) {
        return this.requestProperties$1(request$12, requestId$12, requestProperties$lzy1$9);
    }

    private final Map apply$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Request request$13, String requestId$13, LazyRef requestProperties$lzy1$10) {
        return this.requestProperties$1(request$13, requestId$13, requestProperties$lzy1$10);
    }

    private static final byte[] $anonfun$2() {
        return Array$.MODULE$.emptyByteArray();
    }

    private static final Status $anonfun$5() {
        return Status$.MODULE$.Ok();
    }

    private final Object apply$$anonfun$2$$anonfun$1(Request request$4, String requestId$4, byte[] requestBody$1, LazyRef requestProperties$lzy1$4) {
        Object handlerResult = this.handler().processRequest(requestBody$1, this.getRequestContext(request$4), requestId$4);
        return Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(handlerResult).either(this.system)).map((Function1 & Serializable)_$2 -> (Response)_$2.fold((Function1 & Serializable)error -> this.createErrorResponse((Throwable)error, request$4, requestId$4, (Function0<Map<String, String>>)((Function0 & Serializable)() -> this.apply$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(request$4, requestId$4, requestProperties$lzy1$4))), (Function1 & Serializable)result -> {
            byte[] responseBody = (byte[])result.map((Function1 & Serializable)_$3 -> _$3.responseBody()).getOrElse(FinagleHttpEndpoint::$anonfun$2);
            Status status = (Status)result.flatMap((Function1 & Serializable)_$4 -> _$4.exception()).map(this.mapException()).map((Function1 & Serializable)code -> Status$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)code))).getOrElse(FinagleHttpEndpoint::$anonfun$5);
            return this.createResponse(responseBody, status, (Option<HttpContext<Request>>)result.flatMap((Function1 & Serializable)_$5 -> _$5.context()), request$4, requestId$4);
        }), this.system);
    }

    private final Future apply$$anonfun$2(Request request$3, String requestId$3, LazyRef requestProperties$lzy1$3) {
        byte[] requestBody = Buf.ByteArray$.Owned$.MODULE$.extract(request$3.content());
        return this.runAsFuture(() -> this.apply$$anonfun$2$$anonfun$1(request$3, requestId$3, requestBody, requestProperties$lzy1$3));
    }

    private final Map apply$$anonfun$3$$anonfun$1$$anonfun$1(Request request$14, String requestId$14, LazyRef requestProperties$lzy1$11) {
        return this.requestProperties$1(request$14, requestId$14, requestProperties$lzy1$11);
    }

    private final Response apply$$anonfun$3$$anonfun$1(Request request$8, String requestId$8, Throwable error$1, LazyRef requestProperties$lzy1$7) {
        return this.createErrorResponse(error$1, request$8, requestId$8, (Function0<Map<String, String>>)((Function0 & Serializable)() -> this.apply$$anonfun$3$$anonfun$1$$anonfun$1(request$8, requestId$8, requestProperties$lzy1$7)));
    }

    private static final Status $anonfun$7(Status status$1) {
        return status$1;
    }

    private final ListMap responseProperties$lzyINIT1$1(Request request$10, String requestId$10, Status responseStatus$1, LazyRef responseProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = responseProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (responseProperties$lzy1$1.initialized()) {
                object = responseProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[3];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$10);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.client());
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.clientAddress(request$10));
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Status");
                objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)responseStatus$1.toString());
                object = responseProperties$lzy1$1.initialize((Object)((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private final ListMap responseProperties$1(Request request$11, String requestId$11, Status responseStatus$2, LazyRef responseProperties$lzy1$2) {
        return (ListMap)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : this.responseProperties$lzyINIT1$1(request$11, requestId$11, responseStatus$2, responseProperties$lzy1$2));
    }

    private final Map createResponse$$anonfun$1(Request request$15, String requestId$15, Status responseStatus$3, LazyRef responseProperties$lzy1$3) {
        return this.responseProperties$1(request$15, requestId$15, responseStatus$3, responseProperties$lzy1$3);
    }
}

