/*
 * Decompiled with CFR 0.152.
 */
package automorph.codec.json;

import automorph.codec.json.JacksonRpcProtocol$;
import automorph.protocol.jsonrpc.Message;
import automorph.protocol.jsonrpc.MessageError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

public final class JacksonJsonRpc$ {
    public static final JacksonJsonRpc$ MODULE$ = new JacksonJsonRpc$();

    public SimpleModule module() {
        Class<MessageError> rpcErrorClass = MessageError.class;
        Class<Message> rpcMessageClass = Message.class;
        return new SimpleModule().addSerializer(rpcErrorClass, JacksonRpcProtocol$.MODULE$.serializer(rpcErrorClass)).addDeserializer(rpcErrorClass, this.messageErrorDeserializer()).addSerializer(rpcMessageClass, this.messageSerializer()).addDeserializer(rpcMessageClass, this.messageDeserializer());
    }

    private StdDeserializer<MessageError<JsonNode>> messageErrorDeserializer() {
        return new StdDeserializer<MessageError<JsonNode>>(){

            public MessageError<JsonNode> deserialize(JsonParser parser, DeserializationContext context) {
                JsonNode jsonNode = context.readTree(parser);
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    return new MessageError(JacksonRpcProtocol$.MODULE$.field("message", (Function1 & Serializable)value -> Option$.MODULE$.when(value.isTextual(), (Function0 & Serializable)() -> value.asText()), objectNode, parser), JacksonRpcProtocol$.MODULE$.field("code", (Function1 & Serializable)value -> Option$.MODULE$.when(value.isInt(), (Function0)(JFunction0.mcI.sp & Serializable)() -> value.asInt()), objectNode, parser), JacksonRpcProtocol$.MODULE$.field("data", (Function1 & Serializable)x$1 -> new Some(x$1), objectNode, parser));
                }
                throw new JsonParseException(parser, "Invalid message error", parser.getCurrentLocation());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$deserialize$1(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$2(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$3(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$4(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$5(com.fasterxml.jackson.databind.JsonNode )}, serializedLambda);
            }
        };
    }

    private StdSerializer<Message<JsonNode>> messageSerializer() {
        return new StdSerializer<Message<JsonNode>>(){

            public void serialize(Message<JsonNode> value, JsonGenerator generator, SerializerProvider provider) {
                Map entries = value.productElementNames().zip((IterableOnce)value.productIterator()).flatMap((Function1 & Serializable)x0$1 -> {
                    Object object;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Some some;
                        Object object2;
                        String name = (String)tuple2._1();
                        Object object3 = tuple2._2();
                        if (object3 instanceof Some && (object2 = (some = (Some)object3).value()) instanceof Right) {
                            Right right = (Right)object2;
                            Object value = right.value();
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), value));
                        }
                    }
                    if (tuple2 != null) {
                        Some some;
                        Object object4;
                        String name = (String)tuple2._1();
                        Object object5 = tuple2._2();
                        if (object5 instanceof Some && (object4 = (some = (Some)object5).value()) instanceof Left) {
                            Left left = (Left)object4;
                            Object value = left.value();
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), value));
                        }
                    }
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Object object6 = tuple2._2();
                        if (object6 instanceof Some) {
                            Some some = (Some)object6;
                            Object value = some.value();
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), value));
                        }
                    }
                    if (tuple2 != null && None$.MODULE$.equals(object = tuple2._2())) {
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)tuple2);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                generator.writeObject((Object)entries);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$serialize$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    private StdDeserializer<Message<JsonNode>> messageDeserializer() {
        return new StdDeserializer<Message<JsonNode>>(){

            public Message<JsonNode> deserialize(JsonParser parser, DeserializationContext context) {
                JsonNode jsonNode = context.readTree(parser);
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    return new Message(JacksonRpcProtocol$.MODULE$.field("jsonrpc", (Function1 & Serializable)value -> Option$.MODULE$.when(value.isTextual(), (Function0 & Serializable)() -> value.asText()), objectNode, parser), JacksonRpcProtocol$.MODULE$.field("id", (Function1 & Serializable)x0$1 -> {
                        JsonNode jsonNode = x0$1;
                        if (jsonNode.isTextual()) {
                            return new Some((Object)package$.MODULE$.Right().apply((Object)jsonNode.asText()));
                        }
                        if (jsonNode.isNumber()) {
                            return new Some((Object)package$.MODULE$.Left().apply((Object)package$.MODULE$.BigDecimal().apply(jsonNode.asDouble())));
                        }
                        return None$.MODULE$;
                    }, objectNode, parser), JacksonRpcProtocol$.MODULE$.field("method", (Function1 & Serializable)value -> Option$.MODULE$.when(value.isTextual(), (Function0 & Serializable)() -> value.asText()), objectNode, parser), JacksonRpcProtocol$.MODULE$.field("params", (Function1 & Serializable)x0$2 -> {
                        JsonNode jsonNode = x0$2;
                        if (jsonNode.isObject()) {
                            Iterator params = CollectionConverters$.MODULE$.IteratorHasAsScala(((ObjectNode)jsonNode).fields()).asScala();
                            return new Some((Object)package$.MODULE$.Right().apply((Object)params.map((Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(field.getKey()), field.getValue())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                        }
                        if (jsonNode.isArray()) {
                            Iterator params = CollectionConverters$.MODULE$.IteratorHasAsScala(((ArrayNode)jsonNode).elements()).asScala();
                            return new Some((Object)package$.MODULE$.Left().apply((Object)params.toList()));
                        }
                        return None$.MODULE$;
                    }, objectNode, parser), JacksonRpcProtocol$.MODULE$.field("result", (Function1 & Serializable)x$2 -> new Some(x$2), objectNode, parser), JacksonRpcProtocol$.MODULE$.field("error", (Function1 & Serializable)value -> new Some(context.readValue(value.traverse(), MessageError.class)), objectNode, parser));
                }
                throw new JsonParseException(parser, "Invalid message", parser.getCurrentLocation());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$deserialize$10(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$11(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$12(java.util.Map$Entry ), $anonfun$deserialize$13(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$14(com.fasterxml.jackson.databind.DeserializationContext com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$6(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$7(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$8(com.fasterxml.jackson.databind.JsonNode ), $anonfun$deserialize$9(com.fasterxml.jackson.databind.JsonNode )}, serializedLambda);
            }
        };
    }

    private JacksonJsonRpc$() {
    }
}

