/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.http.client;

import automorph.log.LogProperties$;
import automorph.log.Logger;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.ClientTransport;
import automorph.spi.EffectSystem;
import automorph.transport.http.HttpContext;
import automorph.transport.http.HttpMethod;
import automorph.transport.http.Protocol;
import automorph.transport.http.client.SttpClient$;
import automorph.transport.http.client.SttpClient$TransportContext$;
import automorph.util.Extensions$;
import java.io.Serializable;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sttp.capabilities.package;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.client3.package$;
import sttp.model.Header$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.ws.WebSocket;

public final class SttpClient<Effect>
implements ClientTransport<Effect, HttpContext<TransportContext>>,
Logging,
Product,
Serializable {
    private Logger logger;
    private final EffectSystem effectSystem;
    private final SttpBackend backend;
    private final URI url;
    private final HttpMethod method;
    private final boolean webSocket;
    private final String webSocketsSchemePrefix;
    private final URI defaultUrl;
    private final MessageLog log;
    private final EffectSystem<Effect> system;

    public static <Effect> SttpClient<Effect> apply(EffectSystem<Effect> effectSystem, SttpBackend<Effect, package.WebSockets> sttpBackend, URI uRI, HttpMethod httpMethod) {
        return SttpClient$.MODULE$.apply(effectSystem, sttpBackend, uRI, httpMethod);
    }

    public static SttpClient<?> fromProduct(Product product) {
        return SttpClient$.MODULE$.fromProduct(product);
    }

    public static <Effect> SttpClient<Effect> http(EffectSystem<Effect> effectSystem, SttpBackend<Effect, ?> sttpBackend, URI uRI, HttpMethod httpMethod) {
        return SttpClient$.MODULE$.http(effectSystem, sttpBackend, uRI, httpMethod);
    }

    public static <Effect> SttpClient<Effect> unapply(SttpClient<Effect> sttpClient) {
        return SttpClient$.MODULE$.unapply(sttpClient);
    }

    public static <Effect> HttpMethod apply$default$4() {
        return SttpClient$.MODULE$.apply$default$4();
    }

    public static <Effect> HttpMethod http$default$4() {
        return SttpClient$.MODULE$.http$default$4();
    }

    public SttpClient(EffectSystem<Effect> effectSystem, SttpBackend<Effect, ?> backend, URI url, HttpMethod method, boolean webSocket) {
        this.effectSystem = effectSystem;
        this.backend = backend;
        this.url = url;
        this.method = method;
        this.webSocket = webSocket;
        Logging.$init$((Logging)this);
        this.webSocketsSchemePrefix = "ws";
        this.defaultUrl = Uri$.MODULE$.apply(url).toJavaUri();
        this.log = MessageLog$.MODULE$.apply(this.logger(), Protocol.Http$.MODULE$.name());
        this.system = effectSystem;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.effectSystem()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.backend()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.method()));
        n = Statics.mix((int)n, (int)(this.webSocket() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SttpClient)) return false;
        SttpClient sttpClient = (SttpClient)object;
        if (this.webSocket() != sttpClient.webSocket()) return false;
        EffectSystem<Effect> effectSystem = this.effectSystem();
        EffectSystem<Effect> effectSystem2 = sttpClient.effectSystem();
        if (effectSystem == null) {
            if (effectSystem2 != null) {
                return false;
            }
        } else if (!effectSystem.equals(effectSystem2)) return false;
        SttpBackend<Effect, ?> sttpBackend = this.backend();
        SttpBackend<Effect, ?> sttpBackend2 = sttpClient.backend();
        if (sttpBackend == null) {
            if (sttpBackend2 != null) {
                return false;
            }
        } else if (!sttpBackend.equals(sttpBackend2)) return false;
        URI uRI = this.url();
        URI uRI2 = sttpClient.url();
        if (uRI == null) {
            if (uRI2 != null) {
                return false;
            }
        } else if (!((Object)uRI).equals(uRI2)) return false;
        HttpMethod httpMethod = this.method();
        HttpMethod httpMethod2 = sttpClient.method();
        if (httpMethod == null) {
            if (httpMethod2 == null) return true;
            return false;
        } else {
            if (!httpMethod.equals(httpMethod2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SttpClient;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "SttpClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "effectSystem";
            }
            case 1: {
                return "backend";
            }
            case 2: {
                return "url";
            }
            case 3: {
                return "method";
            }
            case 4: {
                return "webSocket";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public EffectSystem<Effect> effectSystem() {
        return this.effectSystem;
    }

    public SttpBackend<Effect, ?> backend() {
        return this.backend;
    }

    public URI url() {
        return this.url;
    }

    public HttpMethod method() {
        return this.method;
    }

    public boolean webSocket() {
        return this.webSocket;
    }

    public Effect call(byte[] requestBody, HttpContext<TransportContext> requestContext, String requestId, String mediaType) {
        RequestT<Object, byte[], package.Effect<Effect>> sttpRequest = this.createRequest(requestBody, mediaType, requestContext);
        return (Effect)Extensions$.MODULE$.EffectOps(this.transportProtocol(sttpRequest)).flatMap((Function1 & Serializable)protocol -> Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(this.send((RequestT)sttpRequest, requestId, (Protocol)protocol)).either(this.system)).flatMap((Function1 & Serializable)result -> {
            LazyRef lazyRef = new LazyRef();
            return result.fold((Function1 & Serializable)error -> {
                this.log.failedReceiveResponse(error, () -> SttpClient.call$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(requestId, sttpRequest, lazyRef), protocol.name());
                return this.effectSystem().failed(error);
            }, (Function1 & Serializable)response -> {
                this.log.receivedResponse(() -> SttpClient.call$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(requestId, sttpRequest, response, lazyRef), protocol.name());
                byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc(response.body());
                return this.effectSystem().successful((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, this.getResponseContext((Response<byte[]>)response)));
            });
        }, this.system), this.system);
    }

    public Effect tell(byte[] requestBody, HttpContext<TransportContext> requestContext, String requestId, String mediaType) {
        RequestT<Object, byte[], package.Effect<Effect>> sttpRequest = this.createRequest(requestBody, mediaType, requestContext);
        return (Effect)Extensions$.MODULE$.EffectOps(this.transportProtocol(sttpRequest)).flatMap((Function1 & Serializable)x$1 -> {
            Protocol protocol = x$1;
            if (Protocol.Http$.MODULE$.equals(protocol)) {
                return Extensions$.MODULE$.EffectOps(this.send(sttpRequest.response(package$.MODULE$.ignore()), requestId, (Protocol)Protocol.Http$.MODULE$)).map((Function1)(JProcedure1 & Serializable)_$2 -> {}, this.system);
            }
            if (Protocol.WebSocket$.MODULE$.equals(protocol)) {
                return Extensions$.MODULE$.EffectOps(this.send(sttpRequest, requestId, (Protocol)Protocol.WebSocket$.MODULE$)).map((Function1)(JProcedure1 & Serializable)_$3 -> {}, this.system);
            }
            throw new MatchError((Object)protocol);
        }, this.system);
    }

    public HttpContext<TransportContext> context() {
        return SttpClient$TransportContext$.MODULE$.defaultContext().url(this.url()).method(this.method());
    }

    public Effect init() {
        return (Effect)this.effectSystem().successful((Object)BoxedUnit.UNIT);
    }

    public Effect close() {
        return (Effect)this.effectSystem().successful((Object)BoxedUnit.UNIT);
    }

    private <R> Effect send(RequestT<Object, R, package.Effect<Effect>> sttpRequest, String requestId, Protocol protocol) {
        LazyRef lazyRef = new LazyRef();
        this.log.sendingRequest(() -> SttpClient.send$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
        Object response = sttpRequest.send(this.backend(), $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Effect)Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(response).either(this.system)).flatMap((Function1 & Serializable)_$4 -> _$4.fold((Function1 & Serializable)error -> {
            this.log.failedSendRequest(error, () -> SttpClient.send$$anonfun$2$$anonfun$1$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
            return this.effectSystem().failed(error);
        }, (Function1 & Serializable)response -> {
            this.log.sentRequest(() -> SttpClient.send$$anonfun$2$$anonfun$2$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
            return this.effectSystem().successful(response);
        }), this.system);
    }

    private RequestT<Object, byte[], package.Effect<Effect>> createRequest(byte[] requestBody, String mediaType, HttpContext<TransportContext> requestContext) {
        RequestT transportRequest = (RequestT)requestContext.transportContext().map((Function1 & Serializable)_$5 -> _$5.request()).getOrElse(SttpClient::$anonfun$2);
        Uri requestUrl = Uri$.MODULE$.apply(requestContext.overrideUrl(this.defaultUrl));
        String requestMethod = Method$.MODULE$.unsafeApply(((HttpMethod)requestContext.method().getOrElse(this::$anonfun$3)).name());
        MediaType contentType = MediaType$.MODULE$.unsafeParse(mediaType);
        RequestT requestT = transportRequest.method(requestMethod, requestUrl).headers((Seq)requestContext.headers().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Header$.MODULE$.apply(name, value);
            }
            throw new MatchError((Object)tuple2);
        })).contentType(contentType);
        RequestT sttpRequest = requestT.header(Header$.MODULE$.accept(contentType, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MediaType[0])), requestT.header$default$2()).readTimeout((Duration)requestContext.timeout().getOrElse(() -> SttpClient.$anonfun$5(transportRequest))).followRedirects(BoxesRunTime.unboxToBoolean((Object)requestContext.followRedirects().getOrElse(() -> SttpClient.$anonfun$6(transportRequest)))).maxRedirects(transportRequest.options().maxRedirects());
        String string = requestUrl.toString().toLowerCase();
        String scheme = string;
        if (scheme.startsWith(this.webSocketsSchemePrefix)) {
            return sttpRequest.response(package$.MODULE$.asWebSocketAlways(this.sendWebSocket(requestBody)));
        }
        return sttpRequest.body(requestBody).response(package$.MODULE$.asByteArrayAlways());
    }

    private Function1<WebSocket<Effect>, Effect> sendWebSocket(byte[] request) {
        return (Function1 & Serializable)webSocket -> Extensions$.MODULE$.EffectOps(webSocket.sendBinary(request)).flatMap((Function1 & Serializable)_$6 -> webSocket.receiveBinary(true), this.system);
    }

    private HttpContext<TransportContext> getResponseContext(Response<byte[]> response) {
        return this.context().statusCode(response.code()).headers((Seq)response.headers().map((Function1 & Serializable)header -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)header.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)header.value());
        }));
    }

    private Effect transportProtocol(RequestT<Object, byte[], package.Effect<Effect>> sttpRequest) {
        if (sttpRequest.isWebSocket()) {
            if (this.webSocket()) {
                return (Effect)this.effectSystem().successful((Object)Protocol.WebSocket$.MODULE$);
            }
            EffectSystem<Effect> effectSystem = this.effectSystem();
            throw new IllegalArgumentException("Selected STTP backend does not support WebSocket: " + this.backend().getClass().getSimpleName());
        }
        return (Effect)this.effectSystem().successful((Object)Protocol.Http$.MODULE$);
    }

    private <Effect> SttpClient<Effect> copy(EffectSystem<Effect> effectSystem, SttpBackend<Effect, ?> backend, URI url, HttpMethod method, boolean webSocket) {
        return new SttpClient<Effect>(effectSystem, backend, url, method, webSocket);
    }

    private <Effect> EffectSystem<Effect> copy$default$1() {
        return this.effectSystem();
    }

    private <Effect> SttpBackend<Effect, ?> copy$default$2() {
        return this.backend();
    }

    private <Effect> URI copy$default$3() {
        return this.url();
    }

    private <Effect> HttpMethod copy$default$4() {
        return this.method();
    }

    private boolean copy$default$5() {
        return this.webSocket();
    }

    public EffectSystem<Effect> _1() {
        return this.effectSystem();
    }

    public SttpBackend<Effect, ?> _2() {
        return this.backend();
    }

    public URI _3() {
        return this.url();
    }

    public HttpMethod _4() {
        return this.method();
    }

    public boolean _5() {
        return this.webSocket();
    }

    private static final ListMap responseProperties$lzyINIT1$1(String requestId$2, RequestT sttpRequest$2, LazyRef responseProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = responseProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (responseProperties$lzy1$1.initialized()) {
                object = responseProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$2);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((Uri)sttpRequest$2.uri()).toString());
                object = responseProperties$lzy1$1.initialize((Object)((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private static final ListMap responseProperties$1(String requestId$4, RequestT sttpRequest$4, LazyRef responseProperties$lzy1$2) {
        return (ListMap)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : SttpClient.responseProperties$lzyINIT1$1(requestId$4, sttpRequest$4, responseProperties$lzy1$2));
    }

    private static final Map call$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String requestId$14, RequestT sttpRequest$15, LazyRef responseProperties$lzy1$6) {
        return SttpClient.responseProperties$1(requestId$14, sttpRequest$15, responseProperties$lzy1$6);
    }

    private static final Map call$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(String requestId$6, RequestT sttpRequest$6, Response response$1, LazyRef responseProperties$lzy1$4) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Status");
        return (Map)SttpClient.responseProperties$1(requestId$6, sttpRequest$6, responseProperties$lzy1$4).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)StatusCode$.MODULE$.toString$extension(response$1.code())));
    }

    private static final Tuple2 requestProperties$lzyINIT1$1$$anonfun$1(RequestT sttpRequest$10) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Method");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Method$.MODULE$.toString$extension(sttpRequest$10.method() == null ? null : ((Method)sttpRequest$10.method()).method()));
    }

    private static final ListMap requestProperties$lzyINIT1$1(RequestT sttpRequest$9, String requestId$9, Protocol protocol$4, LazyRef requestProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = requestProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (requestProperties$lzy1$1.initialized()) {
                object = requestProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$9);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((Uri)sttpRequest$9.uri()).toString());
                Protocol protocol = protocol$4;
                Protocol.Http$ http$ = Protocol.Http$.MODULE$;
                object = requestProperties$lzy1$1.initialize((Object)((ListMap)((MapOps)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)Option$.MODULE$.when(!(protocol != null ? !protocol.equals(http$) : http$ != null), () -> SttpClient.requestProperties$lzyINIT1$1$$anonfun$1(sttpRequest$9)))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private static final ListMap requestProperties$1(RequestT sttpRequest$11, String requestId$10, Protocol protocol$5, LazyRef requestProperties$lzy1$2) {
        return (ListMap)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : SttpClient.requestProperties$lzyINIT1$1(sttpRequest$11, requestId$10, protocol$5, requestProperties$lzy1$2));
    }

    private static final Map send$$anonfun$1(RequestT sttpRequest$16, String requestId$15, Protocol protocol$9, LazyRef requestProperties$lzy1$6) {
        return SttpClient.requestProperties$1(sttpRequest$16, requestId$15, protocol$9, requestProperties$lzy1$6);
    }

    private static final Map send$$anonfun$2$$anonfun$1$$anonfun$1(RequestT sttpRequest$17, String requestId$16, Protocol protocol$10, LazyRef requestProperties$lzy1$7) {
        return SttpClient.requestProperties$1(sttpRequest$17, requestId$16, protocol$10, requestProperties$lzy1$7);
    }

    private static final Map send$$anonfun$2$$anonfun$2$$anonfun$1(RequestT sttpRequest$18, String requestId$17, Protocol protocol$11, LazyRef requestProperties$lzy1$8) {
        return SttpClient.requestProperties$1(sttpRequest$18, requestId$17, protocol$11, requestProperties$lzy1$8);
    }

    private static final RequestT $anonfun$2() {
        return package$.MODULE$.basicRequest();
    }

    private final HttpMethod $anonfun$3() {
        return this.method();
    }

    private static final Duration $anonfun$5(RequestT transportRequest$1) {
        return transportRequest$1.options().readTimeout();
    }

    private static final boolean $anonfun$6(RequestT transportRequest$2) {
        return transportRequest$2.options().followRedirects();
    }

    public static final class TransportContext
    implements Product,
    Serializable {
        private final RequestT request;

        public static TransportContext apply(RequestT<None$, Either<String, String>, Object> requestT) {
            return SttpClient$TransportContext$.MODULE$.apply(requestT);
        }

        public static HttpContext<TransportContext> defaultContext() {
            return SttpClient$TransportContext$.MODULE$.defaultContext();
        }

        public static TransportContext fromProduct(Product product) {
            return SttpClient$TransportContext$.MODULE$.fromProduct(product);
        }

        public static TransportContext unapply(TransportContext transportContext) {
            return SttpClient$TransportContext$.MODULE$.unapply(transportContext);
        }

        public TransportContext(RequestT<None$, Either<String, String>, Object> request) {
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TransportContext)) return false;
            TransportContext transportContext = (TransportContext)object;
            RequestT<None$, Either<String, String>, Object> requestT = this.request();
            RequestT<None$, Either<String, String>, Object> requestT2 = transportContext.request();
            if (requestT != null) {
                if (!requestT.equals(requestT2)) return false;
                return true;
            }
            if (requestT2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TransportContext;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TransportContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RequestT<None$, Either<String, String>, Object> request() {
            return this.request;
        }

        public TransportContext copy(RequestT<None$, Either<String, String>, Object> request) {
            return new TransportContext(request);
        }

        public RequestT<None$, Either<String, String>, Object> copy$default$1() {
            return this.request();
        }

        public RequestT<None$, Either<String, String>, Object> _1() {
            return this.request();
        }
    }
}

