/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.http.client;

import automorph.log.LogProperties$;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.ClientTransport;
import automorph.spi.EffectSystem;
import automorph.transport.http.HttpContext;
import automorph.transport.http.HttpMethod;
import automorph.transport.http.Protocol;
import automorph.transport.http.client.SttpClient;
import automorph.transport.http.client.SttpClient$TransportContext$;
import automorph.util.Extensions$;
import java.io.Serializable;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sttp.capabilities.package;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.client3.package$;
import sttp.model.Header$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.ws.WebSocket;

public interface SttpClientBase<Effect>
extends ClientTransport<Effect, HttpContext<SttpClient.TransportContext>>,
Logging {
    public static void $init$(SttpClientBase $this) {
        $this.automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$webSocketsSchemePrefix_$eq("ws");
        $this.automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$defaultUrl_$eq(Uri$.MODULE$.apply($this.url()).toJavaUri());
        $this.automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$log_$eq(MessageLog$.MODULE$.apply($this.logger(), Protocol.Http$.MODULE$.name()));
        $this.automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$system_$eq($this.effectSystem());
    }

    public String automorph$transport$http$client$SttpClientBase$$webSocketsSchemePrefix();

    public void automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$webSocketsSchemePrefix_$eq(String var1);

    public URI automorph$transport$http$client$SttpClientBase$$defaultUrl();

    public void automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$defaultUrl_$eq(URI var1);

    public MessageLog automorph$transport$http$client$SttpClientBase$$log();

    public void automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$log_$eq(MessageLog var1);

    public EffectSystem<Effect> automorph$transport$http$client$SttpClientBase$$system();

    public void automorph$transport$http$client$SttpClientBase$_setter_$automorph$transport$http$client$SttpClientBase$$system_$eq(EffectSystem var1);

    public URI url();

    public SttpBackend<Effect, ?> backend();

    public HttpMethod method();

    public boolean webSocket();

    public static Object call$(SttpClientBase $this, byte[] requestBody, HttpContext requestContext, String requestId, String mediaType) {
        return $this.call(requestBody, (HttpContext<SttpClient.TransportContext>)requestContext, requestId, mediaType);
    }

    default public Effect call(byte[] requestBody, HttpContext<SttpClient.TransportContext> requestContext, String requestId, String mediaType) {
        RequestT<Object, byte[], package.Effect<Effect>> sttpRequest = this.createRequest(requestBody, mediaType, requestContext);
        return (Effect)Extensions$.MODULE$.EffectOps(this.transportProtocol(sttpRequest)).flatMap((Function1 & Serializable)protocol -> Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(this.send((RequestT)sttpRequest, requestId, (Protocol)protocol)).either(this.automorph$transport$http$client$SttpClientBase$$system())).flatMap((Function1 & Serializable)result -> {
            LazyRef lazyRef = new LazyRef();
            return result.fold((Function1 & Serializable)error -> {
                this.automorph$transport$http$client$SttpClientBase$$log().failedReceiveResponse(error, () -> SttpClientBase.call$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(requestId, sttpRequest, lazyRef), protocol.name());
                return this.effectSystem().failed(error);
            }, (Function1 & Serializable)response -> {
                this.automorph$transport$http$client$SttpClientBase$$log().receivedResponse(() -> SttpClientBase.call$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(requestId, sttpRequest, response, lazyRef), protocol.name());
                byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc(response.body());
                return this.effectSystem().successful((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, this.getResponseContext((Response<byte[]>)response)));
            });
        }, this.automorph$transport$http$client$SttpClientBase$$system()), this.automorph$transport$http$client$SttpClientBase$$system());
    }

    public static Object tell$(SttpClientBase $this, byte[] requestBody, HttpContext requestContext, String requestId, String mediaType) {
        return $this.tell(requestBody, (HttpContext<SttpClient.TransportContext>)requestContext, requestId, mediaType);
    }

    default public Effect tell(byte[] requestBody, HttpContext<SttpClient.TransportContext> requestContext, String requestId, String mediaType) {
        RequestT<Object, byte[], package.Effect<Effect>> sttpRequest = this.createRequest(requestBody, mediaType, requestContext);
        return (Effect)Extensions$.MODULE$.EffectOps(this.transportProtocol(sttpRequest)).flatMap((Function1 & Serializable)x$1 -> {
            Protocol protocol = x$1;
            if (Protocol.Http$.MODULE$.equals(protocol)) {
                return Extensions$.MODULE$.EffectOps(this.send(sttpRequest.response(package$.MODULE$.ignore()), requestId, (Protocol)Protocol.Http$.MODULE$)).map((Function1)(JProcedure1 & Serializable)_$2 -> {}, this.automorph$transport$http$client$SttpClientBase$$system());
            }
            if (Protocol.WebSocket$.MODULE$.equals(protocol)) {
                return Extensions$.MODULE$.EffectOps(this.send(sttpRequest, requestId, (Protocol)Protocol.WebSocket$.MODULE$)).map((Function1)(JProcedure1 & Serializable)_$3 -> {}, this.automorph$transport$http$client$SttpClientBase$$system());
            }
            throw new MatchError((Object)protocol);
        }, this.automorph$transport$http$client$SttpClientBase$$system());
    }

    public static HttpContext context$(SttpClientBase $this) {
        return $this.context();
    }

    default public HttpContext<SttpClient.TransportContext> context() {
        return SttpClient$TransportContext$.MODULE$.defaultContext().url(this.url()).method(this.method());
    }

    public static Object init$(SttpClientBase $this) {
        return $this.init();
    }

    default public Effect init() {
        return (Effect)this.effectSystem().successful((Object)BoxedUnit.UNIT);
    }

    public static Object close$(SttpClientBase $this) {
        return $this.close();
    }

    default public Effect close() {
        return (Effect)this.effectSystem().successful((Object)BoxedUnit.UNIT);
    }

    private <R> Effect send(RequestT<Object, R, package.Effect<Effect>> sttpRequest, String requestId, Protocol protocol) {
        LazyRef lazyRef = new LazyRef();
        this.automorph$transport$http$client$SttpClientBase$$log().sendingRequest(() -> SttpClientBase.send$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
        Object response = sttpRequest.send(this.backend(), $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Effect)Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(response).either(this.automorph$transport$http$client$SttpClientBase$$system())).flatMap((Function1 & Serializable)_$4 -> _$4.fold((Function1 & Serializable)error -> {
            this.automorph$transport$http$client$SttpClientBase$$log().failedSendRequest(error, () -> SttpClientBase.send$$anonfun$2$$anonfun$1$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
            return this.effectSystem().failed(error);
        }, (Function1 & Serializable)response -> {
            this.automorph$transport$http$client$SttpClientBase$$log().sentRequest(() -> SttpClientBase.send$$anonfun$2$$anonfun$2$$anonfun$1(sttpRequest, requestId, protocol, lazyRef), protocol.name());
            return this.effectSystem().successful(response);
        }), this.automorph$transport$http$client$SttpClientBase$$system());
    }

    private RequestT<Object, byte[], package.Effect<Effect>> createRequest(byte[] requestBody, String mediaType, HttpContext<SttpClient.TransportContext> requestContext) {
        RequestT transportRequest = (RequestT)requestContext.transportContext().map((Function1 & Serializable)_$5 -> _$5.request()).getOrElse(SttpClientBase::$anonfun$2);
        Uri requestUrl = Uri$.MODULE$.apply(requestContext.overrideUrl(this.automorph$transport$http$client$SttpClientBase$$defaultUrl()));
        String requestMethod = Method$.MODULE$.unsafeApply(((HttpMethod)requestContext.method().getOrElse(this::$anonfun$3)).name());
        MediaType contentType = MediaType$.MODULE$.unsafeParse(mediaType);
        RequestT requestT = transportRequest.method(requestMethod, requestUrl).headers((Seq)requestContext.headers().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Header$.MODULE$.apply(name, value);
            }
            throw new MatchError((Object)tuple2);
        })).contentType(contentType);
        RequestT sttpRequest = requestT.header(Header$.MODULE$.accept(contentType, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MediaType[0])), requestT.header$default$2()).readTimeout((Duration)requestContext.timeout().getOrElse(() -> SttpClientBase.$anonfun$5(transportRequest))).followRedirects(BoxesRunTime.unboxToBoolean((Object)requestContext.followRedirects().getOrElse(() -> SttpClientBase.$anonfun$6(transportRequest)))).maxRedirects(transportRequest.options().maxRedirects());
        String string = requestUrl.toString().toLowerCase();
        String scheme = string;
        if (scheme.startsWith(this.automorph$transport$http$client$SttpClientBase$$webSocketsSchemePrefix())) {
            return sttpRequest.response(package$.MODULE$.asWebSocketAlways(this.sendWebSocket(requestBody)));
        }
        return sttpRequest.body(requestBody).response(package$.MODULE$.asByteArrayAlways());
    }

    private Function1<WebSocket<Effect>, Effect> sendWebSocket(byte[] request) {
        return (Function1 & Serializable)webSocket -> Extensions$.MODULE$.EffectOps(webSocket.sendBinary(request)).flatMap((Function1 & Serializable)_$6 -> webSocket.receiveBinary(true), this.automorph$transport$http$client$SttpClientBase$$system());
    }

    private HttpContext<SttpClient.TransportContext> getResponseContext(Response<byte[]> response) {
        return this.context().statusCode(response.code()).headers((Seq)response.headers().map((Function1 & Serializable)header -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)header.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)header.value());
        }));
    }

    private Effect transportProtocol(RequestT<Object, byte[], package.Effect<Effect>> sttpRequest) {
        if (sttpRequest.isWebSocket()) {
            if (this.webSocket()) {
                return (Effect)this.effectSystem().successful((Object)Protocol.WebSocket$.MODULE$);
            }
            EffectSystem effectSystem = this.effectSystem();
            throw new IllegalArgumentException("Selected STTP backend does not support WebSocket: " + this.backend().getClass().getSimpleName());
        }
        return (Effect)this.effectSystem().successful((Object)Protocol.Http$.MODULE$);
    }

    private static ListMap responseProperties$lzyINIT1$1(String requestId$2, RequestT sttpRequest$2, LazyRef responseProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = responseProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (responseProperties$lzy1$1.initialized()) {
                object = responseProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$2);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((Uri)sttpRequest$2.uri()).toString());
                object = responseProperties$lzy1$1.initialize((Object)((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private static ListMap responseProperties$1(String requestId$4, RequestT sttpRequest$4, LazyRef responseProperties$lzy1$2) {
        return (ListMap)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : SttpClientBase.responseProperties$lzyINIT1$1(requestId$4, sttpRequest$4, responseProperties$lzy1$2));
    }

    private static Map call$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String requestId$14, RequestT sttpRequest$15, LazyRef responseProperties$lzy1$6) {
        return SttpClientBase.responseProperties$1(requestId$14, sttpRequest$15, responseProperties$lzy1$6);
    }

    private static Map call$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(String requestId$6, RequestT sttpRequest$6, Response response$1, LazyRef responseProperties$lzy1$4) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Status");
        return (Map)SttpClientBase.responseProperties$1(requestId$6, sttpRequest$6, responseProperties$lzy1$4).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)StatusCode$.MODULE$.toString$extension(response$1.code())));
    }

    private static Tuple2 requestProperties$lzyINIT1$1$$anonfun$1(RequestT sttpRequest$10) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Method");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Method$.MODULE$.toString$extension(sttpRequest$10.method() == null ? null : ((Method)sttpRequest$10.method()).method()));
    }

    private static ListMap requestProperties$lzyINIT1$1(RequestT sttpRequest$9, String requestId$9, Protocol protocol$4, LazyRef requestProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = requestProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (requestProperties$lzy1$1.initialized()) {
                object = requestProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$9);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((Uri)sttpRequest$9.uri()).toString());
                Protocol protocol = protocol$4;
                Protocol.Http$ http$ = Protocol.Http$.MODULE$;
                object = requestProperties$lzy1$1.initialize((Object)((ListMap)((MapOps)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)Option$.MODULE$.when(!(protocol != null ? !protocol.equals(http$) : http$ != null), () -> SttpClientBase.requestProperties$lzyINIT1$1$$anonfun$1(sttpRequest$9)))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private static ListMap requestProperties$1(RequestT sttpRequest$11, String requestId$10, Protocol protocol$5, LazyRef requestProperties$lzy1$2) {
        return (ListMap)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : SttpClientBase.requestProperties$lzyINIT1$1(sttpRequest$11, requestId$10, protocol$5, requestProperties$lzy1$2));
    }

    private static Map send$$anonfun$1(RequestT sttpRequest$16, String requestId$15, Protocol protocol$9, LazyRef requestProperties$lzy1$6) {
        return SttpClientBase.requestProperties$1(sttpRequest$16, requestId$15, protocol$9, requestProperties$lzy1$6);
    }

    private static Map send$$anonfun$2$$anonfun$1$$anonfun$1(RequestT sttpRequest$17, String requestId$16, Protocol protocol$10, LazyRef requestProperties$lzy1$7) {
        return SttpClientBase.requestProperties$1(sttpRequest$17, requestId$16, protocol$10, requestProperties$lzy1$7);
    }

    private static Map send$$anonfun$2$$anonfun$2$$anonfun$1(RequestT sttpRequest$18, String requestId$17, Protocol protocol$11, LazyRef requestProperties$lzy1$8) {
        return SttpClientBase.requestProperties$1(sttpRequest$18, requestId$17, protocol$11, requestProperties$lzy1$8);
    }

    private static RequestT $anonfun$2() {
        return package$.MODULE$.basicRequest();
    }

    private HttpMethod $anonfun$3() {
        return this.method();
    }

    private static Duration $anonfun$5(RequestT transportRequest$1) {
        return transportRequest$1.options().readTimeout();
    }

    private static boolean $anonfun$6(RequestT transportRequest$2) {
        return transportRequest$2.options().followRedirects();
    }
}

