/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.http.endpoint;

import automorph.log.LogProperties$;
import automorph.log.Logger;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.EffectSystem;
import automorph.spi.EndpointTransport;
import automorph.spi.RequestHandler;
import automorph.transport.http.HttpContext;
import automorph.transport.http.HttpMethod;
import automorph.transport.http.Protocol;
import automorph.transport.http.endpoint.TapirHttpEndpoint$;
import automorph.transport.http.endpoint.TapirHttpEndpoint$MessageFormat$;
import automorph.util.Extensions$;
import automorph.util.Random$;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;
import sttp.model.Header;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.QueryParams;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.tapir.Codec;
import sttp.tapir.Codec$;
import sttp.tapir.CodecFormat;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointInputsOps;
import sttp.tapir.EndpointOutput;
import sttp.tapir.EndpointOutputsOps;
import sttp.tapir.RawBodyType;
import sttp.tapir.Schema$;
import sttp.tapir.package$;
import sttp.tapir.server.ServerEndpoint;
import sttp.tapir.typelevel.ParamConcat$;
import sttp.tapir.typelevel.TupleArity$;
import sttp.tapir.typelevel.TupleOps;

public final class TapirHttpEndpoint<Effect>
implements Logging,
EndpointTransport<Effect, HttpContext<BoxedUnit>, ServerEndpoint>,
Product,
Serializable {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(TapirHttpEndpoint.class.getDeclaredField("body$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(TapirHttpEndpoint.class.getDeclaredField("codec$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TapirHttpEndpoint.class.getDeclaredField("mediaType$lzy1"));
    private Logger logger;
    private final EffectSystem effectSystem;
    private final String pathPrefix;
    private final Option method;
    private final Function1 mapException;
    private final RequestHandler handler;
    private final Option<String> allowedMethod;
    private final List<String> prefixPaths;
    private volatile Object mediaType$lzy1;
    private volatile Object codec$lzy1;
    private volatile Object body$lzy1;
    private final MessageLog log;
    private final EffectSystem<Effect> system;

    public static <Effect> TapirHttpEndpoint<Effect> apply(EffectSystem<Effect> effectSystem, String string, Option<HttpMethod> option, Function1<Throwable, Object> function1, RequestHandler<Effect, HttpContext<BoxedUnit>> requestHandler) {
        return TapirHttpEndpoint$.MODULE$.apply(effectSystem, string, option, function1, requestHandler);
    }

    public static String clientAddress(Option<String> option) {
        return TapirHttpEndpoint$.MODULE$.clientAddress(option);
    }

    public static Mirror.Singleton fromProduct(Product product) {
        return TapirHttpEndpoint$.MODULE$.fromProduct(product);
    }

    public static HttpContext<BoxedUnit> getRequestContext(List<String> list, QueryParams queryParams, List<Header> list2, Option<String> option) {
        return TapirHttpEndpoint$.MODULE$.getRequestContext(list, queryParams, list2, option);
    }

    public static Map<String, String> getRequestProperties(Option<String> option, Option<String> option2, String string) {
        return TapirHttpEndpoint$.MODULE$.getRequestProperties(option, option2, string);
    }

    public static List<String> pathComponents(String string) {
        return TapirHttpEndpoint$.MODULE$.pathComponents(string);
    }

    public static Option<EndpointInput<BoxedUnit>> pathEndpointInput(List<String> list) {
        return TapirHttpEndpoint$.MODULE$.pathEndpointInput(list);
    }

    public static <Effect> TapirHttpEndpoint<Effect> unapply(TapirHttpEndpoint<Effect> tapirHttpEndpoint) {
        return TapirHttpEndpoint$.MODULE$.unapply(tapirHttpEndpoint);
    }

    public static <Effect> String $lessinit$greater$default$2() {
        return TapirHttpEndpoint$.MODULE$.$lessinit$greater$default$2();
    }

    public static <Effect> Option<HttpMethod> $lessinit$greater$default$3() {
        return TapirHttpEndpoint$.MODULE$.$lessinit$greater$default$3();
    }

    public static <Effect> Function1<Throwable, Object> $lessinit$greater$default$4() {
        return TapirHttpEndpoint$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Effect> RequestHandler<Effect, HttpContext<BoxedUnit>> $lessinit$greater$default$5() {
        return TapirHttpEndpoint$.MODULE$.$lessinit$greater$default$5();
    }

    public TapirHttpEndpoint(EffectSystem<Effect> effectSystem, String pathPrefix, Option<HttpMethod> method, Function1<Throwable, Object> mapException, RequestHandler<Effect, HttpContext<BoxedUnit>> handler) {
        this.effectSystem = effectSystem;
        this.pathPrefix = pathPrefix;
        this.method = method;
        this.mapException = mapException;
        this.handler = handler;
        Logging.$init$((Logging)this);
        this.allowedMethod = method.map((Function1 & Serializable)httpMethod -> new Method(Method$.MODULE$.apply(httpMethod.name())));
        this.prefixPaths = TapirHttpEndpoint$.MODULE$.pathComponents(pathPrefix);
        this.log = MessageLog$.MODULE$.apply(this.logger(), Protocol.Http$.MODULE$.name());
        this.system = effectSystem;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TapirHttpEndpoint)) return false;
        TapirHttpEndpoint tapirHttpEndpoint = (TapirHttpEndpoint)object;
        EffectSystem<Effect> effectSystem = this.effectSystem();
        EffectSystem<Effect> effectSystem2 = tapirHttpEndpoint.effectSystem();
        if (effectSystem == null) {
            if (effectSystem2 != null) {
                return false;
            }
        } else if (!effectSystem.equals(effectSystem2)) return false;
        String string = this.pathPrefix();
        String string2 = tapirHttpEndpoint.pathPrefix();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<HttpMethod> option = this.method();
        Option<HttpMethod> option2 = tapirHttpEndpoint.method();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Function1<Throwable, Object> function1 = this.mapException();
        Function1<Throwable, Object> function12 = tapirHttpEndpoint.mapException();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        RequestHandler<Effect, HttpContext<BoxedUnit>> requestHandler = this.handler();
        RequestHandler<Effect, HttpContext<BoxedUnit>> requestHandler2 = tapirHttpEndpoint.handler();
        if (requestHandler == null) {
            if (requestHandler2 == null) return true;
            return false;
        } else {
            if (!requestHandler.equals(requestHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TapirHttpEndpoint;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "TapirHttpEndpoint";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "effectSystem";
            }
            case 1: {
                return "pathPrefix";
            }
            case 2: {
                return "method";
            }
            case 3: {
                return "mapException";
            }
            case 4: {
                return "handler";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public EffectSystem<Effect> effectSystem() {
        return this.effectSystem;
    }

    public String pathPrefix() {
        return this.pathPrefix;
    }

    public Option<HttpMethod> method() {
        return this.method;
    }

    public Function1<Throwable, Object> mapException() {
        return this.mapException;
    }

    public RequestHandler<Effect, HttpContext<BoxedUnit>> handler() {
        return this.handler;
    }

    private MediaType mediaType() {
        Object object = this.mediaType$lzy1;
        if (object instanceof MediaType) {
            return (MediaType)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MediaType)this.mediaType$lzyINIT1();
    }

    private Object mediaType$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.mediaType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MediaType mediaType = null;
                    try {
                        mediaType = (MediaType)MediaType$.MODULE$.parse(this.handler().mediaType()).fold((Function1 & Serializable)error -> {
                            throw new IllegalStateException("Invalid message content type: " + this.handler().mediaType(), new IllegalArgumentException((String)error));
                        }, (Function1 & Serializable)x -> (MediaType)Predef$.MODULE$.identity(x));
                        object2 = mediaType == null ? LazyVals.NullValue$.MODULE$ : mediaType;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.mediaType$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mediaType;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Codec<byte[], byte[], MessageFormat> codec() {
        Object object = this.codec$lzy1;
        if (object instanceof Codec) {
            return (Codec)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Codec)this.codec$lzyINIT1();
    }

    private Object codec$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codec$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Codec codec = null;
                    try {
                        codec = Codec$.MODULE$.id((CodecFormat)TapirHttpEndpoint$MessageFormat$.MODULE$.apply(this.mediaType()), Schema$.MODULE$.schemaForByteArray());
                        object2 = codec == null ? LazyVals.NullValue$.MODULE$ : codec;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codec$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return codec;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private EndpointIO.Body<byte[], byte[]> body() {
        Object object = this.body$lzy1;
        if (object instanceof EndpointIO.Body) {
            return (EndpointIO.Body)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (EndpointIO.Body)this.body$lzyINIT1();
    }

    private Object body$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.body$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    EndpointIO.Body body = null;
                    try {
                        body = EndpointIO.Body$.MODULE$.apply((RawBodyType)RawBodyType.ByteArrayBody$.MODULE$, this.codec(), EndpointIO.Info$.MODULE$.empty());
                        object2 = body == null ? LazyVals.NullValue$.MODULE$ : body;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.body$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return body;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ServerEndpoint adapter() {
        Endpoint endpointMethod = (Endpoint)this.allowedMethod.map((Function1 & Serializable)m -> TapirHttpEndpoint.$anonfun$1(m == null ? null : ((Method)m).method())).getOrElse(TapirHttpEndpoint::$anonfun$2);
        Endpoint endpointPath = (Endpoint)TapirHttpEndpoint$.MODULE$.pathEndpointInput(this.prefixPaths).map((Function1 & Serializable)path -> (Endpoint)endpointMethod.in(path, ParamConcat$.MODULE$.concatUnitUnit())).getOrElse(() -> TapirHttpEndpoint.$anonfun$4(endpointMethod));
        Endpoint endpointInput = (Endpoint)((EndpointInputsOps)((EndpointInputsOps)((EndpointInputsOps)endpointPath.in(this.body(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).in((EndpointInput)package$.MODULE$.paths(), ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1())))))).in((EndpointInput)package$.MODULE$.queryParams(), ParamConcat$.MODULE$.concatTupleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append2()))), TupleArity$.MODULE$.tupleArity2()))).in((EndpointInput)package$.MODULE$.headers(), ParamConcat$.MODULE$.concatTupleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append3()))), TupleArity$.MODULE$.tupleArity3()));
        Endpoint endpointOutput = (Endpoint)((EndpointOutputsOps)endpointInput.out(this.body(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).out((EndpointOutput)package$.MODULE$.statusCode(), ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1())))));
        return endpointOutput.serverLogic((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                byte[] requestBody = (byte[])tuple4._1();
                List paths = (List)tuple4._2();
                QueryParams queryParams = (QueryParams)tuple4._3();
                List headers = (List)tuple4._4();
                LazyRef lazyRef = new LazyRef();
                String requestId = Random$.MODULE$.id();
                None$ clientIp = None$.MODULE$;
                this.log.receivedRequest(() -> this.adapter$$anonfun$1$$anonfun$1(requestId, clientIp, lazyRef), this.log.receivedRequest$default$2());
                return Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.TryOps(Try$.MODULE$.apply(() -> this.adapter$$anonfun$1$$anonfun$2(requestBody, paths, queryParams, headers, requestId, clientIp, lazyRef))).foldError((Function1 & Serializable)error -> this.effectSystem().evaluate(() -> this.adapter$$anonfun$1$$anonfun$3$$anonfun$1(requestId, clientIp, error, lazyRef)))).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value), this.system);
            }
            throw new MatchError((Object)tuple4);
        }, $less$colon$less$.MODULE$.refl());
    }

    public TapirHttpEndpoint<Effect> withHandler(RequestHandler<Effect, HttpContext<BoxedUnit>> handler) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), handler);
    }

    private Tuple2<byte[], StatusCode> createErrorResponse(Throwable error, Option<String> clientIp, String requestId, Function0<Map<String, String>> requestProperties, MessageLog log) {
        log.failedProcessRequest(error, requestProperties, log.failedProcessRequest$default$3());
        byte[] message = Extensions$.MODULE$.StringOps(Extensions$.MODULE$.ThrowableOps(error).description()).toByteArray();
        int status = StatusCode$.MODULE$.InternalServerError();
        return this.createResponse(message, status, clientIp, requestId, log);
    }

    private Tuple2<byte[], StatusCode> createResponse(byte[] responseBody, int statusCode, Option<String> clientIp, String requestId, MessageLog log) {
        LazyRef lazyRef = new LazyRef();
        log.sendingResponse(() -> TapirHttpEndpoint.createResponse$$anonfun$1(statusCode, clientIp, requestId, lazyRef), log.sendingResponse$default$2());
        return Tuple2$.MODULE$.apply((Object)responseBody, (Object)new StatusCode(statusCode));
    }

    public <Effect> TapirHttpEndpoint<Effect> copy(EffectSystem<Effect> effectSystem, String pathPrefix, Option<HttpMethod> method, Function1<Throwable, Object> mapException, RequestHandler<Effect, HttpContext<BoxedUnit>> handler) {
        return new TapirHttpEndpoint<Effect>(effectSystem, pathPrefix, method, mapException, handler);
    }

    public <Effect> EffectSystem<Effect> copy$default$1() {
        return this.effectSystem();
    }

    public <Effect> String copy$default$2() {
        return this.pathPrefix();
    }

    public <Effect> Option<HttpMethod> copy$default$3() {
        return this.method();
    }

    public <Effect> Function1<Throwable, Object> copy$default$4() {
        return this.mapException();
    }

    public <Effect> RequestHandler<Effect, HttpContext<BoxedUnit>> copy$default$5() {
        return this.handler();
    }

    public EffectSystem<Effect> _1() {
        return this.effectSystem();
    }

    public String _2() {
        return this.pathPrefix();
    }

    public Option<HttpMethod> _3() {
        return this.method();
    }

    public Function1<Throwable, Object> _4() {
        return this.mapException();
    }

    public RequestHandler<Effect, HttpContext<BoxedUnit>> _5() {
        return this.handler();
    }

    private static final /* synthetic */ Endpoint $anonfun$1(String m) {
        return (Endpoint)package$.MODULE$.endpoint().method(m);
    }

    private static final Endpoint $anonfun$2() {
        return package$.MODULE$.endpoint();
    }

    private static final Endpoint $anonfun$4(Endpoint endpointMethod$2) {
        return endpointMethod$2;
    }

    private final Map requestProperties$lzyINIT1$1(String requestId$1, None$ clientIp$1, LazyRef requestProperties$lzy1$1) {
        Map map;
        LazyRef lazyRef = requestProperties$lzy1$1;
        synchronized (lazyRef) {
            map = (Map)(requestProperties$lzy1$1.initialized() ? requestProperties$lzy1$1.value() : requestProperties$lzy1$1.initialize(TapirHttpEndpoint$.MODULE$.getRequestProperties((Option<String>)clientIp$1, this.allowedMethod, requestId$1)));
        }
        return map;
    }

    private final Map requestProperties$1(String requestId$2, None$ clientIp$2, LazyRef requestProperties$lzy1$2) {
        return (Map)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : this.requestProperties$lzyINIT1$1(requestId$2, clientIp$2, requestProperties$lzy1$2));
    }

    private final Map adapter$$anonfun$1$$anonfun$1(String requestId$11, None$ clientIp$11, LazyRef requestProperties$lzy1$8) {
        return this.requestProperties$1(requestId$11, clientIp$11, requestProperties$lzy1$8);
    }

    private final Map adapter$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String requestId$12, None$ clientIp$12, LazyRef requestProperties$lzy1$9) {
        return this.requestProperties$1(requestId$12, clientIp$12, requestProperties$lzy1$9);
    }

    private static final byte[] $anonfun$6() {
        return Array$.MODULE$.emptyByteArray();
    }

    private static final int $anonfun$9() {
        return StatusCode$.MODULE$.Ok();
    }

    private final Object adapter$$anonfun$1$$anonfun$2(byte[] requestBody$1, List paths$1, QueryParams queryParams$1, List headers$2, String requestId$3, None$ clientIp$3, LazyRef requestProperties$lzy1$3) {
        HttpContext<BoxedUnit> requestContext = TapirHttpEndpoint$.MODULE$.getRequestContext((List<String>)((List)this.prefixPaths.$plus$plus((IterableOnce)paths$1)), queryParams$1, (List<Header>)headers$2, this.allowedMethod);
        Object handlerResult = this.handler().processRequest(requestBody$1, requestContext, requestId$3);
        return Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(handlerResult).either(this.system)).map((Function1 & Serializable)_$2 -> (Tuple2)_$2.fold((Function1 & Serializable)error -> this.createErrorResponse((Throwable)error, (Option<String>)clientIp$3, requestId$3, (Function0<Map<String, String>>)((Function0 & Serializable)() -> this.adapter$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(requestId$3, clientIp$3, requestProperties$lzy1$3)), this.log), (Function1 & Serializable)result -> {
            byte[] responseBody = (byte[])result.map((Function1 & Serializable)_$3 -> _$3.responseBody()).getOrElse(TapirHttpEndpoint::$anonfun$6);
            Object object = result.flatMap((Function1 & Serializable)_$4 -> _$4.exception()).map(this.mapException()).map((Function1 & Serializable)v1 -> new StatusCode(StatusCode$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)v1)))).getOrElse((Function0 & Serializable)() -> new StatusCode(TapirHttpEndpoint.$anonfun$9()));
            int statusCode = object == null ? BoxesRunTime.unboxToInt(null) : ((StatusCode)object).code();
            return this.createResponse(responseBody, statusCode, (Option<String>)clientIp$3, requestId$3, this.log);
        }), this.system);
    }

    private final Map adapter$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(String requestId$13, None$ clientIp$13, LazyRef requestProperties$lzy1$10) {
        return this.requestProperties$1(requestId$13, clientIp$13, requestProperties$lzy1$10);
    }

    private final Tuple2 adapter$$anonfun$1$$anonfun$3$$anonfun$1(String requestId$7, None$ clientIp$7, Throwable error$1, LazyRef requestProperties$lzy1$6) {
        return this.createErrorResponse(error$1, (Option<String>)clientIp$7, requestId$7, (Function0<Map<String, String>>)((Function0 & Serializable)() -> this.adapter$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(requestId$7, clientIp$7, requestProperties$lzy1$6)), this.log);
    }

    private static final ListMap responseProperties$lzyINIT1$1(int statusCode$2, Option clientIp$9, String requestId$9, LazyRef responseProperties$lzy1$1) {
        ListMap listMap;
        LazyRef lazyRef = responseProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (responseProperties$lzy1$1.initialized()) {
                object = responseProperties$lzy1$1.value();
            } else {
                Object[] objectArray = new Tuple2[3];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)requestId$9);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.client());
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)TapirHttpEndpoint$.MODULE$.clientAddress((Option<String>)clientIp$9));
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Status");
                objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)StatusCode$.MODULE$.toString$extension(statusCode$2));
                object = responseProperties$lzy1$1.initialize((Object)((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }
            listMap = (ListMap)object;
        }
        return listMap;
    }

    private static final ListMap responseProperties$1(int statusCode$3, Option clientIp$10, String requestId$10, LazyRef responseProperties$lzy1$2) {
        return (ListMap)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : TapirHttpEndpoint.responseProperties$lzyINIT1$1(statusCode$3, clientIp$10, requestId$10, responseProperties$lzy1$2));
    }

    private static final Map createResponse$$anonfun$1(int statusCode$4, Option clientIp$14, String requestId$14, LazyRef responseProperties$lzy1$3) {
        return TapirHttpEndpoint.responseProperties$1(statusCode$4, clientIp$14, requestId$14, responseProperties$lzy1$3);
    }

    public static final class MessageFormat
    implements CodecFormat,
    Product,
    Serializable {
        private final MediaType mediaType;

        public static MessageFormat apply(MediaType mediaType) {
            return TapirHttpEndpoint$MessageFormat$.MODULE$.apply(mediaType);
        }

        public static MessageFormat fromProduct(Product product) {
            return TapirHttpEndpoint$MessageFormat$.MODULE$.fromProduct(product);
        }

        public static MessageFormat unapply(MessageFormat messageFormat) {
            return TapirHttpEndpoint$MessageFormat$.MODULE$.unapply(messageFormat);
        }

        public MessageFormat(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MessageFormat)) return false;
            MessageFormat messageFormat = (MessageFormat)object;
            MediaType mediaType = this.mediaType();
            MediaType mediaType2 = messageFormat.mediaType();
            if (mediaType != null) {
                if (!mediaType.equals(mediaType2)) return false;
                return true;
            }
            if (mediaType2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MessageFormat;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MessageFormat";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "mediaType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MediaType mediaType() {
            return this.mediaType;
        }

        public MessageFormat copy(MediaType mediaType) {
            return new MessageFormat(mediaType);
        }

        public MediaType copy$default$1() {
            return this.mediaType();
        }

        public MediaType _1() {
            return this.mediaType();
        }
    }
}

