/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.auth.google.config;

import jakarta.servlet.Filter;
import org.autumnframework.auth.google.properties.AutumnAuthProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Autowired
    private AutumnAuthProperties properties;

    private ClientRegistration getRegistration() {
        return CommonOAuth2Provider.GOOGLE.getBuilder("google").clientId(this.properties.getClientid()).clientSecret(this.properties.getClientsecret()).build();
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.getRegistration()});
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(this.properties.getIgnoringrequestmatchers())).permitAll().requestMatchers(this.properties.getAuthorizerequestmatchers())).authenticated()).oauth2Login(oauth2Login -> oauth2Login.loginPage("/oauth2/authorization/google")).oauth2Client(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    FilterRegistrationBean<ForwardedHeaderFilter> forwardedHeaderFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new ForwardedHeaderFilter());
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        return filterRegistrationBean;
    }
}

