/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.auth.google.properties;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="org.autumnframework.auth.google")
@Validated
public class AutumnAuthProperties {
    @NotNull(message="Please supply a client id when importing SecurityConfig")
    private @NotNull(message="Please supply a client id when importing SecurityConfig") String clientid;
    @NotNull(message="Please supply a client secret when importing SecurityConfig")
    private @NotNull(message="Please supply a client secret when importing SecurityConfig") String clientsecret;
    private String[] authorizerequestmatchers = new String[]{"/**"};
    private String[] ignoringrequestmatchers = new String[0];
    private String logoutsuccessurl = "/";
    private String logouturl = "/logout";
    private String tokenInfoUri = "https://www.googleapis.com/oauth2/v3/tokeninfo";
    private String userInfoUri = "https://www.googleapis.com/oauth2/v3/userinfo";

    public String getClientid() {
        return this.clientid;
    }

    public String getClientsecret() {
        return this.clientsecret;
    }

    public String[] getAuthorizerequestmatchers() {
        return this.authorizerequestmatchers;
    }

    public String[] getIgnoringrequestmatchers() {
        return this.ignoringrequestmatchers;
    }

    public String getLogoutsuccessurl() {
        return this.logoutsuccessurl;
    }

    public String getLogouturl() {
        return this.logouturl;
    }

    public String getTokenInfoUri() {
        return this.tokenInfoUri;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public void setClientsecret(String clientsecret) {
        this.clientsecret = clientsecret;
    }

    public void setAuthorizerequestmatchers(String[] authorizerequestmatchers) {
        this.authorizerequestmatchers = authorizerequestmatchers;
    }

    public void setIgnoringrequestmatchers(String[] ignoringrequestmatchers) {
        this.ignoringrequestmatchers = ignoringrequestmatchers;
    }

    public void setLogoutsuccessurl(String logoutsuccessurl) {
        this.logoutsuccessurl = logoutsuccessurl;
    }

    public void setLogouturl(String logouturl) {
        this.logouturl = logouturl;
    }

    public void setTokenInfoUri(String tokenInfoUri) {
        this.tokenInfoUri = tokenInfoUri;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutumnAuthProperties)) {
            return false;
        }
        AutumnAuthProperties other = (AutumnAuthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientid = this.getClientid();
        String other$clientid = other.getClientid();
        if (this$clientid == null ? other$clientid != null : !this$clientid.equals(other$clientid)) {
            return false;
        }
        String this$clientsecret = this.getClientsecret();
        String other$clientsecret = other.getClientsecret();
        if (this$clientsecret == null ? other$clientsecret != null : !this$clientsecret.equals(other$clientsecret)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthorizerequestmatchers(), other.getAuthorizerequestmatchers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIgnoringrequestmatchers(), other.getIgnoringrequestmatchers())) {
            return false;
        }
        String this$logoutsuccessurl = this.getLogoutsuccessurl();
        String other$logoutsuccessurl = other.getLogoutsuccessurl();
        if (this$logoutsuccessurl == null ? other$logoutsuccessurl != null : !this$logoutsuccessurl.equals(other$logoutsuccessurl)) {
            return false;
        }
        String this$logouturl = this.getLogouturl();
        String other$logouturl = other.getLogouturl();
        if (this$logouturl == null ? other$logouturl != null : !this$logouturl.equals(other$logouturl)) {
            return false;
        }
        String this$tokenInfoUri = this.getTokenInfoUri();
        String other$tokenInfoUri = other.getTokenInfoUri();
        if (this$tokenInfoUri == null ? other$tokenInfoUri != null : !this$tokenInfoUri.equals(other$tokenInfoUri)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        return !(this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutumnAuthProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientid = this.getClientid();
        result = result * 59 + ($clientid == null ? 43 : $clientid.hashCode());
        String $clientsecret = this.getClientsecret();
        result = result * 59 + ($clientsecret == null ? 43 : $clientsecret.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAuthorizerequestmatchers());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoringrequestmatchers());
        String $logoutsuccessurl = this.getLogoutsuccessurl();
        result = result * 59 + ($logoutsuccessurl == null ? 43 : $logoutsuccessurl.hashCode());
        String $logouturl = this.getLogouturl();
        result = result * 59 + ($logouturl == null ? 43 : $logouturl.hashCode());
        String $tokenInfoUri = this.getTokenInfoUri();
        result = result * 59 + ($tokenInfoUri == null ? 43 : $tokenInfoUri.hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
        return result;
    }

    public String toString() {
        return "AutumnAuthProperties(clientid=" + this.getClientid() + ", clientsecret=" + this.getClientsecret() + ", authorizerequestmatchers=" + Arrays.deepToString(this.getAuthorizerequestmatchers()) + ", ignoringrequestmatchers=" + Arrays.deepToString(this.getIgnoringrequestmatchers()) + ", logoutsuccessurl=" + this.getLogoutsuccessurl() + ", logouturl=" + this.getLogouturl() + ", tokenInfoUri=" + this.getTokenInfoUri() + ", userInfoUri=" + this.getUserInfoUri() + ")";
    }
}

