/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.auth.google.config;

import jakarta.servlet.Filter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.autumnframework.auth.google.properties.AutumnAuthProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Configuration
@EnableWebSecurity
@EnableConfigurationProperties(value={AutumnAuthProperties.class})
public class SecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Autowired
    private AutumnAuthProperties properties;
    private ClientRegistrationRepository clientRegistrationRepository;

    private OpaqueTokenIntrospector googleIntrospector() {
        return new GoogleIntrospector(this.properties.getTokenInfoUri(), this.properties.getUserInfoUri(), this.properties.getClientid(), this.properties.getClientsecret());
    }

    private ClientRegistration getRegistration() {
        return CommonOAuth2Provider.GOOGLE.getBuilder("google").clientId(this.properties.getClientid()).clientSecret(this.properties.getClientsecret()).build();
    }

    private OidcUserService googleUserService() {
        HashSet<String> googleScopes = new HashSet<String>();
        googleScopes.add("https://www.googleapis.com/auth/userinfo.email");
        googleScopes.add("https://www.googleapis.com/auth/userinfo.profile");
        OidcUserService googleUserService = new OidcUserService();
        googleUserService.setAccessibleScopes(googleScopes);
        return googleUserService;
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        this.clientRegistrationRepository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.getRegistration()});
        return this.clientRegistrationRepository;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        log.info("Securing all requests for {}, except {}", (Object)this.properties.getAuthorizerequestmatchers(), (Object)this.properties.getIgnoringrequestmatchers());
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(this.properties.getAuthorizerequestmatchers())).authenticated().requestMatchers(this.properties.getIgnoringrequestmatchers())).permitAll()).csrf(csrf -> csrf.ignoringRequestMatchers(new String[]{this.properties.getLogouturl()})).oauth2Client(Customizer.withDefaults()).oauth2Login(oauthLogin -> oauthLogin.userInfoEndpoint(userInfo -> userInfo.oidcUserService((OAuth2UserService)this.googleUserService())).loginPage("/oauth2/authorization/google")).oauth2ResourceServer(res -> res.opaqueToken(token -> token.introspector(this.googleIntrospector()))).logout(logout -> logout.logoutSuccessUrl(this.properties.getLogoutsuccessurl()));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    FilterRegistrationBean<ForwardedHeaderFilter> forwardedHeaderFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new ForwardedHeaderFilter());
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        return filterRegistrationBean;
    }

    private class GoogleIntrospector
    implements OpaqueTokenIntrospector {
        private final RestOperations restOperations;
        private Converter<String, RequestEntity<?>> introspectionRequestEntityConverter;
        private Converter<String, RequestEntity<?>> userInfoRequestEntityConverter;

        public GoogleIntrospector(String introspectionUri, String userInfoUri, String clientId, String clientSecret) {
            this.introspectionRequestEntityConverter = this.introspectionRequestEntityConverter(URI.create(introspectionUri));
            this.userInfoRequestEntityConverter = this.userInfoRequestEntityConverter(URI.create(userInfoUri));
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(clientId, clientSecret));
            this.restOperations = restTemplate;
        }

        public OAuth2AuthenticatedPrincipal introspect(String token) {
            RequestEntity requestEntity = (RequestEntity)this.introspectionRequestEntityConverter.convert((Object)token);
            if (requestEntity == null) {
                throw new OAuth2IntrospectionException("requestEntityConverter returned a null entity");
            }
            GoogleIntrospectionResponse googleIntrospectionResponse = (GoogleIntrospectionResponse)this.makeRequest(requestEntity).getBody();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.putAll(this.getAttributes(googleIntrospectionResponse));
            List<GrantedAuthority> authorities = this.parseScopeAuthorities(googleIntrospectionResponse.scope, attributes);
            authorities.add((GrantedAuthority)new OAuth2UserAuthority("ROLE_USER", attributes));
            requestEntity = (RequestEntity)this.userInfoRequestEntityConverter.convert((Object)token);
            GoogleUserInfoResponse googleUserInfoResponse = (GoogleUserInfoResponse)this.makeUserInfoRequest(requestEntity).getBody();
            attributes.putAll(this.getAttributes(googleUserInfoResponse));
            return new OAuth2IntrospectionAuthenticatedPrincipal(attributes, authorities);
        }

        private Converter<String, RequestEntity<?>> introspectionRequestEntityConverter(URI introspectionUri) {
            return token -> {
                HttpHeaders headers = this.requestHeaders();
                MultiValueMap<String, String> body = this.requestBody((String)token);
                return new RequestEntity(body, (MultiValueMap)headers, HttpMethod.POST, introspectionUri);
            };
        }

        private HttpHeaders requestHeaders() {
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            return headers;
        }

        private MultiValueMap<String, String> requestBody(String token) {
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"access_token", (Object)token);
            return body;
        }

        private ResponseEntity<GoogleIntrospectionResponse> makeRequest(RequestEntity<?> requestEntity) {
            try {
                return this.restOperations.exchange(requestEntity, GoogleIntrospectionResponse.class);
            }
            catch (Exception ex) {
                throw new OAuth2IntrospectionException(ex.getMessage(), (Throwable)ex);
            }
        }

        private Converter<String, RequestEntity<?>> userInfoRequestEntityConverter(URI userInfoUri) {
            return token -> {
                HttpHeaders headers = this.requestUserInfoHeaders((String)token);
                return new RequestEntity(null, (MultiValueMap)headers, HttpMethod.GET, userInfoUri);
            };
        }

        private HttpHeaders requestUserInfoHeaders(String token) {
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            headers.setBearerAuth(token);
            return headers;
        }

        private ResponseEntity<GoogleUserInfoResponse> makeUserInfoRequest(RequestEntity<?> requestEntity) {
            try {
                return this.restOperations.exchange(requestEntity, GoogleUserInfoResponse.class);
            }
            catch (Exception ex) {
                throw new OAuth2IntrospectionException(ex.getMessage(), (Throwable)ex);
            }
        }

        private Map<String, Object> getAttributes(GoogleIntrospectionResponse googleIntrospectionResponse) {
            return Map.of("aud", googleIntrospectionResponse.aud, "sub", googleIntrospectionResponse.sub, "email", googleIntrospectionResponse.email, "email_verified", googleIntrospectionResponse.email_verified);
        }

        private Map<String, Object> getAttributes(final GoogleUserInfoResponse googleUserInfoResponse) {
            return new HashMap<String, Object>(){
                private static final long serialVersionUID = -2271300289073166974L;
                {
                    this.put("sub", googleUserInfoResponse.sub);
                    this.put("name", googleUserInfoResponse.name);
                    this.put("given_name", googleUserInfoResponse.given_name);
                    this.put("family_name", googleUserInfoResponse.family_name);
                    this.put("picture", googleUserInfoResponse.picture);
                    this.put("locale", googleUserInfoResponse.locale);
                    this.put("hd", googleUserInfoResponse.hd);
                }
            };
        }

        private List<GrantedAuthority> parseScopeAuthorities(String oauth2Scopes, Map<String, Object> attributes) {
            String[] scopes = oauth2Scopes.split(" ");
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            for (String scope : scopes) {
                authorities.add((GrantedAuthority)new OAuth2UserAuthority("SCOPE_" + scope, attributes));
            }
            return authorities;
        }

        private record GoogleIntrospectionResponse(String azp, String aud, String sub, String scope, String exp, String expires_in, String email, String email_verified, String access_type) {
        }

        private record GoogleUserInfoResponse(String sub, String name, String given_name, String family_name, String picture, String email, String email_verified, String locale, String hd) {
        }
    }
}

