/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services;

import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.elementary.CreateService;
import org.autumnframework.service.jpa.services.elementary.DeleteByApiIdService;
import org.autumnframework.service.jpa.services.elementary.DeleteByIdService;
import org.autumnframework.service.jpa.services.elementary.ReadFindAllModifiedBetweenService;
import org.autumnframework.service.jpa.services.elementary.ReadFindAllModifiedSinceService;
import org.autumnframework.service.jpa.services.elementary.ReadFindAllService;
import org.autumnframework.service.jpa.services.elementary.ReadFindByApiIdService;
import org.autumnframework.service.jpa.services.elementary.ReadFindByApiIdsService;
import org.autumnframework.service.jpa.services.elementary.ReadFindByIdService;
import org.autumnframework.service.jpa.services.elementary.StreamingReadFindAllService;
import org.autumnframework.service.jpa.services.elementary.UpdateService;

/**
 * A convenience full service, which can be used to include all the standard services that we have
 * @param <T>
 */
public interface FullApiService<T extends JpaApiIdentifiable> extends CreateService<T>,
                                                                ReadFindByIdService<T>,
                                                                ReadFindAllService<T>,
                                                                ReadFindByApiIdService<T>,
                                                                ReadFindByApiIdsService<T>,
                                                                ReadFindAllModifiedSinceService<T>,
                                                                ReadFindAllModifiedBetweenService<T>,
                                                                UpdateService<T>,
                                                                DeleteByIdService<T>,
                                                                DeleteByApiIdService<T>,
                                                                StreamingReadFindAllService<T> {
    //
}
