/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.elementary;

import org.autumnframework.service.jpa.services.genericdefault.GenericJpaCreateService;
import org.autumnframework.service.jpa.identifiable.JpaIdentifiable;
import org.autumnframework.service.jpa.services.elementary.shared.GetRepositoryService;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.UUID;

/**
 * Our standard CreateService which uses a repository that uses Long id's
 *
 * @param <T>
 */
public interface CreateService<T extends JpaIdentifiable> extends GetRepositoryService<T>,
                                                                  GenericJpaCreateService<T, Long, EventMetaData> {

    Logger log = LoggerFactory.getLogger(CreateService.class);

    /**
     * Our standard implementation always supplies a message chain id, if non was received, we start the chain here.
     * @param t
     * @return
     */
    @Override
    default T create(T t) {
        UUID messageChainId = UUID.randomUUID();

        log.debug("Create entity: {}, initiating new message chain id: {}", t.getClass().getSimpleName(), messageChainId);

        return GenericJpaCreateService.super.create(t, EventMetaData.builder()
                                                                       .messageChainId(messageChainId)
                                                                       .build());
    }
}
