/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.time.LocalDateTime;
import java.util.stream.Stream;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetApiRepositoryService;
import org.autumnframework.service.services.GenericAuditedReadFindAllService;

public interface ReadFindAllModifiedSinceService<T extends JpaApiIdentifiable>
        extends GenericJpaGetApiRepositoryService<T>, GenericAuditedReadFindAllService<T, Long>,
        ReadFindAllService<T> {

    @Override
    @Transactional(readOnly = true)
    default Page<T> findAllModifiedSince(LocalDateTime date, Pageable page) {
        return this.getRepository().findAllByLastModifiedDateAfter(date, page);
    }

    @Override
    @Transactional(readOnly = true)
    default Stream<T> streamAllModifiedSince(LocalDateTime date) {
        return this.getRepository().streamAllByLastModifiedDateAfterOrderByCreationDate(date);
    }
}
