/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.elementary;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import org.autumnframework.service.jpa.identifiable.JpaIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericReadFindAllService;

/**
 * Our standard find all service which uses a repository that uses Long id's
 * @param <T>
 */
public interface ReadFindAllService<T extends JpaIdentifiable> extends GenericJpaGetRepositoryService<T, Long>,
                                                                       GenericReadFindAllService<T, Long> {

    @Override
    @Transactional(readOnly = true)
    default Page<T> findAll(Pageable page) {
        return this.getRepository().findAll(page);
    }
    
}
