/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.elementary.shared.GetApiRepositoryService;

/**
 * Our standard find by api ids service  which uses an API repository, which has an extra findByApiIds
 *
 * Because the most generic services facilitate no support for finding an entity by anything else than it's own id, we
 * need to implement it here to make it part of our more specific Jpa service implementation
 *
 * @param <T>
 */
public interface ReadFindByApiIdsService<T extends JpaApiIdentifiable> extends GetApiRepositoryService<T> {

    Logger log = LoggerFactory.getLogger(ReadFindByApiIdsService.class);

    default List<T> findByApiIds(List<UUID> ids) {
        log.trace("Find by api ids: {}", ids);
        return this.getRepository().findByApiIdIn(ids);
    }

}

