/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericReadFindAllService;

/**
 * Provides a default implementation of the findAll service
 * @param <T>
 */
public interface GenericJpaReadFindAllService<  T extends GenericIdentifiable<ID>,
                                                ID extends Serializable> extends GenericJpaGetRepositoryService<T, ID>,
                                                                                 GenericReadFindAllService<T, ID> {

    Logger log = LoggerFactory.getLogger(GenericJpaReadFindAllService.class);

    @Override
    default Page<T> findAll(Pageable page) {
        log.trace("Finding all with page: {}", page);

        return this.getRepository().findAll(page);
    }

}
