/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericReadFindByIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.Optional;

public interface GenericJpaReadFindByIdService<  T extends GenericIdentifiable<ID>,
                                                ID extends Serializable> extends GenericJpaGetRepositoryService<T, ID>,
                                                                                 GenericReadFindByIdService<T, ID> {

    Logger log = LoggerFactory.getLogger(GenericJpaReadFindByIdService.class);

    @Override
    @Transactional(readOnly = true)
    default Optional<T> findById(ID id) {
        log.trace("Find by id: {}", id);

        return this.getRepository().findById(id);
    }

}

