/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericReadFindByIdsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.List;

/**
 * Provides a generic implementation of the find by ids
 * @param <T>
 * @param <ID>
 */
public interface GenericJpaReadFindByIdsService<  T extends GenericIdentifiable<ID>,
                                                 ID extends Serializable> extends GenericJpaGetRepositoryService<T, ID>,
                                                                                  GenericReadFindByIdsService<T, ID> {

    Logger log = LoggerFactory.getLogger(GenericJpaReadFindByIdsService.class);

    @Override
    @Transactional(readOnly = true)
    default List<T> findByIds(List<ID> ids) {
        log.trace("findByIds: {}", ids);
        return this.getRepository().findAllById(ids);
    }

}

