/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import java.io.Serializable;
import java.util.stream.Stream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetApiRepositoryService;
import org.autumnframework.service.services.GenericStreamingReadFindAllService;

/**
 * Provides a default implementation of the findAll service
 * @param <T>
 */
public interface GenericJpaStreamingReadFindAllService<  T extends JpaApiIdentifiable,
                                                ID extends Serializable> extends GenericJpaGetApiRepositoryService<T>,
                                                                                 GenericStreamingReadFindAllService<T, Long> {

    Logger log = LoggerFactory.getLogger(GenericJpaStreamingReadFindAllService.class);

    @Override
    @Transactional(readOnly = true)
    default Stream<T> streamAll() {
        log.trace("Streaming all");

        return this.getRepository().streamAllByOrderByCreationDate();
    }
}
