/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.implementation;

import java.util.List;

import lombok.Getter;
import org.autumnframework.service.event.listeners.generic.GenericOnCreateListener;
import org.autumnframework.service.event.listeners.generic.GenericOnDeleteListener;
import org.autumnframework.service.event.listeners.generic.GenericOnUpdateListener;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.repositories.JpaApiRepository;
import org.autumnframework.service.jpa.services.FullApiService;

@Getter
public abstract class StandardApiService<  T extends JpaApiIdentifiable,
                                           R extends JpaApiRepository<T>> extends StandardService<T, R> implements FullApiService<T> {


    /**
     * Spring is smart enough to find all beans that implement one of the listeners for this entity type and
     * will provide you with an autowired list
     *
     * @param repository
     * @param onCreateListeners
     * @param onDeleteListeners
     * @param onUpdateListeners
     */
    public StandardApiService(R repository,
                              List<GenericOnCreateListener<T, Long, EventMetaData>> onCreateListeners,
                              List<GenericOnDeleteListener<T, Long, EventMetaData>> onDeleteListeners,
                              List<GenericOnUpdateListener<T, Long, EventMetaData>> onUpdateListeners) {
        super(repository, onCreateListeners, onDeleteListeners, onUpdateListeners);
    }
}
