/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.jpa.services.implementation;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import org.autumnframework.service.event.listeners.generic.GenericOnCreateListener;
import org.autumnframework.service.event.listeners.generic.GenericOnDeleteListener;
import org.autumnframework.service.event.listeners.generic.GenericOnUpdateListener;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.autumnframework.service.jpa.identifiable.JpaIdentifiable;
import org.autumnframework.service.jpa.repositories.JpaRepository;
import org.autumnframework.service.jpa.services.FullService;

@Getter
public abstract class StandardService<  T extends JpaIdentifiable,
                                        R extends JpaRepository<T>> implements FullService<T> {

    private final R repository;

    private final List<GenericOnCreateListener<T, Long, EventMetaData>> onCreateListeners;
    private final List<GenericOnDeleteListener<T, Long, EventMetaData>> onDeleteListeners;
    private final List<GenericOnUpdateListener<T, Long, EventMetaData>> onUpdateListeners;

    /**
     * Spring is smart enough to find all beans that implement one of the listeners for this entity type and
     * will provide you with an autowired list
     *
     * @param repository
     * @param onCreateListeners
     * @param onDeleteListeners
     * @param onUpdateListeners
     */
    public StandardService(R repository,
                           List<GenericOnCreateListener<T, Long, EventMetaData>> onCreateListeners,
                           List<GenericOnDeleteListener<T, Long, EventMetaData>> onDeleteListeners,
                           List<GenericOnUpdateListener<T, Long, EventMetaData>> onUpdateListeners) {
        this.repository = repository;
        this.onCreateListeners = new ArrayList<>(onCreateListeners);
        this.onDeleteListeners = new ArrayList<>(onDeleteListeners);
        this.onUpdateListeners = new ArrayList<>(onUpdateListeners);
    }

    @Override
    public R getRepository() {
        return this.repository;
    }

}
