/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.util.UUID;
import org.autumnframework.service.jpa.entities.AbstractBaseEntity;
import org.autumnframework.service.jpa.entities.ApiEntity;

@MappedSuperclass
public abstract class AbstractApiBaseEntity
extends AbstractBaseEntity
implements ApiEntity {
    private static final long serialVersionUID = 1L;
    @Column(unique=true)
    private UUID apiId;

    @PrePersist
    @PreUpdate
    public void preSave() {
        if (this.getApiId() == null) {
            this.setApiId(UUID.randomUUID());
        }
    }

    public AbstractApiBaseEntity(UUID apiId) {
        this.apiId = apiId;
    }

    public AbstractApiBaseEntity() {
    }

    @Override
    public UUID getApiId() {
        return this.apiId;
    }

    @Override
    public void setApiId(UUID apiId) {
        this.apiId = apiId;
    }
}

