/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDateTime;
import org.autumnframework.service.identifiable.GenericApiIdentifiable;
import org.autumnframework.service.jpa.identifiable.JpaIdentifiable;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
public abstract class AbstractBaseEntity
implements JpaIdentifiable,
GenericApiIdentifiable<Long> {
    private static final long serialVersionUID = 1L;
    @CreatedDate
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false, updatable=false)
    protected LocalDateTime creationDate;
    @LastModifiedDate
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    protected LocalDateTime lastModifiedDate;

    public AbstractBaseEntity(LocalDateTime creationDate, LocalDateTime lastModifiedDate) {
        this.creationDate = creationDate;
        this.lastModifiedDate = lastModifiedDate;
    }

    public AbstractBaseEntity() {
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public LocalDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setLastModifiedDate(LocalDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

