/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.repositories;

import jakarta.persistence.QueryHint;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.repositories.JpaRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.QueryHints;

public interface JpaApiRepository<T extends JpaApiIdentifiable>
extends JpaRepository<T> {
    public Optional<T> findByApiId(UUID var1);

    public List<T> findByApiIdIn(Collection<UUID> var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="1"), @QueryHint(name="org.hibernate.cacheable", value="false"), @QueryHint(name="org.hibernate.readOnly", value="true")})
    public Stream<T> streamAllByOrderByCreationDate();

    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="1"), @QueryHint(name="org.hibernate.cacheable", value="false"), @QueryHint(name="org.hibernate.readOnly", value="true")})
    public Stream<T> streamAllByLastModifiedDateAfterOrderByCreationDate(LocalDateTime var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="1"), @QueryHint(name="org.hibernate.cacheable", value="false"), @QueryHint(name="org.hibernate.readOnly", value="true")})
    public Stream<T> streamAllByLastModifiedDateBetweenOrderByCreationDate(LocalDateTime var1, LocalDateTime var2);

    public Page<T> findAllByLastModifiedDateAfter(LocalDateTime var1, Pageable var2);

    public Page<T> findAllByLastModifiedDateBetween(LocalDateTime var1, LocalDateTime var2, Pageable var3);
}

